/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.dialog.view;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;
import org.jiemamy.JiemamyFactory;
import org.jiemamy.JiemamyProperty;
import org.jiemamy.eclipse.JiemamyUIPlugin;
import org.jiemamy.eclipse.editor.dialog.view.Messages;
import org.jiemamy.eclipse.ui.JiemamyEditDialog;
import org.jiemamy.eclipse.ui.helper.TextSelectionAdapter;
import org.jiemamy.eclipse.ui.tab.TextEditTab;
import org.jiemamy.eclipse.utils.ConvertUtil;
import org.jiemamy.facade.JiemamyViewFacade;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.entity.ViewModel;
import org.jiemamy.model.node.NodeAdapter;
import org.jiemamy.utils.Disablable;
import org.jiemamy.utils.model.JiemamyPropertyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewEditDialog
extends JiemamyEditDialog<ViewModel> {
    private static final Point DEFAULT_SIZE = new Point(598, 370);
    private Text txtName;
    private Text txtLogicalName;
    private TextEditTab tabDefinition;
    private TextEditTab tabBeginScript;
    private TextEditTab tabEndScript;
    private TextEditTab tabDescription;
    private final int diagramIndex;
    private final JiemamyViewFacade jiemamyFacade;

    public ViewEditDialog(Shell shell, ViewModel viewModel, int diagramIndex, JiemamyViewFacade jiemamyFacade) {
        super(shell, viewModel, ViewModel.class);
        Validate.notNull((Object)viewModel);
        Validate.notNull((Object)jiemamyFacade);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.diagramIndex = diagramIndex;
        this.jiemamyFacade = jiemamyFacade;
    }

    @Override
    protected boolean canExecuteOk() {
        return !StringUtils.isEmpty((String)this.tabDefinition.getTextWidget().getText()) && !StringUtils.isEmpty((String)this.txtName.getText()) && super.canExecuteOk();
    }

    protected Control createDialogArea(Composite parent) {
        final ViewModel viewModel = (ViewModel)this.getTargetModel();
        this.getShell().setText(Messages.Dialog_Title);
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(7, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.Label_View_Name);
        this.txtName = new Text(composite, 2048);
        this.txtName.setLayoutData((Object)new GridData(768));
        this.txtName.setText(JiemamyPropertyUtil.careNull((String)viewModel.getName()));
        this.txtName.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtName));
        this.txtName.addKeyListener((KeyListener)this.editListener);
        label = new Label(composite, 0);
        label.setText(Messages.Label_View_LogicalName);
        this.txtLogicalName = new Text(composite, 2048);
        this.txtLogicalName.setLayoutData((Object)new GridData(768));
        this.txtLogicalName.setText(JiemamyPropertyUtil.careNull((String)viewModel.getLogicalName()));
        this.txtLogicalName.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtLogicalName));
        this.txtLogicalName.addKeyListener((KeyListener)this.editListener);
        ImageRegistry ir = JiemamyUIPlugin.getDefault().getImageRegistry();
        Button btnColor = new Button(composite, 8);
        btnColor.setImage(ir.get("ICON_COLOR_PALETTE"));
        btnColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ColorDialog colorDialog = new ColorDialog(ViewEditDialog.this.getShell(), 0);
                RGB rgb = colorDialog.open();
                if (rgb != null) {
                    NodeAdapter nodeAdapter = (NodeAdapter)viewModel.getAdapter(NodeAdapter.class);
                    ViewEditDialog.this.jiemamyFacade.setColor(ViewEditDialog.this.diagramIndex, nodeAdapter, ConvertUtil.convert(rgb));
                }
            }
        });
        Button btnDefaultColor = new Button(composite, 8);
        btnDefaultColor.setText("default color");
        btnDefaultColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                NodeAdapter nodeAdapter = (NodeAdapter)viewModel.getAdapter(NodeAdapter.class);
                ViewEditDialog.this.jiemamyFacade.setColor(ViewEditDialog.this.diagramIndex, nodeAdapter, null);
            }
        });
        final Button btnDisable = new Button(composite, 32);
        btnDisable.setText("\u7121\u52b9(&G)");
        btnDisable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (!viewModel.hasAdapter(Disablable.class)) {
                    JiemamyFactory factory = viewModel.getJiemamy().getFactory();
                    viewModel.registerAdapter(factory.newAdapter(Disablable.class));
                }
                ((Disablable)viewModel.getAdapter(Disablable.class)).setDisabled(Boolean.valueOf(btnDisable.getSelection()));
            }
        });
        if (viewModel.hasAdapter(Disablable.class) && Boolean.TRUE.equals(((Disablable)viewModel.getAdapter(Disablable.class)).isDisabled())) {
            btnDisable.setSelection(true);
        }
        label = new Label(composite, 0);
        label.setText(Messages.Message);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 6;
        label.setLayoutData((Object)gd);
        TabFolder tabFolder = new TabFolder(composite, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 7;
        tabFolder.setLayoutData((Object)gd);
        this.createTabs(viewModel, tabFolder);
        return composite;
    }

    @Override
    protected Point getDefaultSize() {
        return DEFAULT_SIZE;
    }

    @Override
    protected boolean performOk() {
        ViewModel viewModel = (ViewModel)this.getTargetModel();
        String name = JiemamyPropertyUtil.careNull((String)this.txtName.getText(), (boolean)false);
        this.jiemamyFacade.changeModelProperty((JiemamyElement)viewModel, (JiemamyProperty)JiemamyProperty.EntityProperty.name, (Object)name);
        String logicalName = JiemamyPropertyUtil.careNull((String)this.txtLogicalName.getText(), (boolean)true);
        this.jiemamyFacade.changeModelProperty((JiemamyElement)viewModel, (JiemamyProperty)JiemamyProperty.EntityProperty.logicalName, (Object)logicalName);
        String definition = JiemamyPropertyUtil.careNull((String)this.tabDefinition.getTextWidget().getText(), (boolean)false);
        this.jiemamyFacade.changeModelProperty((JiemamyElement)viewModel, (JiemamyProperty)JiemamyProperty.ViewProperty.definition, (Object)definition);
        String beginScript = JiemamyPropertyUtil.careNull((String)this.tabBeginScript.getTextWidget().getText(), (boolean)true);
        this.jiemamyFacade.changeModelProperty((JiemamyElement)viewModel, (JiemamyProperty)JiemamyProperty.EntityProperty.beginScript, (Object)beginScript);
        String endScript = JiemamyPropertyUtil.careNull((String)this.tabEndScript.getTextWidget().getText(), (boolean)true);
        this.jiemamyFacade.changeModelProperty((JiemamyElement)viewModel, (JiemamyProperty)JiemamyProperty.EntityProperty.endScript, (Object)endScript);
        String description = JiemamyPropertyUtil.careNull((String)this.tabDescription.getTextWidget().getText(), (boolean)true);
        this.jiemamyFacade.changeModelProperty((JiemamyElement)viewModel, (JiemamyProperty)JiemamyProperty.EntityProperty.description, (Object)description);
        return true;
    }

    private void createTabs(ViewModel viewModel, TabFolder tabFolder) {
        String definition = JiemamyPropertyUtil.careNull((String)viewModel.getDefinition());
        this.tabDefinition = new TextEditTab(tabFolder, Messages.Tab_View_Definition, definition);
        this.tabDefinition.addKeyListener(this.editListener);
        this.addTab(this.tabDefinition);
        String beginScript = JiemamyPropertyUtil.careNull((String)viewModel.getBeginScript());
        this.tabBeginScript = new TextEditTab(tabFolder, Messages.Tab_View_BeginScript, beginScript);
        this.tabBeginScript.addKeyListener(this.editListener);
        this.addTab(this.tabBeginScript);
        String endScript = JiemamyPropertyUtil.careNull((String)viewModel.getEndScript());
        this.tabEndScript = new TextEditTab(tabFolder, Messages.Tab_View_EndScript, endScript);
        this.tabEndScript.addKeyListener(this.editListener);
        this.addTab(this.tabEndScript);
        String description = JiemamyPropertyUtil.careNull((String)viewModel.getDescription());
        this.tabDescription = new TextEditTab(tabFolder, Messages.Tab_View_Description, description);
        this.tabDefinition.addKeyListener(this.editListener);
        this.addTab(this.tabDescription);
        this.createAdditionalTabs(tabFolder);
    }
}

