/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.dialog.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.jiemamy.EventBroker;
import org.jiemamy.Jiemamy;
import org.jiemamy.JiemamyFactory;
import org.jiemamy.ReferenceResolver;
import org.jiemamy.eclipse.JiemamyUIPlugin;
import org.jiemamy.eclipse.editor.dialog.AbstractEditListener;
import org.jiemamy.eclipse.editor.dialog.EditListener;
import org.jiemamy.eclipse.editor.dialog.table.Messages;
import org.jiemamy.eclipse.ui.AbstractTableEditor;
import org.jiemamy.eclipse.ui.DefaultTableEditorConfig;
import org.jiemamy.eclipse.ui.helper.TextSelectionAdapter;
import org.jiemamy.eclipse.ui.tab.AbstractTab;
import org.jiemamy.editcommand.Command;
import org.jiemamy.editcommand.CommandListener;
import org.jiemamy.facade.JiemamyFacade;
import org.jiemamy.model.ElementReference;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.attribute.AttributeModel;
import org.jiemamy.model.attribute.ColumnModel;
import org.jiemamy.model.attribute.ColumnRef;
import org.jiemamy.model.attribute.constraint.LocalKeyConstraint;
import org.jiemamy.model.attribute.constraint.PrimaryKey;
import org.jiemamy.model.attribute.constraint.UniqueKey;
import org.jiemamy.model.entity.TableModel;
import org.jiemamy.utils.CollectionsUtil;
import org.jiemamy.utils.LogMarker;
import org.jiemamy.utils.model.JiemamyPropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class TableEditDialogLocalKeyTab
extends AbstractTab {
    private static Logger logger = LoggerFactory.getLogger(TableEditDialogLocalKeyTab.class);
    private final TableModel tableModel;
    private AbstractTableEditor localKeyTableEditor;
    private final JiemamyFacade jiemamyFacade;

    public TableEditDialogLocalKeyTab(TabFolder parentTabFolder, int style, TableModel tableModel, JiemamyFacade jiemamyFacade) {
        super(parentTabFolder, style, Messages.Tab_Table_Keys);
        this.tableModel = tableModel;
        this.jiemamyFacade = jiemamyFacade;
        Composite composite = new Composite((Composite)parentTabFolder, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.localKeyTableEditor = new LocalKeyConstraintTableEditor(composite, 0);
        this.localKeyTableEditor.configure();
        this.localKeyTableEditor.disableEditControls();
        this.getTabItem().setControl((Control)composite);
    }

    public boolean isTabComplete() {
        return true;
    }

    private class LocalKeyConstraintContentProvider
    extends ArrayContentProvider
    implements CommandListener {
        private Viewer viewer;

        private LocalKeyConstraintContentProvider() {
        }

        public void commandExecuted(Command command) {
            logger.debug((Marker)LogMarker.LIFECYCLE, "LocalKeyConstraintContentProvider: commandExecuted");
            TableEditDialogLocalKeyTab.this.localKeyTableEditor.refreshTable();
        }

        public void dispose() {
            logger.debug((Marker)LogMarker.LIFECYCLE, "LocalKeyConstraintContentProvider: dispose");
            super.dispose();
        }

        public JiemamyElement getTargetModel() {
            return (JiemamyElement)this.viewer.getInput();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            logger.debug((Marker)LogMarker.LIFECYCLE, "LocalKeyConstraintContentProvider: input changed");
            logger.trace((Marker)LogMarker.LIFECYCLE, "oldInput: " + oldInput);
            logger.trace((Marker)LogMarker.LIFECYCLE, "newInput: " + newInput);
            this.viewer = viewer;
            super.inputChanged(viewer, oldInput, newInput);
        }
    }

    private class LocalKeyConstraintLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private ReferenceResolver resolver;

        private LocalKeyConstraintLabelProvider() {
            this.resolver = TableEditDialogLocalKeyTab.this.tableModel.getJiemamy().getReferenceResolver();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (!(element instanceof LocalKeyConstraint)) {
                return null;
            }
            LocalKeyConstraint localKey = (LocalKeyConstraint)element;
            if (columnIndex == 0 && localKey instanceof PrimaryKey) {
                ImageRegistry ir = JiemamyUIPlugin.getDefault().getImageRegistry();
                return ir.get("ICON_PK");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof LocalKeyConstraint)) {
                return "";
            }
            LocalKeyConstraint localKey = (LocalKeyConstraint)element;
            switch (columnIndex) {
                case 1: {
                    return localKey.getName();
                }
                case 2: {
                    ArrayList columnNames = CollectionsUtil.newArrayList();
                    for (ColumnRef columnRef : localKey.getKeyColumns()) {
                        columnNames.add(((ColumnModel)this.resolver.resolve((ElementReference)columnRef)).getName());
                    }
                    return StringUtils.join((Collection)columnNames, (String)", ");
                }
            }
            return "";
        }
    }

    private class LocalKeyConstraintTableEditor
    extends AbstractTableEditor {
        private static final int COL_WIDTH_NAME = 150;
        private static final int COL_WIDTH_COLUMNS = 400;
        private final EditListener editListener;
        private final Jiemamy jiemamy;
        private Text txtKeyConstraintName;
        private org.eclipse.swt.widgets.List lstKeyColumns;
        private List<AttributeModel> attributes;

        public LocalKeyConstraintTableEditor(Composite parent, int style) {
            super(parent, style, new DefaultTableEditorConfig("\u30ed\u30fc\u30ab\u30eb\u30ad\u30fc\u60c5\u5831"));
            this.editListener = new EditListenerImpl();
            this.jiemamy = TableEditDialogLocalKeyTab.this.tableModel.getJiemamy();
            this.attributes = TableEditDialogLocalKeyTab.this.tableModel.getAttributes();
            assert (this.jiemamy != null);
            assert (this.attributes != null);
        }

        protected void configureEditorControls() {
            super.configureEditorControls();
            this.txtKeyConstraintName.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtKeyConstraintName));
            this.txtKeyConstraintName.addKeyListener((KeyListener)this.editListener);
            this.lstKeyColumns.addSelectionListener((SelectionListener)this.editListener);
        }

        protected void configureTableViewer(TableViewer tableViewer) {
            tableViewer.setLabelProvider((IBaseLabelProvider)new LocalKeyConstraintLabelProvider());
            final LocalKeyConstraintContentProvider contentProvider = new LocalKeyConstraintContentProvider();
            tableViewer.setContentProvider((IContentProvider)contentProvider);
            tableViewer.setInput(this.attributes);
            tableViewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return element instanceof LocalKeyConstraint;
                }
            });
            final EventBroker eventBroker = this.jiemamy.getEventBroker();
            eventBroker.addListener((CommandListener)contentProvider);
            tableViewer.getTable().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    eventBroker.removeListener((CommandListener)contentProvider);
                }
            });
        }

        protected void createEditorControls(Composite parent) {
            Composite cmpNames = new Composite(parent, 0);
            cmpNames.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cmpNames.setLayout((Layout)layout);
            Label label = new Label(cmpNames, 0);
            label.setText("\u5236\u7d04\u540d(&M)");
            this.txtKeyConstraintName = new Text(cmpNames, 2048);
            this.txtKeyConstraintName.setLayoutData((Object)new GridData(768));
            label = new Label(cmpNames, 0);
            label.setText("\u69cb\u6210\u30ab\u30e9\u30e0(&O)");
            this.lstKeyColumns = new org.eclipse.swt.widgets.List(cmpNames, 2050);
            this.lstKeyColumns.setLayoutData((Object)new GridData(768));
        }

        protected void createTableColumns(Table table) {
            TableColumn colMark = new TableColumn(table, 16384);
            colMark.setText("");
            colMark.setWidth(20);
            TableColumn colName = new TableColumn(table, 16384);
            colName.setText("\u5236\u7d04\u540d");
            colName.setWidth(150);
            TableColumn colColumns = new TableColumn(table, 16384);
            colColumns.setText("\u69cb\u6210\u30ab\u30e9\u30e0");
            colColumns.setWidth(400);
        }

        protected void disableEditorControls() {
            this.txtKeyConstraintName.setText("");
            this.lstKeyColumns.removeAll();
            this.txtKeyConstraintName.setEnabled(false);
            this.lstKeyColumns.setEnabled(false);
        }

        protected void enableEditorControls(int index) {
            LocalKeyConstraint localKey = (LocalKeyConstraint)TableEditDialogLocalKeyTab.this.tableModel.findAttributes(LocalKeyConstraint.class).get(index);
            this.txtKeyConstraintName.setEnabled(true);
            this.lstKeyColumns.setEnabled(true);
            this.lstKeyColumns.removeAll();
            this.txtKeyConstraintName.setText(JiemamyPropertyUtil.careNull((String)localKey.getName()));
            List keyColumns = localKey.getKeyColumns();
            List columns = TableEditDialogLocalKeyTab.this.tableModel.findColumns();
            for (ColumnModel columnModel : columns) {
                this.lstKeyColumns.add(columnModel.getName());
                boolean found = false;
                for (ColumnRef columnRef : keyColumns) {
                    if (!columnRef.getReferenceId().equals(columnModel.getId())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                int[] newIndices = ArrayUtils.add((int[])this.lstKeyColumns.getSelectionIndices(), (int)columns.indexOf(columnModel));
                this.lstKeyColumns.setSelection(newIndices);
            }
        }

        protected JiemamyElement performAddItem() {
            Table table = this.getTableViewer().getTable();
            JiemamyFactory factory = this.jiemamy.getFactory();
            UniqueKey uniqueKey = (UniqueKey)factory.newModel(UniqueKey.class);
            TableEditDialogLocalKeyTab.this.jiemamyFacade.addAttribute(TableEditDialogLocalKeyTab.this.tableModel, (AttributeModel)uniqueKey);
            int addedIndex = TableEditDialogLocalKeyTab.this.tableModel.findAttributes(LocalKeyConstraint.class).indexOf(uniqueKey);
            table.setSelection(addedIndex);
            this.enableEditControls(addedIndex);
            this.txtKeyConstraintName.setFocus();
            return uniqueKey;
        }

        protected JiemamyElement performInsertItem() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            JiemamyFactory factory = this.jiemamy.getFactory();
            UniqueKey uniqueKey = (UniqueKey)factory.newModel(UniqueKey.class);
            if (index < 0 || index > table.getItemCount()) {
                TableEditDialogLocalKeyTab.this.jiemamyFacade.addAttribute(TableEditDialogLocalKeyTab.this.tableModel, (AttributeModel)uniqueKey);
            } else {
                AttributeModel attributeModel = (AttributeModel)this.getTableViewer().getElementAt(index);
                int subjectIndex = this.attributes.indexOf(attributeModel);
                TableEditDialogLocalKeyTab.this.jiemamyFacade.addAttribute(TableEditDialogLocalKeyTab.this.tableModel, subjectIndex, (AttributeModel)uniqueKey);
            }
            int addedIndex = TableEditDialogLocalKeyTab.this.tableModel.findAttributes(LocalKeyConstraint.class).indexOf(uniqueKey);
            table.setSelection(addedIndex);
            this.enableEditControls(addedIndex);
            this.txtKeyConstraintName.setFocus();
            return uniqueKey;
        }

        protected void performMoveDownItem() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            if (index < 0 || index >= table.getItemCount()) {
                return;
            }
            Object subject = this.getTableViewer().getElementAt(index);
            Object object = this.getTableViewer().getElementAt(index + 1);
            int subjectIndex = TableEditDialogLocalKeyTab.this.tableModel.getAttributes().indexOf(subject);
            int objectIndex = TableEditDialogLocalKeyTab.this.tableModel.getAttributes().indexOf(object);
            TableEditDialogLocalKeyTab.this.jiemamyFacade.swapListElement((JiemamyElement)TableEditDialogLocalKeyTab.this.tableModel, TableEditDialogLocalKeyTab.this.tableModel.getAttributes(), subjectIndex, objectIndex);
            table.setSelection(index + 1);
            this.enableEditControls(index + 1);
        }

        protected void performMoveUpItem() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            if (index <= 0 || index > table.getItemCount()) {
                return;
            }
            Object subject = this.getTableViewer().getElementAt(index);
            Object object = this.getTableViewer().getElementAt(index - 1);
            int subjectIndex = TableEditDialogLocalKeyTab.this.tableModel.getAttributes().indexOf(subject);
            int objectIndex = TableEditDialogLocalKeyTab.this.tableModel.getAttributes().indexOf(object);
            TableEditDialogLocalKeyTab.this.jiemamyFacade.swapListElement((JiemamyElement)TableEditDialogLocalKeyTab.this.tableModel, TableEditDialogLocalKeyTab.this.tableModel.getAttributes(), subjectIndex, objectIndex);
            table.setSelection(index - 1);
            this.enableEditControls(index - 1);
        }

        protected JiemamyElement performRemoveItem() {
            int nextSelection;
            TableViewer tableViewer = this.getTableViewer();
            Table table = tableViewer.getTable();
            int index = table.getSelectionIndex();
            if (index < 0 || index > table.getItemCount()) {
                return null;
            }
            Object subject = this.getTableViewer().getElementAt(index);
            TableEditDialogLocalKeyTab.this.jiemamyFacade.removeAttribute(TableEditDialogLocalKeyTab.this.tableModel, (AttributeModel)subject);
            tableViewer.remove(subject);
            int n = nextSelection = table.getItemCount() > index ? index : index - 1;
            if (nextSelection >= 0) {
                table.setSelection(nextSelection);
                this.enableEditorControls(nextSelection);
            } else {
                this.disableEditorControls();
            }
            table.setFocus();
            return (JiemamyElement)subject;
        }

        private void updateModel() {
            int editIndex = this.getTableViewer().getTable().getSelectionIndex();
            if (editIndex == -1) {
                return;
            }
            JiemamyFactory factory = this.jiemamy.getFactory();
            LocalKeyConstraint localKey = (LocalKeyConstraint)TableEditDialogLocalKeyTab.this.tableModel.findAttributes(LocalKeyConstraint.class).get(editIndex);
            localKey.setName(JiemamyPropertyUtil.careNull((String)this.txtKeyConstraintName.getText(), (boolean)true));
            List keyColumns = localKey.getKeyColumns();
            keyColumns.clear();
            int[] nArray = this.lstKeyColumns.getSelectionIndices();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int selectionIndex = nArray[n2];
                ColumnModel columnModel = (ColumnModel)TableEditDialogLocalKeyTab.this.tableModel.findColumns().get(selectionIndex);
                keyColumns.add(factory.newReference(columnModel));
                ++n2;
            }
        }

        private class EditListenerImpl
        extends AbstractEditListener {
            private EditListenerImpl() {
            }

            protected void process(TypedEvent e) {
                LocalKeyConstraintTableEditor.this.updateModel();
                TableEditDialogLocalKeyTab.this.localKeyTableEditor.refreshTable();
            }
        }
    }
}

