/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.dialog.table;

import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.jiemamy.EventBroker;
import org.jiemamy.Jiemamy;
import org.jiemamy.JiemamyFactory;
import org.jiemamy.JiemamyProperty;
import org.jiemamy.ReferenceResolver;
import org.jiemamy.eclipse.editor.dialog.AbstractEditListener;
import org.jiemamy.eclipse.editor.dialog.EditListener;
import org.jiemamy.eclipse.editor.dialog.table.ColumnSelectDialog;
import org.jiemamy.eclipse.ui.AbstractTableEditor;
import org.jiemamy.eclipse.ui.DefaultTableEditorConfig;
import org.jiemamy.eclipse.ui.helper.TextSelectionAdapter;
import org.jiemamy.eclipse.ui.tab.AbstractTab;
import org.jiemamy.editcommand.Command;
import org.jiemamy.editcommand.CommandListener;
import org.jiemamy.facade.JiemamyFacade;
import org.jiemamy.model.ElementReference;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.attribute.ColumnModel;
import org.jiemamy.model.attribute.ColumnRef;
import org.jiemamy.model.entity.TableModel;
import org.jiemamy.model.index.IndexColumnModel;
import org.jiemamy.model.index.IndexModel;
import org.jiemamy.utils.LogMarker;
import org.jiemamy.utils.model.JiemamyPropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class TableEditDialogIndexTab
extends AbstractTab {
    private static Logger logger = LoggerFactory.getLogger(TableEditDialogIndexTab.class);
    private final TableModel tableModel;
    private IndexTableEditor indexesTableEditor;
    private IndexColumnTableEditor indexColumnsTableEditor;
    private final JiemamyFacade jiemamyFacade;

    public TableEditDialogIndexTab(TabFolder parent, int style, TableModel tableModel, JiemamyFacade jiemamyFacade) {
        super(parent, style, "\u30a4\u30f3\u30c7\u30c3\u30af\u30b9(&I)");
        this.tableModel = tableModel;
        this.jiemamyFacade = jiemamyFacade;
        Composite composite = new Composite((Composite)parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.indexesTableEditor = new IndexTableEditor(composite, 0);
        this.indexesTableEditor.configure();
        this.indexesTableEditor.disableEditControls();
        this.indexColumnsTableEditor = new IndexColumnTableEditor(composite, 0);
        this.indexColumnsTableEditor.configure();
        this.indexColumnsTableEditor.disableEditControls();
        this.getTabItem().setControl((Control)composite);
    }

    public boolean isTabComplete() {
        return true;
    }

    private class IndexColumnContentProvider
    extends ArrayContentProvider
    implements CommandListener {
        private Viewer viewer;

        private IndexColumnContentProvider() {
        }

        public void commandExecuted(Command command) {
            logger.debug((Marker)LogMarker.LIFECYCLE, "IndexColumnContentProvider: commandExecuted");
            TableEditDialogIndexTab.this.indexColumnsTableEditor.refreshTable();
        }

        public void dispose() {
            logger.debug((Marker)LogMarker.LIFECYCLE, "IndexColumnContentProvider: dispose");
        }

        public JiemamyElement getTargetModel() {
            return (JiemamyElement)this.viewer.getInput();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            logger.debug((Marker)LogMarker.LIFECYCLE, "IndexColumnContentProvider: input changed");
            logger.trace((Marker)LogMarker.LIFECYCLE, "oldInput: " + oldInput);
            logger.trace((Marker)LogMarker.LIFECYCLE, "newInput: " + newInput);
            this.viewer = viewer;
            TableEditDialogIndexTab.this.indexColumnsTableEditor.refreshTable();
        }
    }

    private class IndexColumnLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private IndexColumnLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IndexColumnModel indexColumnModel = (IndexColumnModel)element;
            ReferenceResolver referenceResolver = indexColumnModel.getJiemamy().getReferenceResolver();
            switch (columnIndex) {
                case 0: {
                    ColumnRef columnRef = indexColumnModel.getColumnRef();
                    ColumnModel columnModel = (ColumnModel)referenceResolver.resolve((ElementReference)columnRef);
                    return columnModel.getName();
                }
                case 1: {
                    IndexColumnModel.SortOrder sortOrder = indexColumnModel.getSortOrder();
                    return ObjectUtils.toString((Object)sortOrder);
                }
            }
            return "";
        }
    }

    private class IndexColumnTableEditor
    extends AbstractTableEditor {
        private static final int COL_WIDTH_NAME = 180;
        private static final int COL_WIDTH_SORT_ORDER = 80;
        private final EditListener editListener;
        private final Jiemamy jiemamy;
        private Button radSortNone;
        private Button radSortAsc;
        private Button radSortDesc;
        private List<IndexColumnModel> indexColumns;

        public IndexColumnTableEditor(Composite parent, int style) {
            super(parent, style, new DefaultTableEditorConfig("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u30ab\u30e9\u30e0\u60c5\u5831"){

                public String getAddLabel() {
                    return "\u8ffd\u52a0(&D)";
                }

                public String getInsertLabel() {
                    return "\u633f\u5165(&S)";
                }

                public String getRemoveLabel() {
                    return "\u524a\u9664(&E)";
                }
            });
            this.editListener = new IndexColumnEditListenerImpl();
            this.jiemamy = TableEditDialogIndexTab.this.tableModel.getJiemamy();
        }

        public void updateInput() {
            TableViewer tableViewer = this.getTableViewer();
            int index = TableEditDialogIndexTab.this.indexesTableEditor.getTableViewer().getTable().getSelectionIndex();
            if (index >= 0) {
                this.indexColumns = ((IndexModel)TableEditDialogIndexTab.this.tableModel.getIndexes().get(index)).getIndexColumns();
                tableViewer.setInput(this.indexColumns);
                TableEditDialogIndexTab.this.indexColumnsTableEditor.getBtnAdd().setEnabled(true);
            } else {
                tableViewer.setInput(null);
                TableEditDialogIndexTab.this.indexColumnsTableEditor.getBtnAdd().setEnabled(false);
            }
        }

        protected void configureEditorControls() {
            super.configureEditorControls();
            this.radSortNone.addSelectionListener((SelectionListener)this.editListener);
            this.radSortAsc.addSelectionListener((SelectionListener)this.editListener);
            this.radSortDesc.addSelectionListener((SelectionListener)this.editListener);
        }

        protected void configureTableViewer(TableViewer tableViewer) {
            tableViewer.setLabelProvider((IBaseLabelProvider)new IndexColumnLabelProvider());
            final IndexColumnContentProvider contentProvider = new IndexColumnContentProvider();
            tableViewer.setContentProvider((IContentProvider)contentProvider);
            this.updateInput();
            final EventBroker eventBroker = this.jiemamy.getEventBroker();
            eventBroker.addListener((CommandListener)contentProvider);
            tableViewer.getTable().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    eventBroker.removeListener((CommandListener)contentProvider);
                }
            });
        }

        protected void createEditorControls(Composite parent) {
            Composite cmpRadio = new Composite(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cmpRadio.setLayout((Layout)layout);
            cmpRadio.setLayoutData((Object)new GridData(1808));
            this.radSortNone = new Button(cmpRadio, 16);
            this.radSortNone.setText("\u306a\u3057(&O)");
            this.radSortAsc = new Button(cmpRadio, 16);
            this.radSortAsc.setText("\u6607\u9806(&A)");
            this.radSortDesc = new Button(cmpRadio, 16);
            this.radSortDesc.setText("\u964d\u9806(&E)");
        }

        protected void createTableColumns(Table table) {
            TableColumn colColumn = new TableColumn(table, 16384);
            colColumn.setText("\u30ab\u30e9\u30e0\u540d");
            colColumn.setWidth(180);
            TableColumn colSort = new TableColumn(table, 16384);
            colSort.setText("\u30bd\u30fc\u30c8\u9806");
            colSort.setWidth(80);
        }

        protected void disableEditButtons() {
            if (this.getBtnAdd() != null) {
                this.getBtnAdd().setEnabled(false);
            }
            super.disableEditButtons();
        }

        protected void disableEditorControls() {
            this.radSortNone.setEnabled(false);
            this.radSortAsc.setEnabled(false);
            this.radSortDesc.setEnabled(false);
            this.radSortNone.setSelection(false);
            this.radSortAsc.setSelection(false);
            this.radSortDesc.setSelection(false);
        }

        protected void enableEditButtons(int index) {
            if (this.getBtnAdd() != null) {
                this.getBtnAdd().setEnabled(true);
            }
            super.enableEditButtons(index);
        }

        protected void enableEditorControls(int index) {
            int indexIndex = TableEditDialogIndexTab.this.indexesTableEditor.getTableViewer().getTable().getSelectionIndex();
            IndexModel indexModel = (IndexModel)TableEditDialogIndexTab.this.tableModel.getIndexes().get(indexIndex);
            IndexColumnModel indexColumnModel = (IndexColumnModel)indexModel.getIndexColumns().get(index);
            this.radSortNone.setEnabled(true);
            this.radSortAsc.setEnabled(true);
            this.radSortDesc.setEnabled(true);
            this.radSortNone.setSelection(false);
            this.radSortAsc.setSelection(false);
            this.radSortDesc.setSelection(false);
            if (IndexColumnModel.SortOrder.ASC.equals((Object)indexColumnModel.getSortOrder())) {
                this.radSortAsc.setSelection(true);
            } else if (IndexColumnModel.SortOrder.DESC.equals((Object)indexColumnModel.getSortOrder())) {
                this.radSortDesc.setSelection(true);
            } else {
                this.radSortNone.setSelection(true);
            }
        }

        protected JiemamyElement performAddItem() {
            Table table = this.getTableViewer().getTable();
            int indexIndex = TableEditDialogIndexTab.this.indexesTableEditor.getTableViewer().getTable().getSelectionIndex();
            List columns = TableEditDialogIndexTab.this.tableModel.findColumns();
            ColumnSelectDialog dialog = new ColumnSelectDialog(table.getShell(), columns);
            if (dialog.open() == 0 && dialog.getResult() != null && indexIndex != -1) {
                JiemamyFactory factory = this.jiemamy.getFactory();
                IndexColumnModel indexColumnModel = (IndexColumnModel)factory.newModel(IndexColumnModel.class);
                ColumnRef newColumnRef = factory.newReference(dialog.getResult());
                TableEditDialogIndexTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)indexColumnModel, (JiemamyProperty)JiemamyProperty.IndexColumnProperty.columnRef, (Object)newColumnRef);
                IndexModel indexModel = (IndexModel)TableEditDialogIndexTab.this.tableModel.getIndexes().get(indexIndex);
                TableEditDialogIndexTab.this.jiemamyFacade.addIndexColumn(indexModel, indexColumnModel);
                int addedIndex = ((IndexModel)TableEditDialogIndexTab.this.tableModel.getIndexes().get(indexIndex)).getIndexColumns().indexOf(indexColumnModel);
                table.setSelection(addedIndex);
                this.enableEditControls(addedIndex);
                TableEditDialogIndexTab.this.indexColumnsTableEditor.refreshTable();
                return indexColumnModel;
            }
            return null;
        }

        protected JiemamyElement performInsertItem() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            int indexIndex = TableEditDialogIndexTab.this.indexesTableEditor.getTableViewer().getTable().getSelectionIndex();
            List columns = TableEditDialogIndexTab.this.tableModel.findColumns();
            ColumnSelectDialog dialog = new ColumnSelectDialog(table.getShell(), columns);
            if (dialog.open() == 0 && dialog.getResult() != null && indexIndex != -1) {
                JiemamyFactory factory = this.jiemamy.getFactory();
                IndexColumnModel indexColumnModel = (IndexColumnModel)factory.newModel(IndexColumnModel.class);
                ColumnRef columnRef = factory.newReference(dialog.getResult());
                TableEditDialogIndexTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)indexColumnModel, (JiemamyProperty)JiemamyProperty.IndexColumnProperty.columnRef, (Object)columnRef);
                IndexModel indexModel = (IndexModel)TableEditDialogIndexTab.this.tableModel.getIndexes().get(indexIndex);
                if (index < 0 || index > table.getItemCount()) {
                    TableEditDialogIndexTab.this.jiemamyFacade.addIndexColumn(indexModel, indexColumnModel);
                } else {
                    TableEditDialogIndexTab.this.jiemamyFacade.addIndexColumn(indexModel, index, indexColumnModel);
                }
                int addedIndex = ((IndexModel)TableEditDialogIndexTab.this.tableModel.getIndexes().get(indexIndex)).getIndexColumns().indexOf(indexColumnModel);
                table.setSelection(addedIndex);
                this.enableEditControls(addedIndex);
                TableEditDialogIndexTab.this.indexColumnsTableEditor.refreshTable();
                return indexColumnModel;
            }
            return null;
        }

        protected void performMoveDownItem() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            int indexIndex = TableEditDialogIndexTab.this.indexesTableEditor.getTableViewer().getTable().getSelectionIndex();
            if (index < 0 || index >= table.getItemCount()) {
                return;
            }
            IndexModel indexModel = (IndexModel)TableEditDialogIndexTab.this.tableModel.getIndexes().get(indexIndex);
            TableEditDialogIndexTab.this.jiemamyFacade.swapListElement((JiemamyElement)indexModel, this.indexColumns, index, index + 1);
            TableEditDialogIndexTab.this.indexColumnsTableEditor.refreshTable();
            table.setSelection(index + 1);
            this.enableEditControls(index + 1);
        }

        protected void performMoveUpItem() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            int indexIndex = TableEditDialogIndexTab.this.indexesTableEditor.getTableViewer().getTable().getSelectionIndex();
            if (index <= 0 || index > table.getItemCount()) {
                return;
            }
            IndexModel indexModel = (IndexModel)TableEditDialogIndexTab.this.tableModel.getIndexes().get(indexIndex);
            TableEditDialogIndexTab.this.jiemamyFacade.swapListElement((JiemamyElement)indexModel, this.indexColumns, index, index - 1);
            TableEditDialogIndexTab.this.indexColumnsTableEditor.refreshTable();
            table.setSelection(index - 1);
            this.enableEditControls(index - 1);
        }

        protected JiemamyElement performRemoveItem() {
            int nextSelection;
            TableViewer tableViewer = this.getTableViewer();
            Table table = tableViewer.getTable();
            int index = table.getSelectionIndex();
            int indexIndex = TableEditDialogIndexTab.this.indexesTableEditor.getTableViewer().getTable().getSelectionIndex();
            if (index < 0 || index > table.getItemCount()) {
                return null;
            }
            IndexColumnModel removed = (IndexColumnModel)((IndexModel)TableEditDialogIndexTab.this.tableModel.getIndexes().get(indexIndex)).getIndexColumns().remove(index);
            tableViewer.remove((Object)index);
            int n = nextSelection = table.getItemCount() > index ? index : index - 1;
            if (nextSelection >= 0) {
                table.setSelection(nextSelection);
                this.enableEditorControls(nextSelection);
            } else {
                this.disableEditorControls();
            }
            table.setFocus();
            TableEditDialogIndexTab.this.indexColumnsTableEditor.refreshTable();
            return removed;
        }

        private void updateModel() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            int indexIndex = TableEditDialogIndexTab.this.indexesTableEditor.getTableViewer().getTable().getSelectionIndex();
            if (indexIndex != -1 && index != -1) {
                IndexColumnModel indexColumnModel = (IndexColumnModel)((IndexModel)TableEditDialogIndexTab.this.tableModel.getIndexes().get(indexIndex)).getIndexColumns().get(index);
                IndexColumnModel.SortOrder sortOrder = null;
                if (this.radSortAsc.getSelection()) {
                    sortOrder = IndexColumnModel.SortOrder.ASC;
                } else if (this.radSortDesc.getSelection()) {
                    sortOrder = IndexColumnModel.SortOrder.DESC;
                }
                TableEditDialogIndexTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)indexColumnModel, (JiemamyProperty)JiemamyProperty.IndexColumnProperty.sortOrder, (Object)sortOrder);
            }
        }

        private class IndexColumnEditListenerImpl
        extends AbstractEditListener {
            private IndexColumnEditListenerImpl() {
            }

            protected void process(TypedEvent e) {
                IndexColumnTableEditor.this.updateModel();
            }
        }
    }

    private class IndexContentProvider
    extends ArrayContentProvider
    implements CommandListener {
        private Viewer viewer;

        private IndexContentProvider() {
        }

        public void commandExecuted(Command command) {
            logger.debug((Marker)LogMarker.LIFECYCLE, "IndexContentProvider: commandExecuted");
            TableEditDialogIndexTab.this.indexesTableEditor.refreshTable();
        }

        public void dispose() {
            logger.debug((Marker)LogMarker.LIFECYCLE, "IndexContentProvider: disposed");
            super.dispose();
        }

        public JiemamyElement getTargetModel() {
            return (JiemamyElement)this.viewer.getInput();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            logger.debug((Marker)LogMarker.LIFECYCLE, "IndexContentProvider: input changed");
            logger.trace((Marker)LogMarker.LIFECYCLE, "oldInput: " + oldInput);
            logger.trace((Marker)LogMarker.LIFECYCLE, "newInput: " + newInput);
            this.viewer = viewer;
            super.inputChanged(viewer, oldInput, newInput);
        }
    }

    private class IndexLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private IndexLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IndexModel indexModel = (IndexModel)element;
            switch (columnIndex) {
                case 0: {
                    return indexModel.getName();
                }
                case 1: {
                    return String.valueOf(indexModel.isUnique());
                }
            }
            return "";
        }
    }

    private class IndexTableEditor
    extends AbstractTableEditor {
        private static final int COL_WIDTH_NAME = 180;
        private static final int COL_WIDTH_UNIQUE = 50;
        private final EditListener editListener;
        private final Jiemamy jiemamy;
        private Text txtIndexName;
        private Button chkIsUniqueIndex;
        private final List<IndexModel> indexes;

        public IndexTableEditor(Composite parent, int style) {
            super(parent, style, new DefaultTableEditorConfig("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u60c5\u5831"));
            this.editListener = new IndexEditListenerImpl();
            this.jiemamy = TableEditDialogIndexTab.this.tableModel.getJiemamy();
            this.indexes = TableEditDialogIndexTab.this.tableModel.getIndexes();
            assert (this.jiemamy != null);
            assert (this.indexes != null);
        }

        protected void configureEditorControls() {
            super.configureEditorControls();
            this.txtIndexName.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtIndexName));
            this.txtIndexName.addKeyListener((KeyListener)this.editListener);
            this.chkIsUniqueIndex.addSelectionListener((SelectionListener)this.editListener);
        }

        protected void configureTable(final Table table) {
            super.configureTable(table);
            table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IndexTableEditor.this.onTableRowSelected(table.getSelectionIndex());
                }
            });
        }

        protected void configureTableViewer(TableViewer tableViewer) {
            tableViewer.setLabelProvider((IBaseLabelProvider)new IndexLabelProvider());
            final IndexContentProvider contentProvider = new IndexContentProvider();
            tableViewer.setContentProvider((IContentProvider)contentProvider);
            tableViewer.setInput(this.indexes);
            final EventBroker eventBroker = this.jiemamy.getEventBroker();
            eventBroker.addListener((CommandListener)contentProvider);
            tableViewer.getTable().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    eventBroker.removeListener((CommandListener)contentProvider);
                }
            });
        }

        protected void createEditorControls(Composite parent) {
            Composite cmpNames = new Composite(parent, 0);
            cmpNames.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cmpNames.setLayout((Layout)layout);
            Label label = new Label(cmpNames, 0);
            label.setText("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u540d(&M)");
            this.txtIndexName = new Text(cmpNames, 2048);
            this.txtIndexName.setLayoutData((Object)new GridData(768));
            this.chkIsUniqueIndex = new Button(parent, 32);
            this.chkIsUniqueIndex.setText("\u4e00\u610f(&U)");
        }

        protected void createTableColumns(Table table) {
            TableColumn colName = new TableColumn(table, 16384);
            colName.setText("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u540d");
            colName.setWidth(180);
            TableColumn colUnique = new TableColumn(table, 16384);
            colUnique.setText("\u4e00\u610f");
            colUnique.setWidth(50);
        }

        protected void disableEditorControls() {
            this.txtIndexName.setEnabled(false);
            this.chkIsUniqueIndex.setEnabled(false);
            this.txtIndexName.setText("");
            this.chkIsUniqueIndex.setSelection(false);
        }

        protected void enableEditorControls(int index) {
            IndexModel indexModel = this.indexes.get(index);
            this.txtIndexName.setEnabled(true);
            this.chkIsUniqueIndex.setEnabled(true);
            this.txtIndexName.setText(JiemamyPropertyUtil.careNull((String)indexModel.getName()));
            this.chkIsUniqueIndex.setSelection(indexModel.isUnique());
        }

        protected JiemamyElement performAddItem() {
            Table table = this.getTableViewer().getTable();
            JiemamyFactory factory = this.jiemamy.getFactory();
            IndexModel indexModel = (IndexModel)factory.newModel(IndexModel.class);
            String newName = "idx_" + TableEditDialogIndexTab.this.tableModel.getName() + "_" + (TableEditDialogIndexTab.this.tableModel.getIndexes().size() + 1);
            TableEditDialogIndexTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)indexModel, (JiemamyProperty)JiemamyProperty.IndexProperty.name, (Object)newName);
            TableEditDialogIndexTab.this.jiemamyFacade.addIndex(TableEditDialogIndexTab.this.tableModel, indexModel);
            int addedIndex = TableEditDialogIndexTab.this.tableModel.getIndexes().indexOf(indexModel);
            table.setSelection(addedIndex);
            this.onTableRowSelected(addedIndex);
            this.enableEditControls(addedIndex);
            this.txtIndexName.setFocus();
            return indexModel;
        }

        protected JiemamyElement performInsertItem() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            JiemamyFactory factory = this.jiemamy.getFactory();
            IndexModel indexModel = (IndexModel)factory.newModel(IndexModel.class);
            String newName = "idx_" + TableEditDialogIndexTab.this.tableModel.getName() + "_" + (TableEditDialogIndexTab.this.tableModel.getIndexes().size() + 1);
            TableEditDialogIndexTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)indexModel, (JiemamyProperty)JiemamyProperty.IndexProperty.name, (Object)newName);
            if (index < 0 || index > table.getItemCount()) {
                TableEditDialogIndexTab.this.jiemamyFacade.addIndex(TableEditDialogIndexTab.this.tableModel, indexModel);
            } else {
                TableEditDialogIndexTab.this.jiemamyFacade.addIndex(TableEditDialogIndexTab.this.tableModel, index, indexModel);
            }
            int addedIndex = TableEditDialogIndexTab.this.tableModel.getIndexes().indexOf(indexModel);
            table.setSelection(addedIndex);
            this.onTableRowSelected(addedIndex);
            this.enableEditControls(addedIndex);
            this.txtIndexName.setFocus();
            return indexModel;
        }

        protected void performMoveDownItem() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            if (index < 0 || index >= table.getItemCount()) {
                return;
            }
            TableEditDialogIndexTab.this.jiemamyFacade.swapListElement((JiemamyElement)TableEditDialogIndexTab.this.tableModel, this.indexes, index, index + 1);
            table.setSelection(index + 1);
            this.enableEditControls(index + 1);
        }

        protected void performMoveUpItem() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            if (index <= 0 || index > table.getItemCount()) {
                return;
            }
            TableEditDialogIndexTab.this.jiemamyFacade.swapListElement((JiemamyElement)TableEditDialogIndexTab.this.tableModel, this.indexes, index, index - 1);
            table.setSelection(index - 1);
            this.enableEditControls(index - 1);
        }

        protected JiemamyElement performRemoveItem() {
            int nextSelection;
            TableViewer tableViewer = this.getTableViewer();
            Table table = tableViewer.getTable();
            int index = table.getSelectionIndex();
            if (index < 0 || index > table.getItemCount()) {
                return null;
            }
            IndexModel indexModel = this.indexes.get(index);
            TableEditDialogIndexTab.this.jiemamyFacade.removeIndex(TableEditDialogIndexTab.this.tableModel, indexModel);
            tableViewer.remove((Object)indexModel);
            int n = nextSelection = table.getItemCount() > index ? index : index - 1;
            if (nextSelection >= 0) {
                table.setSelection(nextSelection);
                this.onTableRowSelected(nextSelection);
                this.enableEditorControls(nextSelection);
            } else {
                this.disableEditorControls();
            }
            table.setFocus();
            return indexModel;
        }

        private void onTableRowSelected(int index) {
            if (index >= 0) {
                TableEditDialogIndexTab.this.indexColumnsTableEditor.updateInput();
            } else {
                TableEditDialogIndexTab.this.indexColumnsTableEditor.disableEditControls();
            }
        }

        private void updateModel() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            if (index == -1) {
                return;
            }
            IndexModel indexModel = (IndexModel)TableEditDialogIndexTab.this.tableModel.getIndexes().get(index);
            String indexName = JiemamyPropertyUtil.careNull((String)this.txtIndexName.getText(), (boolean)true);
            TableEditDialogIndexTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)indexModel, (JiemamyProperty)JiemamyProperty.IndexProperty.name, (Object)indexName);
            boolean uniqueIndex = this.chkIsUniqueIndex.getSelection();
            TableEditDialogIndexTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)indexModel, (JiemamyProperty)JiemamyProperty.IndexProperty.unique, (Object)uniqueIndex);
        }

        private class IndexEditListenerImpl
        extends AbstractEditListener {
            private IndexEditListenerImpl() {
            }

            protected void process(TypedEvent e) {
                IndexTableEditor.this.updateModel();
                TableEditDialogIndexTab.this.indexesTableEditor.refreshTable();
            }
        }
    }
}

