/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.dialog.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.jiemamy.EventBroker;
import org.jiemamy.Jiemamy;
import org.jiemamy.JiemamyFactory;
import org.jiemamy.JiemamyProperty;
import org.jiemamy.dialect.BuiltinDataTypeMold;
import org.jiemamy.dialect.Dialect;
import org.jiemamy.eclipse.JiemamyCorePlugin;
import org.jiemamy.eclipse.JiemamyUIPlugin;
import org.jiemamy.eclipse.editor.DisplayPlace;
import org.jiemamy.eclipse.editor.dialog.AbstractEditListener;
import org.jiemamy.eclipse.editor.dialog.EditListener;
import org.jiemamy.eclipse.editor.dialog.TypeOptionHandler;
import org.jiemamy.eclipse.editor.dialog.TypeOptionManager;
import org.jiemamy.eclipse.editor.dialog.table.Messages;
import org.jiemamy.eclipse.editor.utils.LabelStringUtil;
import org.jiemamy.eclipse.extension.ExtensionResolver;
import org.jiemamy.eclipse.ui.AbstractTableEditor;
import org.jiemamy.eclipse.ui.DefaultTableEditorConfig;
import org.jiemamy.eclipse.ui.helper.TextSelectionAdapter;
import org.jiemamy.eclipse.ui.tab.AbstractTab;
import org.jiemamy.eclipse.utils.ExceptionHandler;
import org.jiemamy.editcommand.Command;
import org.jiemamy.editcommand.CommandListener;
import org.jiemamy.exception.ElementNotFoundException;
import org.jiemamy.facade.JiemamyFacade;
import org.jiemamy.model.ElementReference;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.attribute.AttributeModel;
import org.jiemamy.model.attribute.ColumnModel;
import org.jiemamy.model.attribute.constraint.ColumnCheckConstraint;
import org.jiemamy.model.attribute.constraint.KeyConstraint;
import org.jiemamy.model.attribute.constraint.NotNullConstraint;
import org.jiemamy.model.attribute.constraint.PrimaryKey;
import org.jiemamy.model.datatype.BuiltinDataType;
import org.jiemamy.model.datatype.DataType;
import org.jiemamy.model.datatype.DataTypeHolder;
import org.jiemamy.model.datatype.DataTypeMold;
import org.jiemamy.model.datatype.DomainModel;
import org.jiemamy.model.datatype.DomainRef;
import org.jiemamy.model.datatype.adapter.PrecisionedDataTypeAdapter;
import org.jiemamy.model.datatype.adapter.SizedDataTypeAdapter;
import org.jiemamy.model.datatype.adapter.TimezonedDataTypeAdapter;
import org.jiemamy.model.entity.TableModel;
import org.jiemamy.utils.CollectionsUtil;
import org.jiemamy.utils.Disablable;
import org.jiemamy.utils.LogMarker;
import org.jiemamy.utils.model.JiemamyPropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class TableEditDialogColumnTab
extends AbstractTab {
    private static Logger logger = LoggerFactory.getLogger(TableEditDialogColumnTab.class);
    private final RootModel rootModel;
    private final TableModel tableModel;
    private List<DataTypeMold<?>> allTypes;
    private AbstractTableEditor columnTableEditor;
    private final JiemamyFacade jiemamyFacade;

    public TableEditDialogColumnTab(TabFolder parentTabFolder, int style, TableModel tableModel, JiemamyFacade jiemamyFacade) {
        super(parentTabFolder, style, Messages.Tab_Table_Columns);
        Dialect dialect;
        this.tableModel = tableModel;
        this.jiemamyFacade = jiemamyFacade;
        this.rootModel = tableModel.getJiemamy().getFactory().getRootModel();
        try {
            dialect = this.rootModel.findDialect();
        }
        catch (ClassNotFoundException e) {
            dialect = (Dialect)JiemamyCorePlugin.getDialectResolver().getAllInstance().get(0);
            logger.warn("Dialect\u306e\u30ed\u30b9\u30c8", (Throwable)e);
        }
        this.allTypes = CollectionsUtil.newArrayList((int)(this.rootModel.getDomains().size() + dialect.getAllDataTypes().size()));
        this.allTypes.addAll(dialect.getAllDataTypes());
        this.allTypes.addAll(this.rootModel.getDomains());
        Composite composite = new Composite((Composite)parentTabFolder, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.columnTableEditor = new ColumnTableEditor(composite, 0);
        this.columnTableEditor.configure();
        this.columnTableEditor.disableEditControls();
        this.getTabItem().setControl((Control)composite);
    }

    public boolean isTabComplete() {
        return true;
    }

    private class ColumnContentProvider
    extends ArrayContentProvider
    implements CommandListener {
        private Viewer viewer;

        private ColumnContentProvider() {
        }

        public void commandExecuted(Command command) {
            logger.debug((Marker)LogMarker.LIFECYCLE, "ColumnContentProvider: commandExecuted");
            TableEditDialogColumnTab.this.columnTableEditor.refreshTable();
        }

        public void dispose() {
            logger.debug((Marker)LogMarker.LIFECYCLE, "ColumnContentProvider: disposed");
            super.dispose();
        }

        public JiemamyElement getTargetModel() {
            return (JiemamyElement)this.viewer.getInput();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            logger.debug((Marker)LogMarker.LIFECYCLE, "ColumnContentProvider: input changed");
            logger.trace((Marker)LogMarker.LIFECYCLE, "oldInput: " + oldInput);
            logger.trace((Marker)LogMarker.LIFECYCLE, "newInput: " + newInput);
            this.viewer = viewer;
            super.inputChanged(viewer, oldInput, newInput);
        }
    }

    private class ColumnLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private ColumnLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (!(element instanceof ColumnModel)) {
                return null;
            }
            ColumnModel columnModel = (ColumnModel)element;
            ImageRegistry ir = JiemamyUIPlugin.getDefault().getImageRegistry();
            switch (columnIndex) {
                case 0: {
                    return columnModel.checkPrimaryKeyColumn() ? ir.get("ICON_PK") : null;
                }
                case 4: {
                    return ir.get(columnModel.getNotNullConstraint() != null ? "CHECK_ON" : "CHECK_OFF");
                }
                case 5: {
                    ColumnCheckConstraint check = columnModel.getCheckConstraint();
                    return ir.get(check != null && !StringUtils.isEmpty((String)check.getExpression()) ? "CHECK_ON" : "CHECK_OFF");
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof ColumnModel)) {
                return "";
            }
            ColumnModel columnModel = (ColumnModel)element;
            switch (columnIndex) {
                case 1: {
                    return LabelStringUtil.getString(TableEditDialogColumnTab.this.rootModel, (JiemamyElement)columnModel, DisplayPlace.TABLE);
                }
                case 2: {
                    return LabelStringUtil.getString(TableEditDialogColumnTab.this.rootModel, columnModel.getDataType(), DisplayPlace.TABLE);
                }
                case 3: {
                    return columnModel.getDefaultValue();
                }
            }
            return "";
        }
    }

    private class ColumnTableEditor
    extends AbstractTableEditor {
        private static final int COL_WIDTH_NAME = 200;
        private static final int COL_WIDTH_TYPE = 150;
        private static final int COL_WIDTH_DEFAULT = 120;
        private static final int COL_WIDTH_NN = 40;
        private static final int COL_WIDTH_CHECK = 40;
        private final EditListener editListener;
        private final Jiemamy jiemamy;
        private Dialect dialect;
        private Text txtColumnName;
        private Text txtColumnLogicalName;
        private Combo cmbDataType;
        private Text txtCheckName;
        private Text txtCheckExpression;
        private Text txtDefaultValue;
        private Button chkIsNotNull;
        private Button chkIsPK;
        private Button chkIsDisabled;
        private Text txtDescription;
        private Composite cmpTypeOption;
        private Map<ColumnModel, TypeOptionManager> typeOptionManagers;
        private final List<AttributeModel> attributes;
        private TypeOptionHandler typeOptionHandler;

        public ColumnTableEditor(Composite parent, int style) {
            super(parent, style, new DefaultTableEditorConfig("\u30ab\u30e9\u30e0\u60c5\u5831"));
            this.editListener = new EditListenerImpl();
            this.typeOptionManagers = CollectionsUtil.newHashMap();
            this.jiemamy = TableEditDialogColumnTab.this.tableModel.getJiemamy();
            this.attributes = TableEditDialogColumnTab.this.tableModel.getAttributes();
            try {
                this.dialect = TableEditDialogColumnTab.this.rootModel.findDialect();
            }
            catch (ClassNotFoundException e) {
                this.dialect = (Dialect)JiemamyCorePlugin.getDialectResolver().getAllInstance().get(0);
                logger.warn("Dialect\u306e\u30ed\u30b9\u30c8", (Throwable)e);
            }
            assert (this.jiemamy != null);
            assert (this.attributes != null);
            assert (this.dialect != null);
        }

        protected void configureEditorControls() {
            super.configureEditorControls();
            for (DataTypeMold dataTypeMold : TableEditDialogColumnTab.this.allTypes) {
                this.cmbDataType.add(dataTypeMold.getName());
            }
            this.txtColumnName.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtColumnName));
            this.txtColumnName.addKeyListener((KeyListener)this.editListener);
            this.txtColumnLogicalName.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtColumnLogicalName));
            this.txtColumnLogicalName.addKeyListener((KeyListener)this.editListener);
            this.txtCheckName.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtCheckName));
            this.txtCheckName.addKeyListener((KeyListener)this.editListener);
            this.txtCheckExpression.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtCheckExpression));
            this.txtCheckExpression.addKeyListener((KeyListener)this.editListener);
            this.cmbDataType.addSelectionListener((SelectionListener)this.editListener);
            this.cmbDataType.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Table table = ColumnTableEditor.this.getTableViewer().getTable();
                    int index = table.getSelectionIndex();
                    if (index < 0 || index >= table.getItemCount()) {
                        return;
                    }
                    ColumnModel columnModel = (ColumnModel)ColumnTableEditor.this.getTableViewer().getElementAt(index);
                    TypeOptionManager typeOptionManager = (TypeOptionManager)ColumnTableEditor.this.typeOptionManagers.get(columnModel);
                    DataTypeMold dataTypeMold = (DataTypeMold)TableEditDialogColumnTab.this.allTypes.get(ColumnTableEditor.this.cmbDataType.getSelectionIndex());
                    if (dataTypeMold instanceof BuiltinDataTypeMold) {
                        BuiltinDataTypeMold builtinDataTypeMold = (BuiltinDataTypeMold)dataTypeMold;
                        typeOptionManager.createTypeOptionControl(builtinDataTypeMold.getSupportedAdapterClasses());
                    } else {
                        typeOptionManager.clearTypeOptionControl();
                    }
                }
            });
            this.chkIsPK.addSelectionListener((SelectionListener)this.editListener);
            this.chkIsNotNull.addSelectionListener((SelectionListener)this.editListener);
            this.chkIsDisabled.addSelectionListener((SelectionListener)this.editListener);
            this.txtDefaultValue.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtDefaultValue));
            this.txtDefaultValue.addKeyListener((KeyListener)this.editListener);
            this.txtDescription.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtDefaultValue));
            this.txtDescription.addKeyListener((KeyListener)this.editListener);
        }

        protected void configureTableViewer(TableViewer tableViewer) {
            tableViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider());
            final ColumnContentProvider contentProvider = new ColumnContentProvider();
            tableViewer.setContentProvider((IContentProvider)contentProvider);
            tableViewer.setInput(this.attributes);
            tableViewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return element instanceof ColumnModel;
                }
            });
            final EventBroker eventBroker = this.jiemamy.getEventBroker();
            eventBroker.addListener((CommandListener)contentProvider);
            tableViewer.getTable().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    eventBroker.removeListener((CommandListener)contentProvider);
                }
            });
            ExtensionResolver dialectResolver = JiemamyCorePlugin.getDialectResolver();
            IConfigurationElement dialectElement = (IConfigurationElement)dialectResolver.getExtensionConfigurationElements().get(TableEditDialogColumnTab.this.rootModel.getDialectClassName());
            Object[] children = dialectElement.getChildren("typeOptionHandler");
            if (!ArrayUtils.isEmpty((Object[])children)) {
                try {
                    this.typeOptionHandler = (TypeOptionHandler)children[0].createExecutableExtension("class");
                }
                catch (Exception e) {
                    ExceptionHandler.handleException(e);
                }
            }
            this.typeOptionManagers.clear();
            for (AttributeModel attributeModel : this.attributes) {
                if (!(attributeModel instanceof ColumnModel)) continue;
                ColumnModel columnModel = (ColumnModel)attributeModel;
                TypeOptionManager typeOptionManager = new TypeOptionManager((DataTypeHolder<? extends DataType>)columnModel, this.cmpTypeOption, this.editListener, this.typeOptionHandler);
                this.typeOptionManagers.put(columnModel, typeOptionManager);
            }
        }

        protected void createEditorControls(Composite parent) {
            Composite cmpBasic = new Composite(parent, 0);
            cmpBasic.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout(4, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cmpBasic.setLayout((Layout)layout);
            Label label = new Label(cmpBasic, 0);
            label.setText("\u30ab\u30e9\u30e0\u540d(&M)");
            this.txtColumnName = new Text(cmpBasic, 2048);
            this.txtColumnName.setLayoutData((Object)new GridData(768));
            label = new Label(cmpBasic, 0);
            label.setText("\u8ad6\u7406\u540d(&L)");
            this.txtColumnLogicalName = new Text(cmpBasic, 2048);
            this.txtColumnLogicalName.setLayoutData((Object)new GridData(768));
            label = new Label(cmpBasic, 0);
            label.setText("\u30c7\u30fc\u30bf\u578b(&T)");
            Composite cmpTypes = new Composite(cmpBasic, 0);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 3;
            cmpTypes.setLayoutData((Object)gd);
            layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cmpTypes.setLayout((Layout)layout);
            this.cmbDataType = new Combo(cmpTypes, 8);
            this.cmbDataType.setVisibleItemCount(20);
            this.cmpTypeOption = new Composite(cmpTypes, 0);
            this.cmpTypeOption.setLayout((Layout)new RowLayout());
            gd = new GridData();
            gd.heightHint = 25;
            gd.widthHint = 400;
            this.cmpTypeOption.setLayoutData((Object)gd);
            Composite cmpChecks = new Composite(parent, 0);
            RowLayout rowLayout = new RowLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cmpChecks.setLayout((Layout)rowLayout);
            this.chkIsPK = new Button(cmpChecks, 32);
            this.chkIsPK.setText("\u4e3b\u30ad\u30fc(&P)");
            this.chkIsNotNull = new Button(cmpChecks, 32);
            this.chkIsNotNull.setText("NOT NULL(&O)");
            this.chkIsDisabled = new Button(cmpChecks, 32);
            this.chkIsDisabled.setText("\u7121\u52b9(&G)");
            this.createAdvancedEditComponents(parent);
        }

        protected void createTableColumns(Table table) {
            TableColumn colMark = new TableColumn(table, 16384);
            colMark.setText("");
            colMark.setWidth(20);
            TableColumn colName = new TableColumn(table, 16384);
            colName.setText("\u30ab\u30e9\u30e0\u540d");
            colName.setWidth(200);
            TableColumn colType = new TableColumn(table, 16384);
            colType.setText("\u30c7\u30fc\u30bf\u578b");
            colType.setWidth(150);
            TableColumn colDefault = new TableColumn(table, 16384);
            colDefault.setText("\u30c7\u30d5\u30a9\u30eb\u30c8\u5024");
            colDefault.setWidth(120);
            TableColumn colNotNull = new TableColumn(table, 16384);
            colNotNull.setText("NN");
            colNotNull.setWidth(40);
            TableColumn colCheck = new TableColumn(table, 16384);
            colCheck.setText("CHK");
            colCheck.setWidth(40);
        }

        protected void disableEditorControls() {
            this.txtColumnName.setText("");
            this.txtColumnLogicalName.setText("");
            this.txtCheckName.setText("");
            this.txtCheckExpression.setText("");
            this.cmbDataType.setText("");
            this.chkIsPK.setSelection(false);
            this.chkIsNotNull.setSelection(false);
            this.chkIsDisabled.setSelection(false);
            this.txtDefaultValue.setText("");
            this.txtDescription.setText("");
            this.txtColumnName.setEnabled(false);
            this.txtColumnLogicalName.setEnabled(false);
            this.txtCheckName.setEnabled(false);
            this.txtCheckExpression.setEnabled(false);
            this.cmbDataType.setEnabled(false);
            this.chkIsPK.setEnabled(false);
            this.chkIsNotNull.setEnabled(false);
            this.chkIsDisabled.setEnabled(false);
            this.txtDefaultValue.setEnabled(false);
            this.txtDescription.setEnabled(false);
            Control[] controlArray = this.cmpTypeOption.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
        }

        protected void enableEditorControls(int index) {
            ColumnModel columnModel = (ColumnModel)this.getTableViewer().getElementAt(index);
            this.txtColumnName.setEnabled(true);
            this.txtColumnLogicalName.setEnabled(true);
            this.txtCheckName.setEnabled(true);
            this.txtCheckExpression.setEnabled(true);
            this.cmbDataType.setEnabled(true);
            this.txtDefaultValue.setEnabled(true);
            this.txtDescription.setEnabled(true);
            this.chkIsPK.setEnabled(true);
            this.chkIsNotNull.setEnabled(true);
            this.chkIsDisabled.setEnabled(true);
            DataType dataType = columnModel.getDataType();
            if (dataType instanceof BuiltinDataType) {
                List adapters = ((BuiltinDataType)dataType).getAdapters();
                ArrayList adapterClasses = CollectionsUtil.newArrayList();
                for (Object adapter : adapters) {
                    adapterClasses.add(adapter.getClass());
                }
                this.typeOptionManagers.get(columnModel).createTypeOptionControl(adapterClasses);
            } else {
                Control[] controlArray = this.cmpTypeOption.getChildren();
                int adapter = controlArray.length;
                int adapterClasses = 0;
                while (adapterClasses < adapter) {
                    Control control = controlArray[adapterClasses];
                    control.dispose();
                    ++adapterClasses;
                }
            }
            this.txtColumnName.setText(columnModel.getName());
            this.txtColumnLogicalName.setText(JiemamyPropertyUtil.careNull((String)columnModel.getLogicalName()));
            ColumnCheckConstraint columnCheckConstraint = columnModel.getCheckConstraint();
            if (columnCheckConstraint == null) {
                this.txtCheckName.setText("");
                this.txtCheckExpression.setText("");
            } else {
                this.txtCheckName.setText(JiemamyPropertyUtil.careNull((String)columnCheckConstraint.getName()));
                this.txtCheckExpression.setText(JiemamyPropertyUtil.careNull((String)columnCheckConstraint.getExpression()));
            }
            this.chkIsNotNull.setSelection(columnModel.getNotNullConstraint() != null);
            if (dataType instanceof DomainRef) {
                DomainRef domainRef = (DomainRef)dataType;
                DomainModel domainModel = (DomainModel)this.jiemamy.getReferenceResolver().resolve((ElementReference)domainRef);
                this.cmbDataType.setText(domainModel.getName());
            } else if (dataType instanceof BuiltinDataType) {
                BuiltinDataType builtinDataType = (BuiltinDataType)dataType;
                this.cmbDataType.setText(builtinDataType.getTypeName());
                if (builtinDataType.hasAdapter(SizedDataTypeAdapter.class)) {
                    this.typeOptionManagers.get(columnModel).setValue(SizedDataTypeAdapter.class);
                }
                if (builtinDataType.hasAdapter(PrecisionedDataTypeAdapter.class)) {
                    this.typeOptionManagers.get(columnModel).setValue(PrecisionedDataTypeAdapter.class);
                }
                if (builtinDataType.hasAdapter(TimezonedDataTypeAdapter.class)) {
                    this.typeOptionManagers.get(columnModel).setValue(TimezonedDataTypeAdapter.class);
                }
            }
            this.txtDefaultValue.setText(JiemamyPropertyUtil.careNull((String)columnModel.getDefaultValue()));
            this.txtDescription.setText(JiemamyPropertyUtil.careNull((String)columnModel.getDescription()));
            this.chkIsPK.setSelection(columnModel.checkPrimaryKeyColumn());
            if (columnModel.hasAdapter(Disablable.class) && Boolean.TRUE.equals(((Disablable)columnModel.getAdapter(Disablable.class)).isDisabled())) {
                this.chkIsDisabled.setSelection(true);
            } else {
                this.chkIsDisabled.setSelection(false);
            }
        }

        protected JiemamyElement performAddItem() {
            Table table = this.getTableViewer().getTable();
            JiemamyFactory factory = this.jiemamy.getFactory();
            ColumnModel columnModel = (ColumnModel)factory.newModel(ColumnModel.class);
            String newName = "COLUMN_" + (TableEditDialogColumnTab.this.tableModel.findColumns().size() + 1);
            TableEditDialogColumnTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)columnModel, (JiemamyProperty)JiemamyProperty.AttributeProperty.name, (Object)newName);
            DataType builtinDataType = factory.newDataType((DataTypeMold)TableEditDialogColumnTab.this.allTypes.get(0));
            TableEditDialogColumnTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)columnModel, (JiemamyProperty)JiemamyProperty.ColumnProperty.dataType, (Object)builtinDataType);
            TableEditDialogColumnTab.this.jiemamyFacade.addAttribute(TableEditDialogColumnTab.this.tableModel, (AttributeModel)columnModel);
            TypeOptionManager typeOptionManager = new TypeOptionManager((DataTypeHolder<? extends DataType>)columnModel, this.cmpTypeOption, this.editListener, this.typeOptionHandler);
            this.typeOptionManagers.put(columnModel, typeOptionManager);
            int addedIndex = TableEditDialogColumnTab.this.tableModel.findColumns().indexOf(columnModel);
            table.setSelection(addedIndex);
            this.enableEditControls(addedIndex);
            this.txtColumnName.setFocus();
            return columnModel;
        }

        protected JiemamyElement performInsertItem() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            JiemamyFactory factory = this.jiemamy.getFactory();
            ColumnModel columnModel = (ColumnModel)factory.newModel(ColumnModel.class);
            String newName = "COLUMN_" + (TableEditDialogColumnTab.this.tableModel.findColumns().size() + 1);
            TableEditDialogColumnTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)columnModel, (JiemamyProperty)JiemamyProperty.AttributeProperty.name, (Object)newName);
            DataType builtinDataType = factory.newDataType((DataTypeMold)TableEditDialogColumnTab.this.allTypes.get(0));
            TableEditDialogColumnTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)columnModel, (JiemamyProperty)JiemamyProperty.ColumnProperty.dataType, (Object)builtinDataType);
            if (index < 0 || index > table.getItemCount()) {
                TableEditDialogColumnTab.this.jiemamyFacade.addAttribute(TableEditDialogColumnTab.this.tableModel, (AttributeModel)columnModel);
            } else {
                AttributeModel subject = (AttributeModel)this.getTableViewer().getElementAt(index);
                int subjectIndex = this.attributes.indexOf(subject);
                TableEditDialogColumnTab.this.jiemamyFacade.addAttribute(TableEditDialogColumnTab.this.tableModel, subjectIndex, (AttributeModel)columnModel);
            }
            TypeOptionManager typeOptionManager = new TypeOptionManager((DataTypeHolder<? extends DataType>)columnModel, this.cmpTypeOption, this.editListener, this.typeOptionHandler);
            this.typeOptionManagers.put(columnModel, typeOptionManager);
            int addedIndex = TableEditDialogColumnTab.this.tableModel.findColumns().indexOf(columnModel);
            table.setSelection(addedIndex);
            this.enableEditControls(addedIndex);
            this.txtColumnName.setFocus();
            return columnModel;
        }

        protected void performMoveDownItem() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            if (index < 0 || index >= table.getItemCount()) {
                return;
            }
            Object subject = this.getTableViewer().getElementAt(index);
            Object object = this.getTableViewer().getElementAt(index + 1);
            int subjectIndex = TableEditDialogColumnTab.this.tableModel.getAttributes().indexOf(subject);
            int objectIndex = TableEditDialogColumnTab.this.tableModel.getAttributes().indexOf(object);
            TableEditDialogColumnTab.this.jiemamyFacade.swapListElement((JiemamyElement)TableEditDialogColumnTab.this.tableModel, TableEditDialogColumnTab.this.tableModel.getAttributes(), subjectIndex, objectIndex);
            table.setSelection(index + 1);
            this.enableEditControls(index + 1);
        }

        protected void performMoveUpItem() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            if (index <= 0 || index > table.getItemCount()) {
                return;
            }
            Object subject = this.getTableViewer().getElementAt(index);
            Object object = this.getTableViewer().getElementAt(index - 1);
            int subjectIndex = TableEditDialogColumnTab.this.tableModel.getAttributes().indexOf(subject);
            int objectIndex = TableEditDialogColumnTab.this.tableModel.getAttributes().indexOf(object);
            TableEditDialogColumnTab.this.jiemamyFacade.swapListElement((JiemamyElement)TableEditDialogColumnTab.this.tableModel, TableEditDialogColumnTab.this.tableModel.getAttributes(), subjectIndex, objectIndex);
            table.setSelection(index - 1);
            this.enableEditControls(index - 1);
        }

        protected JiemamyElement performRemoveItem() {
            int nextSelection;
            TableViewer tableViewer = this.getTableViewer();
            Table table = tableViewer.getTable();
            int index = table.getSelectionIndex();
            if (index < 0 || index > table.getItemCount()) {
                return null;
            }
            AttributeModel subject = (AttributeModel)this.getTableViewer().getElementAt(index);
            TableEditDialogColumnTab.this.jiemamyFacade.removeAttribute(TableEditDialogColumnTab.this.tableModel, subject);
            tableViewer.remove((Object)subject);
            int n = nextSelection = table.getItemCount() > index ? index : index - 1;
            if (nextSelection >= 0) {
                table.setSelection(nextSelection);
                this.enableEditorControls(nextSelection);
            } else {
                this.disableEditorControls();
            }
            table.setFocus();
            this.typeOptionManagers.remove(subject);
            return subject;
        }

        private void createAdvancedEditComponents(Composite parent) {
            Group cmpAdvanced = new Group(parent, 0);
            cmpAdvanced.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout(4, false);
            cmpAdvanced.setLayout((Layout)layout);
            cmpAdvanced.setText("\u9ad8\u5ea6\u306a\u8a2d\u5b9a");
            Label label = new Label((Composite)cmpAdvanced, 0);
            label.setText("\u5236\u7d04\u540d(&M)");
            this.txtCheckName = new Text((Composite)cmpAdvanced, 2048);
            this.txtCheckName.setLayoutData((Object)new GridData(768));
            label = new Label((Composite)cmpAdvanced, 0);
            label.setText("\u30c1\u30a7\u30c3\u30af\u5236\u7d04\u5f0f(&K)");
            this.txtCheckExpression = new Text((Composite)cmpAdvanced, 2048);
            this.txtCheckExpression.setLayoutData((Object)new GridData(768));
            label = new Label((Composite)cmpAdvanced, 0);
            label.setText("\u30c7\u30d5\u30a9\u30eb\u30c8\u5024(&F)");
            this.txtDefaultValue = new Text((Composite)cmpAdvanced, 2048);
            this.txtDefaultValue.setLayoutData((Object)new GridData(768));
            label = new Label((Composite)cmpAdvanced, 0);
            label.setText("\u8aac\u660e(&D)");
            this.txtDescription = new Text((Composite)cmpAdvanced, 2050);
            this.txtDescription.setLayoutData((Object)new GridData(768));
        }

        private void updateModel() {
            int columnEditIndex = this.getTableViewer().getTable().getSelectionIndex();
            int selectionInedx = this.cmbDataType.getSelectionIndex();
            if (columnEditIndex == -1 || selectionInedx == -1) {
                return;
            }
            ColumnModel columnModel = (ColumnModel)TableEditDialogColumnTab.this.tableModel.findColumns().get(columnEditIndex);
            JiemamyFactory factory = columnModel.getJiemamy().getFactory();
            String columnName = JiemamyPropertyUtil.careNull((String)this.txtColumnName.getText(), (boolean)false);
            TableEditDialogColumnTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)columnModel, (JiemamyProperty)JiemamyProperty.AttributeProperty.name, (Object)columnName);
            String logicalName = JiemamyPropertyUtil.careNull((String)this.txtColumnLogicalName.getText(), (boolean)true);
            TableEditDialogColumnTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)columnModel, (JiemamyProperty)JiemamyProperty.AttributeProperty.logicalName, (Object)logicalName);
            DataType dataType = factory.newDataType((DataTypeMold)TableEditDialogColumnTab.this.allTypes.get(this.cmbDataType.getSelectionIndex()));
            TableEditDialogColumnTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)columnModel, (JiemamyProperty)JiemamyProperty.ColumnProperty.dataType, (Object)dataType);
            String defaultValue = JiemamyPropertyUtil.careNull((String)this.txtDefaultValue.getText(), (boolean)true);
            TableEditDialogColumnTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)columnModel, (JiemamyProperty)JiemamyProperty.ColumnProperty.defaultValue, (Object)defaultValue);
            String description = JiemamyPropertyUtil.careNull((String)this.txtDescription.getText(), (boolean)true);
            TableEditDialogColumnTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)columnModel, (JiemamyProperty)JiemamyProperty.AttributeProperty.description, (Object)description);
            if (!this.chkIsNotNull.getSelection()) {
                TableEditDialogColumnTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)columnModel, (JiemamyProperty)JiemamyProperty.ColumnProperty.notNullConstraint, null);
            } else if (columnModel.getNotNullConstraint() == null) {
                NotNullConstraint nnConstraint = (NotNullConstraint)factory.newModel(NotNullConstraint.class);
                TableEditDialogColumnTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)columnModel, (JiemamyProperty)JiemamyProperty.ColumnProperty.notNullConstraint, (Object)nnConstraint);
            }
            PrimaryKey primaryKey = null;
            try {
                primaryKey = TableEditDialogColumnTab.this.tableModel.findPrimaryKey();
            }
            catch (ElementNotFoundException elementNotFoundException) {}
            if (!this.chkIsPK.getSelection()) {
                if (primaryKey != null) {
                    TableEditDialogColumnTab.this.jiemamyFacade.removeKeyColumn((KeyConstraint)primaryKey, columnModel);
                }
            } else {
                if (primaryKey == null) {
                    primaryKey = (PrimaryKey)factory.newModel(PrimaryKey.class);
                    TableEditDialogColumnTab.this.jiemamyFacade.addAttribute(TableEditDialogColumnTab.this.tableModel, (AttributeModel)primaryKey);
                    TableEditDialogColumnTab.this.rootModel.normalize();
                }
                TableEditDialogColumnTab.this.jiemamyFacade.addKeyColumn((KeyConstraint)primaryKey, columnModel);
            }
            if (StringUtils.isEmpty((String)this.txtCheckName.getText()) && StringUtils.isEmpty((String)this.txtCheckExpression.getText())) {
                TableEditDialogColumnTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)columnModel, (JiemamyProperty)JiemamyProperty.ColumnProperty.checkConstraint, null);
            } else {
                ColumnCheckConstraint checkConstraint = columnModel.getCheckConstraint();
                if (checkConstraint == null) {
                    checkConstraint = (ColumnCheckConstraint)factory.newModel(ColumnCheckConstraint.class);
                    TableEditDialogColumnTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)columnModel, (JiemamyProperty)JiemamyProperty.ColumnProperty.checkConstraint, (Object)checkConstraint);
                }
                String checkName = JiemamyPropertyUtil.careNull((String)this.txtCheckName.getText(), (boolean)true);
                TableEditDialogColumnTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)checkConstraint, (JiemamyProperty)JiemamyProperty.ConstraintProperty.name, (Object)checkName);
                String expression = JiemamyPropertyUtil.careNull((String)this.txtCheckExpression.getText(), (boolean)false);
                TableEditDialogColumnTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)checkConstraint, (JiemamyProperty)JiemamyProperty.CheckConstraintProperty.expression, (Object)expression);
            }
            if (!this.chkIsDisabled.getSelection()) {
                if (columnModel.hasAdapter(Disablable.class)) {
                    columnModel.unregisterAdapter(Disablable.class);
                }
            } else {
                if (!columnModel.hasAdapter(Disablable.class)) {
                    columnModel.registerAdapter(factory.newAdapter(Disablable.class));
                }
                ((Disablable)columnModel.getAdapter(Disablable.class)).setDisabled(Boolean.valueOf(true));
            }
            this.typeOptionManagers.get(columnModel).writeBackToAdapter();
        }

        private class EditListenerImpl
        extends AbstractEditListener {
            private EditListenerImpl() {
            }

            protected void process(TypedEvent e) {
                ColumnTableEditor.this.updateModel();
                TableEditDialogColumnTab.this.columnTableEditor.refreshTable();
            }
        }
    }
}

