/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.dialog.table;

import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.jiemamy.EventBroker;
import org.jiemamy.Jiemamy;
import org.jiemamy.JiemamyFactory;
import org.jiemamy.JiemamyProperty;
import org.jiemamy.eclipse.editor.dialog.AbstractEditListener;
import org.jiemamy.eclipse.editor.dialog.EditListener;
import org.jiemamy.eclipse.ui.AbstractTableEditor;
import org.jiemamy.eclipse.ui.DefaultTableEditorConfig;
import org.jiemamy.eclipse.ui.helper.TextSelectionAdapter;
import org.jiemamy.eclipse.ui.tab.AbstractTab;
import org.jiemamy.editcommand.Command;
import org.jiemamy.editcommand.CommandListener;
import org.jiemamy.facade.JiemamyFacade;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.attribute.AttributeModel;
import org.jiemamy.model.attribute.constraint.CheckConstraint;
import org.jiemamy.model.attribute.constraint.TableCheckConstraint;
import org.jiemamy.model.entity.TableModel;
import org.jiemamy.utils.LogMarker;
import org.jiemamy.utils.model.JiemamyPropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class TableEditDialogCheckTab
extends AbstractTab {
    private static Logger logger = LoggerFactory.getLogger(TableEditDialogCheckTab.class);
    private final TableModel tableModel;
    private AbstractTableEditor checkEditor;
    private final JiemamyFacade jiemamyFacade;

    public TableEditDialogCheckTab(TabFolder parentTabFolder, int style, TableModel tableModel, JiemamyFacade jiemamyFacade) {
        super(parentTabFolder, style, "\u30c1\u30a7\u30c3\u30af\u5236\u7d04(&H)");
        this.tableModel = tableModel;
        this.jiemamyFacade = jiemamyFacade;
        Composite composite = new Composite((Composite)parentTabFolder, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.checkEditor = new CheckTableEditor(composite, 0);
        this.checkEditor.configure();
        this.checkEditor.disableEditControls();
        this.getTabItem().setControl((Control)composite);
    }

    public boolean isTabComplete() {
        return true;
    }

    private class CheckContentProvider
    extends ArrayContentProvider
    implements CommandListener {
        private Viewer viewer;

        private CheckContentProvider() {
        }

        public void commandExecuted(Command command) {
            logger.debug((Marker)LogMarker.LIFECYCLE, "CheckContentProvider: commandExecuted");
            TableEditDialogCheckTab.this.checkEditor.refreshTable();
        }

        public void dispose() {
            logger.debug((Marker)LogMarker.LIFECYCLE, "CheckContentProvider: disposed");
            super.dispose();
        }

        public JiemamyElement getTargetModel() {
            return (JiemamyElement)this.viewer.getInput();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            logger.debug((Marker)LogMarker.LIFECYCLE, "CheckContentProvider: input changed");
            logger.trace((Marker)LogMarker.LIFECYCLE, "oldInput: " + oldInput);
            logger.trace((Marker)LogMarker.LIFECYCLE, "newInput: " + newInput);
            this.viewer = viewer;
            super.inputChanged(viewer, oldInput, newInput);
        }
    }

    private class CheckLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private CheckLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof TableCheckConstraint)) {
                return "";
            }
            TableCheckConstraint check = (TableCheckConstraint)element;
            switch (columnIndex) {
                case 0: {
                    return check.getName();
                }
                case 1: {
                    return check.getExpression();
                }
            }
            return "";
        }
    }

    private class CheckTableEditor
    extends AbstractTableEditor {
        private static final int COL_WIDTH_NAME = 200;
        private static final int COL_WIDTH_EXPRESSION = 500;
        private final EditListener editListener;
        private final Jiemamy jiemamy;
        private Text txtCheckName;
        private Text txtCheckExpression;
        private final List<AttributeModel> attributes;

        public CheckTableEditor(Composite parent, int style) {
            super(parent, style, new DefaultTableEditorConfig("\u30c1\u30a7\u30c3\u30af\u5236\u7d04\u60c5\u5831"));
            this.editListener = new EditListenerImpl();
            this.jiemamy = TableEditDialogCheckTab.this.tableModel.getJiemamy();
            this.attributes = TableEditDialogCheckTab.this.tableModel.getAttributes();
            assert (this.jiemamy != null);
            assert (this.attributes != null);
        }

        protected void configureEditorControls() {
            super.configureEditorControls();
            this.txtCheckName.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtCheckName));
            this.txtCheckName.addKeyListener((KeyListener)this.editListener);
            this.txtCheckExpression.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtCheckExpression));
            this.txtCheckExpression.addKeyListener((KeyListener)this.editListener);
        }

        protected void configureTableViewer(TableViewer tableViewer) {
            tableViewer.setLabelProvider((IBaseLabelProvider)new CheckLabelProvider());
            final CheckContentProvider contentProvider = new CheckContentProvider();
            tableViewer.setContentProvider((IContentProvider)contentProvider);
            tableViewer.setInput(this.attributes);
            tableViewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return element instanceof TableCheckConstraint;
                }
            });
            final EventBroker eventBroker = this.jiemamy.getEventBroker();
            eventBroker.addListener((CommandListener)contentProvider);
            tableViewer.getTable().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    eventBroker.removeListener((CommandListener)contentProvider);
                }
            });
        }

        protected void createEditorControls(Composite parent) {
            Composite cmpNames = new Composite(parent, 0);
            cmpNames.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout(4, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cmpNames.setLayout((Layout)layout);
            Label label = new Label(cmpNames, 0);
            label.setText("\u5236\u7d04\u540d(&M)");
            this.txtCheckName = new Text(cmpNames, 2048);
            this.txtCheckName.setLayoutData((Object)new GridData(768));
            label = new Label(cmpNames, 0);
            label.setText("\u30c1\u30a7\u30c3\u30af\u5236\u7d04\u5f0f(&P)");
            this.txtCheckExpression = new Text(cmpNames, 2048);
            this.txtCheckExpression.setLayoutData((Object)new GridData(768));
        }

        protected void createTableColumns(Table table) {
            TableColumn colName = new TableColumn(table, 16384);
            colName.setText("\u5236\u7d04\u540d");
            colName.setWidth(200);
            TableColumn colExpression = new TableColumn(table, 16384);
            colExpression.setText("\u30c1\u30a7\u30c3\u30af\u5236\u7d04\u5f0f");
            colExpression.setWidth(500);
        }

        protected void disableEditorControls() {
            this.txtCheckName.setEnabled(false);
            this.txtCheckExpression.setEnabled(false);
            this.txtCheckName.setText("");
            this.txtCheckExpression.setText("");
        }

        protected void enableEditorControls(int index) {
            CheckConstraint checkConstraint = (CheckConstraint)this.getTableViewer().getElementAt(index);
            this.txtCheckName.setEnabled(true);
            this.txtCheckExpression.setEnabled(true);
            this.txtCheckName.setText(JiemamyPropertyUtil.careNull((String)checkConstraint.getName()));
            this.txtCheckExpression.setText(JiemamyPropertyUtil.careNull((String)checkConstraint.getExpression()));
        }

        protected JiemamyElement performAddItem() {
            Table table = this.getTableViewer().getTable();
            JiemamyFactory factory = this.jiemamy.getFactory();
            TableCheckConstraint checkConstraint = (TableCheckConstraint)factory.newModel(TableCheckConstraint.class);
            TableEditDialogCheckTab.this.jiemamyFacade.addAttribute(TableEditDialogCheckTab.this.tableModel, (AttributeModel)checkConstraint);
            int addedIndex = TableEditDialogCheckTab.this.tableModel.findAttributes(TableCheckConstraint.class).indexOf(checkConstraint);
            table.setSelection(addedIndex);
            this.enableEditControls(addedIndex);
            this.txtCheckName.setFocus();
            return checkConstraint;
        }

        protected JiemamyElement performInsertItem() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            JiemamyFactory factory = this.jiemamy.getFactory();
            TableCheckConstraint checkConstraint = (TableCheckConstraint)factory.newModel(TableCheckConstraint.class);
            if (index < 0 || index > table.getItemCount()) {
                TableEditDialogCheckTab.this.jiemamyFacade.addAttribute(TableEditDialogCheckTab.this.tableModel, (AttributeModel)checkConstraint);
            } else {
                AttributeModel attributeModel = (AttributeModel)this.getTableViewer().getElementAt(index);
                int subjectIndex = this.attributes.indexOf(attributeModel);
                TableEditDialogCheckTab.this.jiemamyFacade.addAttribute(TableEditDialogCheckTab.this.tableModel, subjectIndex, (AttributeModel)checkConstraint);
            }
            int addedIndex = TableEditDialogCheckTab.this.tableModel.findAttributes(TableCheckConstraint.class).indexOf(checkConstraint);
            table.setSelection(addedIndex);
            this.enableEditControls(addedIndex);
            this.txtCheckName.setFocus();
            return checkConstraint;
        }

        protected void performMoveDownItem() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            if (index < 0 || index >= table.getItemCount()) {
                return;
            }
            Object subject = this.getTableViewer().getElementAt(index);
            Object object = this.getTableViewer().getElementAt(index + 1);
            int subjectIndex = TableEditDialogCheckTab.this.tableModel.getAttributes().indexOf(subject);
            int objectIndex = TableEditDialogCheckTab.this.tableModel.getAttributes().indexOf(object);
            TableEditDialogCheckTab.this.jiemamyFacade.swapListElement((JiemamyElement)TableEditDialogCheckTab.this.tableModel, TableEditDialogCheckTab.this.tableModel.getAttributes(), subjectIndex, objectIndex);
            table.setSelection(index + 1);
            this.enableEditControls(index + 1);
        }

        protected void performMoveUpItem() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            if (index <= 0 || index > table.getItemCount()) {
                return;
            }
            Object subject = this.getTableViewer().getElementAt(index);
            Object object = this.getTableViewer().getElementAt(index - 1);
            int subjectIndex = TableEditDialogCheckTab.this.tableModel.getAttributes().indexOf(subject);
            int objectIndex = TableEditDialogCheckTab.this.tableModel.getAttributes().indexOf(object);
            TableEditDialogCheckTab.this.jiemamyFacade.swapListElement((JiemamyElement)TableEditDialogCheckTab.this.tableModel, TableEditDialogCheckTab.this.tableModel.getAttributes(), subjectIndex, objectIndex);
            table.setSelection(index - 1);
            this.enableEditControls(index - 1);
        }

        protected JiemamyElement performRemoveItem() {
            int nextSelection;
            TableViewer tableViewer = this.getTableViewer();
            Table table = tableViewer.getTable();
            int index = table.getSelectionIndex();
            if (index < 0 || index > table.getItemCount()) {
                return null;
            }
            Object subject = this.getTableViewer().getElementAt(index);
            TableEditDialogCheckTab.this.jiemamyFacade.removeAttribute(TableEditDialogCheckTab.this.tableModel, (AttributeModel)subject);
            tableViewer.remove(subject);
            int n = nextSelection = table.getItemCount() > index ? index : index - 1;
            if (nextSelection >= 0) {
                table.setSelection(nextSelection);
                this.enableEditorControls(nextSelection);
            } else {
                this.disableEditorControls();
            }
            table.setFocus();
            return (JiemamyElement)subject;
        }

        private void updateModel() {
            int editIndex = this.getTableViewer().getTable().getSelectionIndex();
            if (editIndex == -1) {
                return;
            }
            CheckConstraint checkConstraint = (CheckConstraint)TableEditDialogCheckTab.this.tableModel.findAttributes(TableCheckConstraint.class).get(editIndex);
            String checkName = JiemamyPropertyUtil.careNull((String)this.txtCheckName.getText(), (boolean)true);
            TableEditDialogCheckTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)checkConstraint, (JiemamyProperty)JiemamyProperty.ConstraintProperty.name, (Object)checkName);
            String expression = JiemamyPropertyUtil.careNull((String)this.txtCheckExpression.getText(), (boolean)true);
            TableEditDialogCheckTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)checkConstraint, (JiemamyProperty)JiemamyProperty.CheckConstraintProperty.expression, (Object)expression);
        }

        private class EditListenerImpl
        extends AbstractEditListener {
            private EditListenerImpl() {
            }

            protected void process(TypedEvent e) {
                CheckTableEditor.this.updateModel();
                TableEditDialogCheckTab.this.checkEditor.refreshTable();
            }
        }
    }
}

