/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.dialog.table;

import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;
import org.jiemamy.JiemamyFactory;
import org.jiemamy.JiemamyProperty;
import org.jiemamy.eclipse.JiemamyUIPlugin;
import org.jiemamy.eclipse.editor.dialog.table.Messages;
import org.jiemamy.eclipse.editor.dialog.table.TableEditDialogCheckTab;
import org.jiemamy.eclipse.editor.dialog.table.TableEditDialogColumnTab;
import org.jiemamy.eclipse.editor.dialog.table.TableEditDialogIndexTab;
import org.jiemamy.eclipse.editor.dialog.table.TableEditDialogLocalKeyTab;
import org.jiemamy.eclipse.ui.JiemamyEditDialog;
import org.jiemamy.eclipse.ui.helper.TextSelectionAdapter;
import org.jiemamy.eclipse.ui.tab.TextEditTab;
import org.jiemamy.eclipse.utils.ConvertUtil;
import org.jiemamy.facade.JiemamyFacade;
import org.jiemamy.facade.JiemamyViewFacade;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.attribute.ColumnModel;
import org.jiemamy.model.entity.EntityModel;
import org.jiemamy.model.entity.TableModel;
import org.jiemamy.model.node.NodeAdapter;
import org.jiemamy.utils.Disablable;
import org.jiemamy.utils.model.JiemamyPropertyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableEditDialog
extends JiemamyEditDialog<TableModel> {
    private static final Point DEFAULT_SIZE = new Point(700, 500);
    private Text txtName;
    private Text txtLogicalName;
    private TextEditTab tabBeginScript;
    private TextEditTab tabEndScript;
    private TextEditTab tabDescription;
    private final int diagramIndex;
    private final JiemamyViewFacade jiemamyFacade;

    public TableEditDialog(Shell parentShell, TableModel tableModel, int diagramIndex, JiemamyViewFacade jiemamyFacade) {
        super(parentShell, tableModel, TableModel.class);
        Validate.notNull((Object)tableModel);
        Validate.notNull((Object)jiemamyFacade);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.diagramIndex = diagramIndex;
        this.jiemamyFacade = jiemamyFacade;
    }

    protected Control createDialogArea(Composite parent) {
        final TableModel tableModel = (TableModel)this.getTargetModel();
        this.getShell().setText("\u30c6\u30fc\u30d6\u30eb\u60c5\u5831\u7de8\u96c6");
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(7, false));
        Label label = new Label(composite, 0);
        label.setText("\u30c6\u30fc\u30d6\u30eb\u540d(&N)");
        this.txtName = new Text(composite, 2052);
        this.txtName.setLayoutData((Object)new GridData(768));
        this.txtName.setText(tableModel.getName());
        this.txtName.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtName));
        this.txtName.addKeyListener((KeyListener)this.editListener);
        label = new Label(composite, 0);
        label.setText("\u8ad6\u7406\u540d(&L)");
        this.txtLogicalName = new Text(composite, 2052);
        this.txtLogicalName.setLayoutData((Object)new GridData(768));
        this.txtLogicalName.setText(JiemamyPropertyUtil.careNull((String)tableModel.getLogicalName()));
        this.txtLogicalName.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtLogicalName));
        this.txtLogicalName.addKeyListener((KeyListener)this.editListener);
        ImageRegistry ir = JiemamyUIPlugin.getDefault().getImageRegistry();
        Button btnColor = new Button(composite, 8);
        btnColor.setImage(ir.get("ICON_COLOR_PALETTE"));
        btnColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ColorDialog colorDialog = new ColorDialog(TableEditDialog.this.getShell(), 0);
                RGB rgb = colorDialog.open();
                if (rgb != null) {
                    NodeAdapter nodeAdapter = (NodeAdapter)tableModel.getAdapter(NodeAdapter.class);
                    TableEditDialog.this.jiemamyFacade.setColor(TableEditDialog.this.diagramIndex, nodeAdapter, ConvertUtil.convert(rgb));
                }
            }
        });
        Button btnDefaultColor = new Button(composite, 8);
        btnDefaultColor.setText("default color");
        btnDefaultColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                NodeAdapter nodeAdapter = (NodeAdapter)tableModel.getAdapter(NodeAdapter.class);
                TableEditDialog.this.jiemamyFacade.setColor(TableEditDialog.this.diagramIndex, nodeAdapter, null);
            }
        });
        final Button btnDisable = new Button(composite, 32);
        btnDisable.setText("\u7121\u52b9");
        btnDisable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (!tableModel.hasAdapter(Disablable.class)) {
                    JiemamyFactory factory = tableModel.getJiemamy().getFactory();
                    tableModel.registerAdapter(factory.newAdapter(Disablable.class));
                }
                ((Disablable)tableModel.getAdapter(Disablable.class)).setDisabled(Boolean.valueOf(btnDisable.getSelection()));
            }
        });
        if (tableModel.hasAdapter(Disablable.class) && Boolean.TRUE.equals(((Disablable)tableModel.getAdapter(Disablable.class)).isDisabled())) {
            btnDisable.setSelection(true);
        }
        TabFolder tabFolder = new TabFolder(composite, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 7;
        tabFolder.setLayoutData((Object)gd);
        this.createTabs(tableModel, tabFolder);
        return composite;
    }

    @Override
    protected Point getDefaultSize() {
        return DEFAULT_SIZE;
    }

    @Override
    protected boolean performOk() {
        boolean columnCheckOk;
        boolean entityCheckOk;
        if (StringUtils.isEmpty((String)this.txtName.getText())) {
            return false;
        }
        TableModel tableModel = (TableModel)this.getTargetModel();
        RootModel rootModel = tableModel.getJiemamy().getFactory().getRootModel();
        SortedSet entities = rootModel.getEntities();
        HashSet<String> entityNames = new HashSet<String>(entities.size());
        for (EntityModel entityModel : entities) {
            if (entityModel == tableModel) continue;
            entityNames.add(entityModel.getName());
        }
        List columns = tableModel.findColumns();
        HashSet<String> columnNames = new HashSet<String>(columns.size());
        for (ColumnModel columnModel : columns) {
            columnNames.add(columnModel.getName());
        }
        if (entityNames.contains(this.txtName.getText()) && !(entityCheckOk = MessageDialog.openQuestion((Shell)this.getParentShell(), (String)"Confirm", (String)"\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u540d\u304c\u91cd\u8907\u3057\u307e\u3059\u304c\u3001\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f"))) {
            return false;
        }
        if (columnNames.size() != columns.size() && !(columnCheckOk = MessageDialog.openQuestion((Shell)this.getParentShell(), (String)"Confirm", (String)"\u30ab\u30e9\u30e0\u540d\u304c\u91cd\u8907\u3057\u307e\u3059\u304c\u3001\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f"))) {
            return false;
        }
        String name = JiemamyPropertyUtil.careNull((String)this.txtName.getText(), (boolean)false);
        this.jiemamyFacade.changeModelProperty((JiemamyElement)tableModel, (JiemamyProperty)JiemamyProperty.EntityProperty.name, (Object)name);
        String logicalName = JiemamyPropertyUtil.careNull((String)this.txtLogicalName.getText(), (boolean)true);
        this.jiemamyFacade.changeModelProperty((JiemamyElement)tableModel, (JiemamyProperty)JiemamyProperty.EntityProperty.logicalName, (Object)logicalName);
        String beginScript = JiemamyPropertyUtil.careNull((String)this.tabBeginScript.getTextWidget().getText(), (boolean)true);
        this.jiemamyFacade.changeModelProperty((JiemamyElement)tableModel, (JiemamyProperty)JiemamyProperty.EntityProperty.beginScript, (Object)beginScript);
        String endScript = JiemamyPropertyUtil.careNull((String)this.tabEndScript.getTextWidget().getText(), (boolean)true);
        this.jiemamyFacade.changeModelProperty((JiemamyElement)tableModel, (JiemamyProperty)JiemamyProperty.EntityProperty.endScript, (Object)endScript);
        String description = JiemamyPropertyUtil.careNull((String)this.tabDescription.getTextWidget().getText(), (boolean)true);
        this.jiemamyFacade.changeModelProperty((JiemamyElement)tableModel, (JiemamyProperty)JiemamyProperty.EntityProperty.description, (Object)description);
        return true;
    }

    private void createTabs(TableModel tableModel, TabFolder tabFolder) {
        TableEditDialogColumnTab tabColumn = new TableEditDialogColumnTab(tabFolder, 0, tableModel, (JiemamyFacade)this.jiemamyFacade);
        tabColumn.addKeyListener(this.editListener);
        this.addTab(tabColumn);
        TableEditDialogLocalKeyTab tabLocalKey = new TableEditDialogLocalKeyTab(tabFolder, 0, tableModel, (JiemamyFacade)this.jiemamyFacade);
        tabLocalKey.addKeyListener(this.editListener);
        this.addTab(tabLocalKey);
        TableEditDialogCheckTab tabCheck = new TableEditDialogCheckTab(tabFolder, 0, tableModel, (JiemamyFacade)this.jiemamyFacade);
        tabCheck.addKeyListener(this.editListener);
        this.addTab(tabCheck);
        TableEditDialogIndexTab tabIndex = new TableEditDialogIndexTab(tabFolder, 0, tableModel, (JiemamyFacade)this.jiemamyFacade);
        tabIndex.addKeyListener(this.editListener);
        this.addTab(tabIndex);
        String beginScript = JiemamyPropertyUtil.careNull((String)tableModel.getBeginScript());
        this.tabBeginScript = new TextEditTab(tabFolder, Messages.Tab_Table_BeginScript, beginScript);
        this.addTab(this.tabBeginScript);
        String endScript = JiemamyPropertyUtil.careNull((String)tableModel.getEndScript());
        this.tabEndScript = new TextEditTab(tabFolder, Messages.Tab_Table_EndScript, endScript);
        this.addTab(this.tabEndScript);
        String description = JiemamyPropertyUtil.careNull((String)tableModel.getDescription());
        this.tabDescription = new TextEditTab(tabFolder, Messages.Tab_Table_Description, description);
        this.addTab(this.tabDescription);
        this.createAdditionalTabs(tabFolder);
    }
}

