/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.dialog.table;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.jiemamy.eclipse.editor.DisplayPlace;
import org.jiemamy.eclipse.editor.dialog.table.Messages;
import org.jiemamy.eclipse.editor.utils.LabelStringUtil;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.attribute.ColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnSelectDialog
extends Dialog {
    private static final int COL_WIDTH_STATUS = 40;
    private static final int COL_WIDTH_NAME = 100;
    private static final int COL_WIDTH_TYPE = 150;
    private int selectIndex = -1;
    private List<ColumnModel> columns;
    private Table tblColumns;

    public ColumnSelectDialog(Shell shell, List<ColumnModel> columns) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.columns = columns;
    }

    public ColumnModel getResult() {
        if (this.selectIndex >= 0 && this.selectIndex < this.columns.size()) {
            return this.columns.get(this.selectIndex);
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.ColumnSelectDialog_title);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.tblColumns = new Table(parent, 67588);
        this.tblColumns.setLayoutData((Object)new GridData(1808));
        this.tblColumns.setHeaderVisible(true);
        TableColumn colStatus = new TableColumn(this.tblColumns, 16384);
        colStatus.setText("");
        colStatus.setWidth(40);
        TableColumn colName = new TableColumn(this.tblColumns, 16384);
        colName.setText(Messages.ColumnSelectDialog_columnName_column);
        colName.setWidth(100);
        TableColumn colType = new TableColumn(this.tblColumns, 16384);
        colType.setText(Messages.ColumnSelectDialog_dataType_column);
        colType.setWidth(150);
        this.refreshTable();
        this.tblColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnSelectDialog.this.selectIndex = ColumnSelectDialog.this.tblColumns.getSelectionIndex();
            }
        });
        return composite;
    }

    protected void refreshTable() {
        this.tblColumns.removeAll();
        for (ColumnModel model : this.columns) {
            TableItem item = new TableItem(this.tblColumns, 0);
            this.updateColumnTableItem(item, model);
        }
    }

    private void updateColumnTableItem(TableItem item, ColumnModel columnModel) {
        RootModel rootModel = columnModel.getJiemamy().getFactory().getRootModel();
        item.setText(0, "");
        item.setText(1, LabelStringUtil.getString(rootModel, (JiemamyElement)columnModel, DisplayPlace.TABLE));
        item.setText(2, LabelStringUtil.getString(rootModel, columnModel.getDataType(), DisplayPlace.TABLE));
    }
}

