/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.dialog.sticky;

import org.apache.commons.lang.Validate;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.jiemamy.JiemamyProperty;
import org.jiemamy.JiemamyViewProperty;
import org.jiemamy.eclipse.JiemamyUIPlugin;
import org.jiemamy.eclipse.editor.dialog.sticky.Messages;
import org.jiemamy.eclipse.ui.JiemamyEditDialog;
import org.jiemamy.eclipse.ui.tab.TextEditTab;
import org.jiemamy.eclipse.utils.ConvertUtil;
import org.jiemamy.facade.JiemamyViewFacade;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.node.NodeAdapter;
import org.jiemamy.model.node.StickyModel;
import org.jiemamy.utils.model.JiemamyPropertyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StickyEditDialog
extends JiemamyEditDialog<StickyModel> {
    private static final Point DEFAULT_SIZE = new Point(598, 370);
    private TextEditTab tabContents;
    private final int diagramIndex;
    private final JiemamyViewFacade jiemamyFacade;

    public StickyEditDialog(Shell shell, StickyModel stickyModel, int diagramIndex, JiemamyViewFacade jiemamyFacade) {
        super(shell, stickyModel, StickyModel.class);
        Validate.notNull((Object)stickyModel);
        Validate.notNull((Object)jiemamyFacade);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.diagramIndex = diagramIndex;
        this.jiemamyFacade = jiemamyFacade;
    }

    protected Control createDialogArea(Composite parent) {
        final StickyModel stickyModel = (StickyModel)this.getTargetModel();
        this.getShell().setText(Messages.Dialog_Title);
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(6, false));
        ImageRegistry ir = JiemamyUIPlugin.getDefault().getImageRegistry();
        Button btnColor = new Button(composite, 8);
        btnColor.setImage(ir.get("ICON_COLOR_PALETTE"));
        btnColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ColorDialog colorDialog = new ColorDialog(StickyEditDialog.this.getShell(), 0);
                RGB rgb = colorDialog.open();
                if (rgb != null) {
                    StickyEditDialog.this.jiemamyFacade.setColor(StickyEditDialog.this.diagramIndex, (NodeAdapter)stickyModel, ConvertUtil.convert(rgb));
                }
            }
        });
        Button btnDefaultColor = new Button(composite, 8);
        btnDefaultColor.setText("default color");
        btnDefaultColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                StickyEditDialog.this.jiemamyFacade.setColor(StickyEditDialog.this.diagramIndex, (NodeAdapter)stickyModel, null);
            }
        });
        TabFolder tabFolder = new TabFolder(composite, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 6;
        tabFolder.setLayoutData((Object)gd);
        String contents = JiemamyPropertyUtil.careNull((String)stickyModel.getContents());
        this.tabContents = new TextEditTab(tabFolder, Messages.Tab_Sticky_Contents, contents);
        this.tabContents.addKeyListener(new JiemamyEditDialog.EditListenerImpl(this));
        this.addTab(this.tabContents);
        this.createAdditionalTabs(tabFolder);
        return composite;
    }

    @Override
    protected Point getDefaultSize() {
        return DEFAULT_SIZE;
    }

    @Override
    protected boolean performOk() {
        StickyModel stickyModel = (StickyModel)this.getTargetModel();
        String contents = JiemamyPropertyUtil.careNull((String)this.tabContents.getTextWidget().getText(), (boolean)true);
        this.jiemamyFacade.changeModelProperty((JiemamyElement)stickyModel, (JiemamyProperty)JiemamyViewProperty.StickyProperty.contents, (Object)contents);
        return true;
    }
}

