/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.dialog.root;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.jiemamy.eclipse.editor.DisplayPlace;
import org.jiemamy.eclipse.editor.utils.LabelStringUtil;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.entity.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableSelectDialog
extends Dialog {
    private static final int COL_WIDTH_STATUS = 40;
    private static final int COL_WIDTH_NAME = 100;
    private int selectIndex = -1;
    private List<TableModel> tables;
    private Table tblColumns;

    public TableSelectDialog(Shell shell, List<TableModel> tables) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.tables = tables;
    }

    public TableModel getResult() {
        if (this.selectIndex >= 0 && this.selectIndex < this.tables.size()) {
            return this.tables.get(this.selectIndex);
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("\u30c6\u30fc\u30d6\u30eb\u9078\u629e");
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.tblColumns = new Table(parent, 67588);
        this.tblColumns.setLayoutData((Object)new GridData(1808));
        this.tblColumns.setHeaderVisible(true);
        TableColumn colStatus = new TableColumn(this.tblColumns, 16384);
        colStatus.setText("");
        colStatus.setWidth(40);
        TableColumn colName = new TableColumn(this.tblColumns, 16384);
        colName.setText("\u30c6\u30fc\u30d6\u30eb\u540d");
        colName.setWidth(100);
        this.refreshTable();
        this.tblColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableSelectDialog.this.selectIndex = TableSelectDialog.this.tblColumns.getSelectionIndex();
            }
        });
        return composite;
    }

    protected void refreshTable() {
        this.tblColumns.removeAll();
        for (TableModel model : this.tables) {
            TableItem item = new TableItem(this.tblColumns, 0);
            this.updateColumnTableItem(item, model);
        }
    }

    private void updateColumnTableItem(TableItem item, TableModel tableModel) {
        RootModel rootModel = tableModel.getJiemamy().getFactory().getRootModel();
        item.setText(0, "");
        item.setText(1, LabelStringUtil.getString(rootModel, (JiemamyElement)tableModel, DisplayPlace.TABLE));
    }
}

