/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.dialog.root;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.jiemamy.EventBroker;
import org.jiemamy.Jiemamy;
import org.jiemamy.JiemamyFactory;
import org.jiemamy.JiemamyProperty;
import org.jiemamy.ReferenceResolver;
import org.jiemamy.dialect.BuiltinDataTypeMold;
import org.jiemamy.dialect.Dialect;
import org.jiemamy.eclipse.JiemamyCorePlugin;
import org.jiemamy.eclipse.JiemamyUIPlugin;
import org.jiemamy.eclipse.editor.DisplayPlace;
import org.jiemamy.eclipse.editor.dialog.AbstractEditListener;
import org.jiemamy.eclipse.editor.dialog.EditListener;
import org.jiemamy.eclipse.editor.dialog.TypeOptionHandler;
import org.jiemamy.eclipse.editor.dialog.TypeOptionManager;
import org.jiemamy.eclipse.editor.dialog.root.Messages;
import org.jiemamy.eclipse.editor.utils.LabelStringUtil;
import org.jiemamy.eclipse.extension.ExtensionResolver;
import org.jiemamy.eclipse.ui.AbstractTableEditor;
import org.jiemamy.eclipse.ui.DefaultTableEditorConfig;
import org.jiemamy.eclipse.ui.helper.TextSelectionAdapter;
import org.jiemamy.eclipse.ui.tab.AbstractTab;
import org.jiemamy.eclipse.utils.ExceptionHandler;
import org.jiemamy.editcommand.Command;
import org.jiemamy.editcommand.CommandListener;
import org.jiemamy.facade.JiemamyFacade;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.attribute.constraint.ColumnCheckConstraint;
import org.jiemamy.model.attribute.constraint.NotNullConstraint;
import org.jiemamy.model.datatype.BuiltinDataType;
import org.jiemamy.model.datatype.DataType;
import org.jiemamy.model.datatype.DataTypeHolder;
import org.jiemamy.model.datatype.DataTypeMold;
import org.jiemamy.model.datatype.DomainModel;
import org.jiemamy.model.datatype.adapter.PrecisionedDataTypeAdapter;
import org.jiemamy.model.datatype.adapter.SizedDataTypeAdapter;
import org.jiemamy.model.datatype.adapter.TimezonedDataTypeAdapter;
import org.jiemamy.utils.CollectionsUtil;
import org.jiemamy.utils.LogMarker;
import org.jiemamy.utils.model.DataTypeUtil;
import org.jiemamy.utils.model.JiemamyPropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class RootEditDialogDomainTab
extends AbstractTab {
    private static Logger logger = LoggerFactory.getLogger(RootEditDialogDomainTab.class);
    private final RootModel rootModel;
    private List<BuiltinDataTypeMold> allTypes;
    private AbstractTableEditor domainTableEditor;
    private final JiemamyFacade jiemamyFacade;

    public RootEditDialogDomainTab(TabFolder parentTabFolder, int style, RootModel rootModel, JiemamyFacade jiemamyFacade) {
        super(parentTabFolder, style, Messages.Tab_Domains);
        Dialect dialect;
        this.rootModel = rootModel;
        this.jiemamyFacade = jiemamyFacade;
        try {
            dialect = rootModel.findDialect();
        }
        catch (ClassNotFoundException e) {
            dialect = (Dialect)JiemamyCorePlugin.getDialectResolver().getAllInstance().get(0);
            logger.warn("Dialect\u306e\u30ed\u30b9\u30c8", (Throwable)e);
        }
        this.allTypes = CollectionsUtil.newArrayList((int)dialect.getAllDataTypes().size());
        this.allTypes.addAll(dialect.getAllDataTypes());
        Composite composite = new Composite((Composite)parentTabFolder, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.domainTableEditor = new DomainTableEditor(composite, 0);
        this.domainTableEditor.configure();
        this.domainTableEditor.disableEditControls();
        this.getTabItem().setControl((Control)composite);
    }

    public boolean isTabComplete() {
        return true;
    }

    private class DomainContentProvider
    extends ArrayContentProvider
    implements CommandListener {
        private Viewer viewer;

        private DomainContentProvider() {
        }

        public void commandExecuted(Command command) {
            logger.debug((Marker)LogMarker.LIFECYCLE, "DomainContentProvider: commandExecuted");
            RootEditDialogDomainTab.this.domainTableEditor.refreshTable();
        }

        public void dispose() {
            logger.debug((Marker)LogMarker.LIFECYCLE, "DomainContentProvider: disposed");
            super.dispose();
        }

        public JiemamyElement getTargetModel() {
            return (JiemamyElement)this.viewer.getInput();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            logger.debug((Marker)LogMarker.LIFECYCLE, "DomainContentProvider: input changed");
            logger.trace((Marker)LogMarker.LIFECYCLE, "oldInput: " + oldInput);
            logger.trace((Marker)LogMarker.LIFECYCLE, "newInput: " + newInput);
            this.viewer = viewer;
            super.inputChanged(viewer, oldInput, newInput);
        }
    }

    private class DomainLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private DomainLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ImageRegistry ir = JiemamyUIPlugin.getDefault().getImageRegistry();
            DomainModel domainModel = (DomainModel)element;
            switch (columnIndex) {
                case 2: {
                    return ir.get(domainModel.getNotNullConstraint() != null ? "CHECK_ON" : "CHECK_OFF");
                }
                case 3: {
                    ColumnCheckConstraint check = domainModel.getCheckConstraint();
                    return ir.get(check != null && !StringUtils.isEmpty((String)check.getExpression()) ? "CHECK_ON" : "CHECK_OFF");
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            DomainModel domainModel = (DomainModel)element;
            switch (columnIndex) {
                case 0: {
                    return LabelStringUtil.getString(RootEditDialogDomainTab.this.rootModel, (JiemamyElement)domainModel, DisplayPlace.TABLE);
                }
                case 1: {
                    return LabelStringUtil.getString(RootEditDialogDomainTab.this.rootModel, domainModel.getDataType(), DisplayPlace.TABLE);
                }
            }
            return "";
        }
    }

    private class DomainTableEditor
    extends AbstractTableEditor {
        private static final int COL_WIDTH_NAME = 100;
        private static final int COL_WIDTH_TYPE = 150;
        private static final int COL_WIDTH_NN = 80;
        private static final int COL_WIDTH_CHECK = 80;
        private final EditListener editListener;
        private final Jiemamy jiemamy;
        private Dialect dialect;
        private Text txtDomainName;
        private Combo cmbDataType;
        private Text txtCheckName;
        private Text txtCheckExpression;
        private Button chkIsNotNull;
        private Text txtDescription;
        private Composite cmpTypeOption;
        private Map<DomainModel, TypeOptionManager> typeOptionManagers;
        private final List<DomainModel> domains;
        private TypeOptionHandler typeOptionHandler;

        public DomainTableEditor(Composite parent, int style) {
            super(parent, style, new DefaultTableEditorConfig(Messages.Label_GroupTitle_Domain));
            this.editListener = new EditListenerImpl();
            this.typeOptionManagers = CollectionsUtil.newHashMap();
            this.jiemamy = RootEditDialogDomainTab.this.rootModel.getJiemamy();
            this.domains = RootEditDialogDomainTab.this.rootModel.getDomains();
            try {
                this.dialect = RootEditDialogDomainTab.this.rootModel.findDialect();
            }
            catch (ClassNotFoundException e) {
                this.dialect = (Dialect)JiemamyCorePlugin.getDialectResolver().getAllInstance().get(0);
                logger.warn("Dialect\u306e\u30ed\u30b9\u30c8", (Throwable)e);
            }
            assert (this.jiemamy != null);
            assert (this.domains != null);
            assert (this.dialect != null);
        }

        protected void configureEditorControls() {
            super.configureEditorControls();
            for (BuiltinDataTypeMold typeInfo : RootEditDialogDomainTab.this.allTypes) {
                this.cmbDataType.add(typeInfo.getName());
            }
            this.txtDomainName.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtDomainName));
            this.txtDomainName.addKeyListener((KeyListener)this.editListener);
            this.cmbDataType.addSelectionListener((SelectionListener)this.editListener);
            this.cmbDataType.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Table table = DomainTableEditor.this.getTableViewer().getTable();
                    int index = table.getSelectionIndex();
                    if (index < 0 || index >= table.getItemCount()) {
                        return;
                    }
                    DomainModel domainModel = (DomainModel)DomainTableEditor.this.getTableViewer().getElementAt(index);
                    TypeOptionManager typeOptionManager = (TypeOptionManager)DomainTableEditor.this.typeOptionManagers.get(domainModel);
                    DataTypeMold dataTypeMold = (DataTypeMold)RootEditDialogDomainTab.this.allTypes.get(DomainTableEditor.this.cmbDataType.getSelectionIndex());
                    if (dataTypeMold instanceof BuiltinDataTypeMold) {
                        BuiltinDataTypeMold builtinDataTypeMold = (BuiltinDataTypeMold)dataTypeMold;
                        typeOptionManager.createTypeOptionControl(builtinDataTypeMold.getSupportedAdapterClasses());
                    } else {
                        typeOptionManager.clearTypeOptionControl();
                    }
                }
            });
            this.chkIsNotNull.addSelectionListener((SelectionListener)this.editListener);
            this.txtCheckName.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtCheckName));
            this.txtCheckName.addKeyListener((KeyListener)this.editListener);
            this.txtCheckExpression.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtCheckExpression));
            this.txtCheckExpression.addKeyListener((KeyListener)this.editListener);
            this.txtDescription.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtDescription));
            this.txtDescription.addKeyListener((KeyListener)this.editListener);
        }

        protected void configureTableViewer(TableViewer tableViewer) {
            tableViewer.setLabelProvider((IBaseLabelProvider)new DomainLabelProvider());
            final DomainContentProvider contentProvider = new DomainContentProvider();
            tableViewer.setContentProvider((IContentProvider)contentProvider);
            tableViewer.setInput(this.domains);
            final EventBroker eventBroker = this.jiemamy.getEventBroker();
            eventBroker.addListener((CommandListener)contentProvider);
            tableViewer.getTable().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    eventBroker.removeListener((CommandListener)contentProvider);
                }
            });
            ExtensionResolver dialectResolver = JiemamyCorePlugin.getDialectResolver();
            IConfigurationElement dialectElement = (IConfigurationElement)dialectResolver.getExtensionConfigurationElements().get(RootEditDialogDomainTab.this.rootModel.getDialectClassName());
            Object[] children = dialectElement.getChildren("typeOptionHandler");
            if (!ArrayUtils.isEmpty((Object[])children)) {
                try {
                    this.typeOptionHandler = (TypeOptionHandler)children[0].createExecutableExtension("class");
                }
                catch (Exception e) {
                    ExceptionHandler.handleException(e);
                }
            }
            this.typeOptionManagers.clear();
            for (DomainModel domainModel : this.domains) {
                TypeOptionManager typeOptionManager = new TypeOptionManager((DataTypeHolder<? extends DataType>)domainModel, this.cmpTypeOption, this.editListener, this.typeOptionHandler);
                this.typeOptionManagers.put(domainModel, typeOptionManager);
            }
        }

        protected void createEditorControls(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout(4, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            Label label = new Label(composite, 0);
            label.setText(Messages.Label_Domain_Name);
            this.txtDomainName = new Text(composite, 2048);
            this.txtDomainName.setLayoutData((Object)new GridData(768));
            label = new Label(composite, 0);
            label.setText(Messages.Label_Domain_Description);
            this.txtDescription = new Text(composite, 2050);
            this.txtDescription.setLayoutData((Object)new GridData(1808));
            label = new Label(composite, 0);
            label.setText(Messages.Label_Domain_DataType);
            Composite cmpTypes = new Composite(composite, 0);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 3;
            cmpTypes.setLayoutData((Object)gd);
            layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cmpTypes.setLayout((Layout)layout);
            this.cmbDataType = new Combo(cmpTypes, 8);
            this.cmbDataType.setVisibleItemCount(20);
            this.cmpTypeOption = new Composite(cmpTypes, 0);
            this.cmpTypeOption.setLayout((Layout)new RowLayout());
            gd = new GridData();
            gd.heightHint = 25;
            gd.widthHint = 400;
            this.cmpTypeOption.setLayoutData((Object)gd);
            label = new Label(composite, 0);
            label.setText("\u5236\u7d04\u540d");
            this.txtCheckName = new Text(composite, 2048);
            this.txtCheckName.setLayoutData((Object)new GridData(768));
            label = new Label(composite, 0);
            label.setText(Messages.Label_Domain_CheckConstraint);
            this.txtCheckExpression = new Text(composite, 2048);
            this.txtCheckExpression.setLayoutData((Object)new GridData(768));
            Composite cmpChecks = new Composite(parent, 0);
            cmpChecks.setLayoutData((Object)new GridData(768));
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cmpChecks.setLayout((Layout)layout);
            this.chkIsNotNull = new Button(cmpChecks, 32);
            this.chkIsNotNull.setText(Messages.Label_Domain_NotNullConstraint);
        }

        protected void createTableColumns(Table table) {
            TableColumn colName = new TableColumn(table, 16384);
            colName.setText(Messages.Column_Domain_Name);
            colName.setWidth(100);
            TableColumn colType = new TableColumn(table, 16384);
            colType.setText(Messages.Column_Domain_DataType);
            colType.setWidth(150);
            TableColumn colNotNull = new TableColumn(table, 16384);
            colNotNull.setText(Messages.Column_Domain_NotNullConstraint);
            colNotNull.setWidth(80);
            TableColumn colCheck = new TableColumn(table, 16384);
            colCheck.setText(Messages.Column_Domain_CheckConstraint);
            colCheck.setWidth(80);
        }

        protected void disableEditorControls() {
            this.txtDomainName.setText("");
            this.cmbDataType.setText("");
            this.txtCheckName.setText("");
            this.txtCheckExpression.setText("");
            this.txtDescription.setText("");
            this.chkIsNotNull.setSelection(false);
            this.txtDomainName.setEnabled(false);
            this.cmbDataType.setEnabled(false);
            this.txtCheckName.setEnabled(false);
            this.txtCheckExpression.setEnabled(false);
            this.txtDescription.setEnabled(false);
            this.chkIsNotNull.setEnabled(false);
            Control[] controlArray = this.cmpTypeOption.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
        }

        protected void enableEditorControls(int index) {
            DomainModel domainModel = this.domains.get(index);
            this.txtDomainName.setEnabled(true);
            this.cmbDataType.setEnabled(true);
            this.txtDescription.setEnabled(true);
            this.chkIsNotNull.setEnabled(true);
            this.txtCheckName.setEnabled(true);
            this.txtCheckExpression.setEnabled(true);
            BuiltinDataType dataType = (BuiltinDataType)domainModel.getDataType();
            List adapters = dataType.getAdapters();
            ArrayList adapterClasses = CollectionsUtil.newArrayList();
            for (Object adapter : adapters) {
                adapterClasses.add(adapter.getClass());
            }
            this.typeOptionManagers.get(domainModel).createTypeOptionControl(adapterClasses);
            this.txtDomainName.setText(domainModel.getName());
            this.cmbDataType.setText(DataTypeUtil.getTypeName((DataType)dataType, (ReferenceResolver)this.jiemamy.getReferenceResolver()));
            this.txtDescription.setText(JiemamyPropertyUtil.careNull((String)domainModel.getDescription()));
            this.chkIsNotNull.setSelection(domainModel.getNotNullConstraint() != null);
            ColumnCheckConstraint checkConstraint = domainModel.getCheckConstraint();
            if (checkConstraint == null) {
                this.txtCheckName.setText("");
                this.txtCheckExpression.setText("");
            } else {
                this.txtCheckName.setText(JiemamyPropertyUtil.careNull((String)checkConstraint.getName()));
                this.txtCheckExpression.setText(checkConstraint.getExpression());
            }
            this.cmbDataType.setText(dataType.getTypeName());
            if (dataType.hasAdapter(SizedDataTypeAdapter.class)) {
                this.typeOptionManagers.get(domainModel).setValue(SizedDataTypeAdapter.class);
            }
            if (dataType.hasAdapter(PrecisionedDataTypeAdapter.class)) {
                this.typeOptionManagers.get(domainModel).setValue(PrecisionedDataTypeAdapter.class);
            }
            if (dataType.hasAdapter(TimezonedDataTypeAdapter.class)) {
                this.typeOptionManagers.get(domainModel).setValue(TimezonedDataTypeAdapter.class);
            }
        }

        protected JiemamyElement performAddItem() {
            Table table = this.getTableViewer().getTable();
            JiemamyFactory factory = this.jiemamy.getFactory();
            DomainModel domainModel = (DomainModel)factory.newModel(DomainModel.class);
            String newName = "DOMAIN_" + (this.domains.size() + 1);
            RootEditDialogDomainTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)domainModel, (JiemamyProperty)JiemamyProperty.DomainProperty.name, (Object)newName);
            BuiltinDataType builtinDataType = (BuiltinDataType)factory.newDataType((DataTypeMold)RootEditDialogDomainTab.this.allTypes.get(0));
            RootEditDialogDomainTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)domainModel, (JiemamyProperty)JiemamyProperty.DomainProperty.dataType, (Object)builtinDataType);
            RootEditDialogDomainTab.this.jiemamyFacade.addDomain(domainModel);
            TypeOptionManager typeOptionManager = new TypeOptionManager((DataTypeHolder<? extends DataType>)domainModel, this.cmpTypeOption, this.editListener, this.typeOptionHandler);
            this.typeOptionManagers.put(domainModel, typeOptionManager);
            int addedIndex = this.domains.indexOf(domainModel);
            table.setSelection(addedIndex);
            this.enableEditControls(addedIndex);
            this.txtDomainName.setFocus();
            return domainModel;
        }

        protected JiemamyElement performInsertItem() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            JiemamyFactory factory = this.jiemamy.getFactory();
            DomainModel domainModel = (DomainModel)factory.newModel(DomainModel.class);
            String newName = "DOMAIN_" + (this.domains.size() + 1);
            RootEditDialogDomainTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)domainModel, (JiemamyProperty)JiemamyProperty.DomainProperty.name, (Object)newName);
            BuiltinDataType builtinDataType = (BuiltinDataType)factory.newDataType((DataTypeMold)RootEditDialogDomainTab.this.allTypes.get(0));
            RootEditDialogDomainTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)domainModel, (JiemamyProperty)JiemamyProperty.DomainProperty.dataType, (Object)builtinDataType);
            if (index < 0 || index > table.getItemCount()) {
                RootEditDialogDomainTab.this.jiemamyFacade.addDomain(domainModel);
            } else {
                RootEditDialogDomainTab.this.jiemamyFacade.addDomain(domainModel, index);
            }
            TypeOptionManager typeOptionManager = new TypeOptionManager((DataTypeHolder<? extends DataType>)domainModel, this.cmpTypeOption, this.editListener, this.typeOptionHandler);
            this.typeOptionManagers.put(domainModel, typeOptionManager);
            int addedIndex = this.domains.indexOf(domainModel);
            table.setSelection(addedIndex);
            this.enableEditControls(addedIndex);
            this.txtDomainName.setFocus();
            return domainModel;
        }

        protected void performMoveDownItem() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            if (index < 0 || index >= table.getItemCount()) {
                return;
            }
            RootEditDialogDomainTab.this.jiemamyFacade.swapListElement((JiemamyElement)RootEditDialogDomainTab.this.rootModel, this.domains, index, index + 1);
            table.setSelection(index + 1);
            this.enableEditControls(index + 1);
        }

        protected void performMoveUpItem() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            if (index <= 0 || index > table.getItemCount()) {
                return;
            }
            RootEditDialogDomainTab.this.jiemamyFacade.swapListElement((JiemamyElement)RootEditDialogDomainTab.this.rootModel, this.domains, index, index - 1);
            table.setSelection(index - 1);
            this.enableEditControls(index - 1);
        }

        protected JiemamyElement performRemoveItem() {
            int nextSelection;
            TableViewer tableViewer = this.getTableViewer();
            Table table = tableViewer.getTable();
            int index = table.getSelectionIndex();
            if (index < 0 || index > table.getItemCount()) {
                return null;
            }
            DomainModel domainModel = this.domains.get(index);
            RootEditDialogDomainTab.this.jiemamyFacade.removeDomain(domainModel);
            tableViewer.remove((Object)domainModel);
            int n = nextSelection = table.getItemCount() > index ? index : index - 1;
            if (nextSelection >= 0) {
                table.setSelection(nextSelection);
                this.enableEditorControls(nextSelection);
            } else {
                this.disableEditorControls();
            }
            table.setFocus();
            this.typeOptionManagers.remove(domainModel);
            return domainModel;
        }

        private void updateModel() {
            int domainEditIndex = this.getTableViewer().getTable().getSelectionIndex();
            int selectionInedx = this.cmbDataType.getSelectionIndex();
            if (domainEditIndex == -1 || selectionInedx == -1) {
                return;
            }
            DomainModel domainModel = this.domains.get(domainEditIndex);
            JiemamyFactory factory = domainModel.getJiemamy().getFactory();
            String domainName = JiemamyPropertyUtil.careNull((String)this.txtDomainName.getText(), (boolean)false);
            RootEditDialogDomainTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)domainModel, (JiemamyProperty)JiemamyProperty.DomainProperty.name, (Object)domainName);
            String description = JiemamyPropertyUtil.careNull((String)this.txtDescription.getText(), (boolean)true);
            RootEditDialogDomainTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)domainModel, (JiemamyProperty)JiemamyProperty.DomainProperty.description, (Object)description);
            DataType dataType = factory.newDataType((DataTypeMold)RootEditDialogDomainTab.this.allTypes.get(this.cmbDataType.getSelectionIndex()));
            RootEditDialogDomainTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)domainModel, (JiemamyProperty)JiemamyProperty.DomainProperty.dataType, (Object)dataType);
            if (StringUtils.isEmpty((String)this.txtCheckName.getText()) && StringUtils.isEmpty((String)this.txtCheckExpression.getText())) {
                RootEditDialogDomainTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)domainModel, (JiemamyProperty)JiemamyProperty.DomainProperty.checkConstraint, null);
            } else {
                ColumnCheckConstraint checkConstraint = domainModel.getCheckConstraint();
                if (checkConstraint == null) {
                    checkConstraint = (ColumnCheckConstraint)factory.newModel(ColumnCheckConstraint.class);
                    RootEditDialogDomainTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)domainModel, (JiemamyProperty)JiemamyProperty.DomainProperty.checkConstraint, (Object)checkConstraint);
                }
                String checkName = JiemamyPropertyUtil.careNull((String)this.txtCheckName.getText(), (boolean)true);
                RootEditDialogDomainTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)checkConstraint, (JiemamyProperty)JiemamyProperty.ConstraintProperty.name, (Object)checkName);
                String expression = JiemamyPropertyUtil.careNull((String)this.txtCheckExpression.getText(), (boolean)false);
                RootEditDialogDomainTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)checkConstraint, (JiemamyProperty)JiemamyProperty.CheckConstraintProperty.expression, (Object)expression);
            }
            if (!this.chkIsNotNull.getSelection()) {
                RootEditDialogDomainTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)domainModel, (JiemamyProperty)JiemamyProperty.DomainProperty.notNullConstraint, null);
            } else if (domainModel.getNotNullConstraint() == null) {
                NotNullConstraint nnConstraint = (NotNullConstraint)factory.newModel(NotNullConstraint.class);
                RootEditDialogDomainTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)domainModel, (JiemamyProperty)JiemamyProperty.DomainProperty.notNullConstraint, (Object)nnConstraint);
            }
            this.typeOptionManagers.get(domainModel).writeBackToAdapter();
        }

        private class EditListenerImpl
        extends AbstractEditListener {
            private EditListenerImpl() {
            }

            protected void process(TypedEvent e) {
                DomainTableEditor.this.updateModel();
                RootEditDialogDomainTab.this.domainTableEditor.refreshTable();
            }
        }
    }
}

