/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.dialog.root;

import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.jiemamy.EventBroker;
import org.jiemamy.Jiemamy;
import org.jiemamy.JiemamyFactory;
import org.jiemamy.JiemamyProperty;
import org.jiemamy.eclipse.editor.dialog.AbstractEditListener;
import org.jiemamy.eclipse.editor.dialog.EditListener;
import org.jiemamy.eclipse.editor.dialog.root.DataSetEditDialog;
import org.jiemamy.eclipse.ui.AbstractTableEditor;
import org.jiemamy.eclipse.ui.DefaultTableEditorConfig;
import org.jiemamy.eclipse.ui.helper.TextSelectionAdapter;
import org.jiemamy.eclipse.ui.tab.AbstractTab;
import org.jiemamy.editcommand.Command;
import org.jiemamy.editcommand.CommandListener;
import org.jiemamy.facade.JiemamyFacade;
import org.jiemamy.facade.SavePoint;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.dataset.DataSetModel;
import org.jiemamy.utils.LogMarker;
import org.jiemamy.utils.model.JiemamyPropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class RootEditDialogDataSetTab
extends AbstractTab {
    private static Logger logger = LoggerFactory.getLogger(RootEditDialogDataSetTab.class);
    private final RootModel rootModel;
    private AbstractTableEditor dataSetTableEditor;
    private final JiemamyFacade jiemamyFacade;

    public RootEditDialogDataSetTab(TabFolder parentTabFolder, int style, RootModel rootModel, JiemamyFacade jiemamyFacade) {
        super(parentTabFolder, style, "\u30c7\u30fc\u30bf\u30bb\u30c3\u30c8(&T)");
        this.rootModel = rootModel;
        this.jiemamyFacade = jiemamyFacade;
        Composite composite = new Composite((Composite)parentTabFolder, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.dataSetTableEditor = new DataSetTableEditor(composite, 0);
        this.dataSetTableEditor.configure();
        this.dataSetTableEditor.disableEditControls();
        this.getTabItem().setControl((Control)composite);
    }

    public boolean isTabComplete() {
        return true;
    }

    private class DataSetContentProvider
    extends ArrayContentProvider
    implements CommandListener {
        private Viewer viewer;

        private DataSetContentProvider() {
        }

        public void commandExecuted(Command command) {
            logger.debug((Marker)LogMarker.LIFECYCLE, "DataSetContentProvider: commandExecuted");
            RootEditDialogDataSetTab.this.dataSetTableEditor.refreshTable();
        }

        public void dispose() {
            logger.debug((Marker)LogMarker.LIFECYCLE, "DataSetContentProvider: disposed");
            super.dispose();
        }

        public JiemamyElement getTargetModel() {
            return (JiemamyElement)this.viewer.getInput();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            logger.debug((Marker)LogMarker.LIFECYCLE, "DataSetContentProvider: input changed");
            logger.trace((Marker)LogMarker.LIFECYCLE, "oldInput: " + oldInput);
            logger.trace((Marker)LogMarker.LIFECYCLE, "newInput: " + newInput);
            this.viewer = viewer;
            super.inputChanged(viewer, oldInput, newInput);
        }
    }

    private class DataSetLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private DataSetLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            DataSetModel dataSet = (DataSetModel)element;
            switch (columnIndex) {
                case 0: {
                    return dataSet.getName();
                }
            }
            return "";
        }
    }

    private class DataSetTableEditor
    extends AbstractTableEditor {
        private static final int COL_WIDTH_NAME = 200;
        private final EditListener editListener;
        private final Jiemamy jiemamy;
        private Text txtDataSetName;
        private Button btnEdit;
        private final List<DataSetModel> dataSets;

        public DataSetTableEditor(Composite parent, int style) {
            super(parent, style, new DefaultTableEditorConfig("\u30c7\u30fc\u30bf\u30bb\u30c3\u30c8\u60c5\u5831"));
            this.editListener = new EditListenerImpl();
            this.jiemamy = RootEditDialogDataSetTab.this.rootModel.getJiemamy();
            this.dataSets = RootEditDialogDataSetTab.this.rootModel.getDataSets();
            assert (this.jiemamy != null);
            assert (this.dataSets != null);
        }

        protected void configureEditorControls() {
            super.configureEditorControls();
            this.txtDataSetName.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtDataSetName));
            this.txtDataSetName.addKeyListener((KeyListener)this.editListener);
            this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    logger.info("edit data set");
                    int selectionIndex = RootEditDialogDataSetTab.this.dataSetTableEditor.getTableViewer().getTable().getSelectionIndex();
                    DataSetModel dataSetModel = (DataSetModel)RootEditDialogDataSetTab.this.rootModel.getDataSets().get(selectionIndex);
                    DataSetEditDialog dataSetEditDialog = new DataSetEditDialog(DataSetTableEditor.this.getShell(), dataSetModel, RootEditDialogDataSetTab.this.jiemamyFacade);
                    SavePoint save = RootEditDialogDataSetTab.this.jiemamyFacade.save();
                    if (dataSetEditDialog.open() != 0) {
                        RootEditDialogDataSetTab.this.jiemamyFacade.rollback(save);
                    }
                }
            });
        }

        protected void configureTableViewer(TableViewer tableViewer) {
            tableViewer.setLabelProvider((IBaseLabelProvider)new DataSetLabelProvider());
            final DataSetContentProvider contentProvider = new DataSetContentProvider();
            tableViewer.setContentProvider((IContentProvider)contentProvider);
            tableViewer.setInput(this.dataSets);
            final EventBroker eventBroker = this.jiemamy.getEventBroker();
            eventBroker.addListener((CommandListener)contentProvider);
            tableViewer.getTable().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    eventBroker.removeListener((CommandListener)contentProvider);
                }
            });
        }

        protected void createEditorControls(Composite parent) {
            Composite cmpNames = new Composite(parent, 0);
            cmpNames.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cmpNames.setLayout((Layout)layout);
            Label label = new Label(cmpNames, 0);
            label.setText("\u30c7\u30fc\u30bf\u30bb\u30c3\u30c8\u540d");
            this.txtDataSetName = new Text(cmpNames, 2048);
            this.txtDataSetName.setLayoutData((Object)new GridData(768));
            this.btnEdit = new Button(cmpNames, 8);
            this.btnEdit.setText("\u7de8\u96c6");
        }

        protected void createTableColumns(Table table) {
            TableColumn colName = new TableColumn(table, 16384);
            colName.setText("\u30c7\u30fc\u30bf\u30bb\u30c3\u30c8\u540d");
            colName.setWidth(200);
        }

        protected void disableEditorControls() {
            this.txtDataSetName.setText("");
            this.txtDataSetName.setEnabled(false);
            this.btnEdit.setEnabled(false);
        }

        protected void enableEditorControls(int index) {
            DataSetModel dataSet = this.dataSets.get(index);
            this.txtDataSetName.setEnabled(true);
            this.btnEdit.setEnabled(true);
            this.txtDataSetName.setText(JiemamyPropertyUtil.careNull((String)dataSet.getName()));
        }

        protected JiemamyElement performAddItem() {
            Table table = this.getTableViewer().getTable();
            JiemamyFactory factory = this.jiemamy.getFactory();
            DataSetModel dataSetModel = (DataSetModel)factory.newModel(DataSetModel.class);
            String newName = "DATASET_" + (this.dataSets.size() + 1);
            RootEditDialogDataSetTab.this.jiemamyFacade.changeModelProperty((JiemamyElement)dataSetModel, (JiemamyProperty)JiemamyProperty.DataSetProperty.name, (Object)newName);
            RootEditDialogDataSetTab.this.jiemamyFacade.addDataSet(dataSetModel);
            int addedIndex = this.dataSets.indexOf(dataSetModel);
            table.setSelection(addedIndex);
            this.enableEditControls(addedIndex);
            this.txtDataSetName.setFocus();
            return dataSetModel;
        }

        protected JiemamyElement performInsertItem() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            JiemamyFactory factory = this.jiemamy.getFactory();
            DataSetModel dataSetModel = (DataSetModel)factory.newModel(DataSetModel.class);
            if (index < 0 || index > table.getItemCount()) {
                RootEditDialogDataSetTab.this.jiemamyFacade.addDataSet(dataSetModel);
            } else {
                RootEditDialogDataSetTab.this.jiemamyFacade.addDataSet(dataSetModel, index);
            }
            int addedIndex = this.dataSets.indexOf(dataSetModel);
            table.setSelection(addedIndex);
            this.enableEditControls(addedIndex);
            this.txtDataSetName.setFocus();
            return dataSetModel;
        }

        protected void performMoveDownItem() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            if (index < 0 || index >= table.getItemCount()) {
                return;
            }
            RootEditDialogDataSetTab.this.jiemamyFacade.swapListElement((JiemamyElement)RootEditDialogDataSetTab.this.rootModel, this.dataSets, index, index + 1);
            table.setSelection(index + 1);
            this.enableEditControls(index + 1);
        }

        protected void performMoveUpItem() {
            Table table = this.getTableViewer().getTable();
            int index = table.getSelectionIndex();
            if (index <= 0 || index > table.getItemCount()) {
                return;
            }
            RootEditDialogDataSetTab.this.jiemamyFacade.swapListElement((JiemamyElement)RootEditDialogDataSetTab.this.rootModel, this.dataSets, index, index - 1);
            table.setSelection(index - 1);
            this.enableEditControls(index - 1);
        }

        protected JiemamyElement performRemoveItem() {
            int nextSelection;
            TableViewer tableViewer = this.getTableViewer();
            Table table = tableViewer.getTable();
            int index = table.getSelectionIndex();
            if (index < 0 || index > table.getItemCount()) {
                return null;
            }
            DataSetModel dataSetModel = this.dataSets.get(index);
            RootEditDialogDataSetTab.this.jiemamyFacade.removeDataSet(dataSetModel);
            tableViewer.remove((Object)dataSetModel);
            int n = nextSelection = table.getItemCount() > index ? index : index - 1;
            if (nextSelection >= 0) {
                table.setSelection(nextSelection);
                this.enableEditorControls(nextSelection);
            } else {
                this.disableEditorControls();
            }
            table.setFocus();
            return dataSetModel;
        }

        private void updateModel() {
            int editIndex = this.getTableViewer().getTable().getSelectionIndex();
            if (editIndex == -1) {
                return;
            }
            DataSetModel dataSetModel = this.dataSets.get(editIndex);
            dataSetModel.setName(JiemamyPropertyUtil.careNull((String)this.txtDataSetName.getText(), (boolean)true));
        }

        private class EditListenerImpl
        extends AbstractEditListener {
            private EditListenerImpl() {
            }

            protected void process(TypedEvent e) {
                DataSetTableEditor.this.updateModel();
                RootEditDialogDataSetTab.this.dataSetTableEditor.refreshTable();
            }
        }
    }
}

