/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.dialog.root;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;
import org.jiemamy.JiemamyProperty;
import org.jiemamy.dialect.Dialect;
import org.jiemamy.eclipse.JiemamyCorePlugin;
import org.jiemamy.eclipse.editor.dialog.root.Messages;
import org.jiemamy.eclipse.editor.dialog.root.RootEditDialogDataSetTab;
import org.jiemamy.eclipse.editor.dialog.root.RootEditDialogDomainTab;
import org.jiemamy.eclipse.ui.JiemamyEditDialog;
import org.jiemamy.eclipse.ui.helper.TextSelectionAdapter;
import org.jiemamy.eclipse.ui.tab.TextEditTab;
import org.jiemamy.facade.JiemamyFacade;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.RootModel;
import org.jiemamy.utils.model.JiemamyPropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootEditDialog
extends JiemamyEditDialog<RootModel> {
    private static final Point DEFAULT_SIZE = new Point(647, 400);
    private static Logger logger = LoggerFactory.getLogger(RootEditDialog.class);
    private final List<Dialect> dialects;
    private Text txtSchema;
    private Combo cmbDialect;
    private TextEditTab tabBeginScript;
    private TextEditTab tabEndScript;
    private TextEditTab tabDescription;
    private final JiemamyFacade jiemamyFacade;

    public RootEditDialog(Shell shell, RootModel rootModel, JiemamyFacade jiemamyFacade) {
        super(shell, rootModel, RootModel.class);
        Validate.notNull((Object)rootModel);
        Validate.notNull((Object)jiemamyFacade);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.jiemamyFacade = jiemamyFacade;
        this.dialects = JiemamyCorePlugin.getDialectResolver().getAllInstance();
    }

    @Override
    protected boolean canExecuteOk() {
        return super.canExecuteOk() && !StringUtils.isEmpty((String)this.cmbDialect.getText());
    }

    protected Control createDialogArea(Composite parent) {
        RootModel rootModel = (RootModel)this.getTargetModel();
        this.getShell().setText(Messages.Dialog_Title);
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.Label_SchemaName);
        this.txtSchema = new Text(composite, 2048);
        this.txtSchema.setLayoutData((Object)new GridData(768));
        this.txtSchema.setText(JiemamyPropertyUtil.careNull((String)rootModel.getSchemaName()));
        this.txtSchema.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtSchema));
        label = new Label(composite, 0);
        label.setText(Messages.Label_RDBMS);
        this.cmbDialect = new Combo(composite, 2056);
        this.cmbDialect.setLayoutData((Object)new GridData(768));
        for (Dialect dialect : this.dialects) {
            this.cmbDialect.add(dialect.getName());
            logger.debug("installed Dialect: " + dialect.toString());
        }
        try {
            this.cmbDialect.setText(rootModel.findDialect().getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.cmbDialect.setText(this.dialects.get(0).getName());
        }
        this.cmbDialect.setVisibleItemCount(20);
        TabFolder tabFolder = new TabFolder(composite, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 4;
        tabFolder.setLayoutData((Object)gd);
        RootEditDialogDomainTab tabDomains = new RootEditDialogDomainTab(tabFolder, 0, rootModel, this.jiemamyFacade);
        this.addTab(tabDomains);
        RootEditDialogDataSetTab tabDataSets = new RootEditDialogDataSetTab(tabFolder, 0, rootModel, this.jiemamyFacade);
        this.addTab(tabDataSets);
        String beginScript = JiemamyPropertyUtil.careNull((String)rootModel.getBeginScript());
        this.tabBeginScript = new TextEditTab(tabFolder, Messages.Tab_BeginScript, beginScript);
        this.addTab(this.tabBeginScript);
        String endScript = JiemamyPropertyUtil.careNull((String)rootModel.getEndScript());
        this.tabEndScript = new TextEditTab(tabFolder, Messages.Tab_EndScript, endScript);
        this.addTab(this.tabEndScript);
        String description = JiemamyPropertyUtil.careNull((String)rootModel.getDescription());
        this.tabDescription = new TextEditTab(tabFolder, Messages.Tab_Description, description);
        this.addTab(this.tabDescription);
        this.createAdditionalTabs(tabFolder);
        return composite;
    }

    @Override
    protected Point getDefaultSize() {
        return DEFAULT_SIZE;
    }

    @Override
    protected boolean performOk() {
        RootModel rootModel = (RootModel)this.getTargetModel();
        int selectionIndex = this.cmbDialect.getSelectionIndex();
        String dialectClassName = this.dialects.get(selectionIndex).toString();
        this.jiemamyFacade.changeModelProperty((JiemamyElement)rootModel, (JiemamyProperty)JiemamyProperty.RootProperty.dialectClassName, (Object)dialectClassName);
        String schemaName = JiemamyPropertyUtil.careNull((String)this.txtSchema.getText(), (boolean)true);
        this.jiemamyFacade.changeModelProperty((JiemamyElement)rootModel, (JiemamyProperty)JiemamyProperty.RootProperty.schemaName, (Object)schemaName);
        String beginScript = JiemamyPropertyUtil.careNull((String)this.tabBeginScript.getTextWidget().getText(), (boolean)true);
        this.jiemamyFacade.changeModelProperty((JiemamyElement)rootModel, (JiemamyProperty)JiemamyProperty.RootProperty.beginScript, (Object)beginScript);
        String endScript = JiemamyPropertyUtil.careNull((String)this.tabEndScript.getTextWidget().getText(), (boolean)true);
        this.jiemamyFacade.changeModelProperty((JiemamyElement)rootModel, (JiemamyProperty)JiemamyProperty.RootProperty.endScript, (Object)endScript);
        String description = JiemamyPropertyUtil.careNull((String)this.tabDescription.getTextWidget().getText(), (boolean)true);
        this.jiemamyFacade.changeModelProperty((JiemamyElement)rootModel, (JiemamyProperty)JiemamyProperty.RootProperty.description, (Object)description);
        return true;
    }
}

