/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.dialog.root;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jiemamy.JiemamyFactory;
import org.jiemamy.eclipse.ui.tab.AbstractTab;
import org.jiemamy.facade.JiemamyFacade;
import org.jiemamy.model.attribute.ColumnModel;
import org.jiemamy.model.attribute.ColumnRef;
import org.jiemamy.model.dataset.DataSetModel;
import org.jiemamy.model.dataset.RecordModel;
import org.jiemamy.model.entity.TableModel;
import org.jiemamy.utils.CollectionsUtil;
import org.jiemamy.utils.LogMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetEditDialogTableTab
extends AbstractTab {
    private static final int COL_WIDTH = 100;
    private static Logger logger = LoggerFactory.getLogger(DataSetEditDialogTableTab.class);
    private final JiemamyFacade jiemamyFacade;
    public static final int RECORD_CHANGED = 123;

    public DataSetEditDialogTableTab(TabFolder parentTabFolder, int style, DataSetModel dataSetModel, TableModel tableModel, JiemamyFacade jiemamyFacade) {
        super(parentTabFolder, style, tableModel.getName());
        this.getTabItem().setData((Object)tableModel);
        this.jiemamyFacade = jiemamyFacade;
        final JiemamyFactory factory = dataSetModel.getJiemamy().getFactory();
        Composite composite = new Composite((Composite)parentTabFolder, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        final Table table = new Table(composite, 2050);
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setData((Object)tableModel);
        List columns = tableModel.findColumns();
        for (ColumnModel columnModel : columns) {
            TableColumn column = new TableColumn(table, 0);
            column.setWidth(100);
            column.setText(columnModel.getName());
            column.setData((Object)columnModel);
        }
        final List records = (List)dataSetModel.getRecords().get(factory.newReference(tableModel));
        this.refreshTable(factory, table, records);
        TableEditor editor = new TableEditor(table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        table.addListener(3, (Listener)new StartEditListener(editor, table));
        this.getTabItem().setControl((Control)composite);
        this.getTabItem().addListener(123, new Listener(){

            public void handleEvent(Event event) {
                DataSetEditDialogTableTab.this.refreshTable(factory, table, records);
            }
        });
    }

    @Override
    public boolean isTabComplete() {
        return true;
    }

    private void refreshTable(JiemamyFactory factory, Table table, List<RecordModel> records) {
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            item.dispose();
            ++n2;
        }
        for (RecordModel recordModel : records) {
            ArrayList data = CollectionsUtil.newArrayList();
            TableColumn[] tableColumnArray = table.getColumns();
            int n3 = tableColumnArray.length;
            int n4 = 0;
            while (n4 < n3) {
                TableColumn tableColumn = tableColumnArray[n4];
                ColumnModel columnModel = (ColumnModel)tableColumn.getData();
                ColumnRef columnRef = factory.newReference(columnModel);
                String string = (String)recordModel.getValues().get(columnRef);
                data.add(string);
                ++n4;
            }
            TableItem item = new TableItem(table, 0);
            item.setText(data.toArray(new String[data.size()]));
            item.setData((Object)recordModel);
        }
    }

    private final class StartEditListener
    implements Listener {
        private final TableEditor editor;
        private final Table table;

        private StartEditListener(TableEditor editor, Table table) {
            this.editor = editor;
            this.table = table;
        }

        public void handleEvent(Event event) {
            logger.debug((Marker)LogMarker.LIFECYCLE, "mouse down");
            Rectangle clientArea = this.table.getClientArea();
            Point pt = new Point(event.x, event.y);
            int index = this.table.getTopIndex();
            while (index < this.table.getItemCount()) {
                boolean visible = false;
                TableItem item = this.table.getItem(index);
                int i = 0;
                while (i < this.table.getColumnCount()) {
                    Rectangle rect = item.getBounds(i);
                    if (rect.contains(pt)) {
                        int columnIndex = i;
                        Text text = new Text((Composite)this.table, 0);
                        FinishEditListener textListener = new FinishEditListener(text, item, columnIndex);
                        text.addListener(16, (Listener)textListener);
                        text.addListener(31, (Listener)textListener);
                        this.editor.setEditor((Control)text, item, i);
                        text.setText(item.getText(i));
                        text.selectAll();
                        text.setFocus();
                        return;
                    }
                    if (!visible && rect.intersects(clientArea)) {
                        visible = true;
                    }
                    ++i;
                }
                if (!visible) {
                    return;
                }
                ++index;
            }
        }

        private final class FinishEditListener
        implements Listener {
            private final Text text;
            private final TableItem item;
            private final int columnIndex;

            private FinishEditListener(Text text, TableItem item, int columnIndex) {
                this.text = text;
                this.item = item;
                this.columnIndex = columnIndex;
            }

            public void handleEvent(Event e) {
                if (e.type == 16) {
                    logger.debug((Marker)LogMarker.LIFECYCLE, "focus out");
                    this.item.setText(this.columnIndex, this.text.getText());
                    RecordModel recordModel = (RecordModel)this.item.getData();
                    ColumnModel columnModel = (ColumnModel)StartEditListener.this.table.getColumn(this.columnIndex).getData();
                    DataSetEditDialogTableTab.this.jiemamyFacade.setRecordValue(recordModel, columnModel, this.text.getText());
                    this.text.dispose();
                } else if (e.type == 31) {
                    if (e.detail == 4) {
                        logger.debug((Marker)LogMarker.LIFECYCLE, "traverse return");
                        this.item.setText(this.columnIndex, this.text.getText());
                        RecordModel recordModel = (RecordModel)this.item.getData();
                        ColumnModel columnModel = (ColumnModel)StartEditListener.this.table.getColumn(this.columnIndex).getData();
                        DataSetEditDialogTableTab.this.jiemamyFacade.setRecordValue(recordModel, columnModel, this.text.getText());
                    }
                    if (e.detail == 4 || e.detail == 2) {
                        logger.debug((Marker)LogMarker.LIFECYCLE, "traverse escape (or return fall through)");
                        this.text.dispose();
                        e.doit = false;
                    }
                }
            }
        }
    }
}

