/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.dialog.root;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections15.IteratorUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.jiemamy.JiemamyFactory;
import org.jiemamy.ReferenceResolver;
import org.jiemamy.eclipse.CommonMessages;
import org.jiemamy.eclipse.editor.dialog.root.DataSetEditDialogTableTab;
import org.jiemamy.eclipse.editor.dialog.root.Messages;
import org.jiemamy.eclipse.editor.dialog.root.TableSelectDialog;
import org.jiemamy.eclipse.ui.JiemamyEditDialog;
import org.jiemamy.eclipse.utils.ExceptionHandler;
import org.jiemamy.facade.JiemamyFacade;
import org.jiemamy.model.ElementReference;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.dataset.DataSetModel;
import org.jiemamy.model.entity.TableModel;
import org.jiemamy.model.entity.TableRef;
import org.jiemamy.utils.model.DataSetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetEditDialog
extends JiemamyEditDialog<DataSetModel> {
    private static final Point DEFAULT_SIZE = new Point(647, 400);
    private static Logger logger = LoggerFactory.getLogger(DataSetEditDialog.class);
    private Button btnImport;
    private Button btnExport;
    private TabFolder tabFolder;
    private final JiemamyFacade jiemamyFacade;
    private String filename;

    public DataSetEditDialog(Shell shell, DataSetModel dataSetModel, JiemamyFacade jiemamyFacade) {
        super(shell, dataSetModel, DataSetModel.class);
        Validate.notNull((Object)dataSetModel);
        Validate.notNull((Object)jiemamyFacade);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.jiemamyFacade = jiemamyFacade;
    }

    protected Control createDialogArea(Composite parent) {
        DataSetModel dataSetModel = (DataSetModel)this.getTargetModel();
        this.getShell().setText(Messages.DataSetEditDialog_title);
        ReferenceResolver referenceResolver = dataSetModel.getJiemamy().getReferenceResolver();
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.tabFolder = new TabFolder(composite, 0);
        GridData gd = new GridData(1808);
        this.tabFolder.setLayoutData((Object)gd);
        Menu menu = new Menu((Control)this.tabFolder);
        this.tabFolder.setMenu(menu);
        menu.addMenuListener((MenuListener)new TabMenuListener(dataSetModel, menu));
        Set tableRefs = dataSetModel.getRecords().keySet();
        for (TableRef tableRef : tableRefs) {
            TableModel tableModel = (TableModel)referenceResolver.resolve((ElementReference)tableRef);
            if (tableModel == null) {
                logger.warn("");
                continue;
            }
            this.addTab(new DataSetEditDialogTableTab(this.tabFolder, 0, dataSetModel, tableModel, this.jiemamyFacade));
        }
        Composite cmpButtons = new Composite(composite, 0);
        cmpButtons.setLayout((Layout)new RowLayout());
        cmpButtons.setLayoutData((Object)new GridData(768));
        this.btnImport = new Button(cmpButtons, 8);
        this.btnImport.setText(Messages.DataSetEditDialog_btn_import);
        this.btnImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetEditDialog.this.importFromCsv();
            }
        });
        this.btnExport = new Button(cmpButtons, 8);
        this.btnExport.setText(Messages.DataSetEditDialog_btn_export);
        this.btnExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetEditDialog.this.exportToCsv();
            }
        });
        Label label = new Label(cmpButtons, 0);
        label.setText(Messages.DataSetEditDialog_label_notice);
        return composite;
    }

    @Override
    protected Point getDefaultSize() {
        return DEFAULT_SIZE;
    }

    @Override
    protected boolean performOk() {
        return true;
    }

    private void exportToCsv() {
        File csv;
        block14: {
            FileDialog dialog = new FileDialog(this.btnExport.getShell(), 8192);
            dialog.setText(Messages.DataSetEditDialog_export_title);
            dialog.setFileName(this.filename);
            this.filename = dialog.open();
            if (this.filename == null) {
                return;
            }
            csv = new File(this.filename);
            if (csv.exists()) {
                boolean result = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.DataSetEditDialog_export_title, (String)NLS.bind((String)CommonMessages.Common_fileOverwrite, (Object)csv.getPath()));
                if (!result) {
                    return;
                }
                if (!csv.canWrite()) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.DataSetEditDialog_export_title, (String)NLS.bind((String)CommonMessages.Common_fileWriteFailed, (Object)csv.getPath()));
                    return;
                }
            }
            DataSetModel dataSetModel = (DataSetModel)this.getTargetModel();
            TabItem item = this.tabFolder.getItem(this.tabFolder.getSelectionIndex());
            TableModel tableModel = (TableModel)item.getData();
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(csv);
                    DataSetUtil.exportToCsv((DataSetModel)dataSetModel, (TableModel)tableModel, (OutputStream)out);
                }
                catch (IOException e) {
                    ExceptionHandler.handleException(e);
                    IOUtils.closeQuietly((OutputStream)out);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            boolean result = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.DataSetEditDialog_export_title, (String)Messages.DataSetEditDialog_export_success_windows);
            if (result) {
                try {
                    Runtime.getRuntime().exec("cmd /c \"" + csv.getAbsolutePath() + "\"");
                }
                catch (IOException iOException) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.DataSetEditDialog_export_title, (String)Messages.DataSetEditDialog_export_openFailed);
                }
            }
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.DataSetEditDialog_export_title, (String)Messages.DataSetEditDialog_export_success);
        }
    }

    private void importFromCsv() {
        FileDialog dialog = new FileDialog(this.btnImport.getShell(), 4096);
        dialog.setText(Messages.DataSetEditDialog_import_title);
        dialog.setFileName(this.filename);
        this.filename = dialog.open();
        if (this.filename == null) {
            return;
        }
        File csv = new File(this.filename);
        if (!csv.exists()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.DataSetEditDialog_import_title, (String)NLS.bind((String)CommonMessages.Common_fileNotFound, (Object)csv.getPath()));
            return;
        }
        if (!csv.canRead()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.DataSetEditDialog_import_title, (String)NLS.bind((String)CommonMessages.Common_fileNotReadable, (Object)csv.getPath()));
            return;
        }
        boolean result = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.DataSetEditDialog_import_title, (String)Messages.DataSetEditDialog_import_confirm);
        if (!result) {
            return;
        }
        DataSetModel dataSetModel = (DataSetModel)this.getTargetModel();
        TabItem item = this.tabFolder.getItem(this.tabFolder.getSelectionIndex());
        TableModel tableModel = (TableModel)item.getData();
        try {
            DataSetUtil.importFromCsv((DataSetModel)dataSetModel, (TableModel)tableModel, (InputStream)new FileInputStream(csv));
        }
        catch (FileNotFoundException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.DataSetEditDialog_import_title, (String)NLS.bind((String)CommonMessages.Common_fileNotFound, (Object)csv.getPath()));
            ExceptionHandler.handleException(e);
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e);
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.DataSetEditDialog_import_title, (String)Messages.DataSetEditDialog_import_success);
        item.notifyListeners(123, new Event());
    }

    private final class TabMenuListener
    extends MenuAdapter {
        private final DataSetModel dataSetModel;
        private final Menu menu;

        private TabMenuListener(DataSetModel dataSetModel, Menu menu) {
            this.dataSetModel = dataSetModel;
            this.menu = menu;
        }

        public void menuShown(MenuEvent evt) {
            MenuItem[] menuItemArray = this.menu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem item = menuItemArray[n2];
                item.dispose();
                ++n2;
            }
            MenuItem addTab = new MenuItem(this.menu, 8);
            addTab.setText(Messages.DataSetEditDialog_tabMenu_add);
            addTab.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    JiemamyFactory factory = TabMenuListener.this.dataSetModel.getJiemamy().getFactory();
                    RootModel rootModel = factory.getRootModel();
                    Collection tables = rootModel.findEntities(TableModel.class);
                    List list = IteratorUtils.toList(tables.iterator());
                    TableSelectDialog dialog = new TableSelectDialog(DataSetEditDialog.this.getShell(), list);
                    dialog.open();
                    TableModel tableModel = dialog.getResult();
                    DataSetEditDialog.this.jiemamyFacade.addRecords(TabMenuListener.this.dataSetModel, tableModel);
                    DataSetEditDialog.this.addTab(new DataSetEditDialogTableTab(DataSetEditDialog.this.tabFolder, 0, TabMenuListener.this.dataSetModel, tableModel, DataSetEditDialog.this.jiemamyFacade));
                }
            });
            MenuItem removeTab = new MenuItem(this.menu, 8);
            removeTab.setText(Messages.DataSetEditDialog_tabMenu_remove);
            removeTab.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    TabItem item = DataSetEditDialog.this.tabFolder.getItem(DataSetEditDialog.this.tabFolder.getSelectionIndex());
                    TableModel tableModel = (TableModel)item.getData();
                    boolean result = MessageDialog.openQuestion((Shell)DataSetEditDialog.this.getShell(), (String)Messages.DataSetEditDialog_title, (String)NLS.bind((String)Messages.DataSetEditDialog_deleteTable_confirm, (Object)tableModel.getName()));
                    if (!result) {
                        return;
                    }
                    DataSetEditDialog.this.jiemamyFacade.removeRecords(TabMenuListener.this.dataSetModel, tableModel);
                    item.dispose();
                }
            });
        }
    }
}

