/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.dialog.foreignkey;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jiemamy.Jiemamy;
import org.jiemamy.JiemamyProperty;
import org.jiemamy.ReferenceResolver;
import org.jiemamy.eclipse.editor.dialog.foreignkey.Messages;
import org.jiemamy.eclipse.ui.JiemamyEditDialog;
import org.jiemamy.eclipse.ui.helper.TextSelectionAdapter;
import org.jiemamy.facade.JiemamyFacade;
import org.jiemamy.internal.model.attribute.ColumnRefImpl;
import org.jiemamy.model.ElementReference;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.attribute.ColumnModel;
import org.jiemamy.model.attribute.ColumnRef;
import org.jiemamy.model.attribute.constraint.Deferrability;
import org.jiemamy.model.attribute.constraint.ForeignKey;
import org.jiemamy.model.attribute.constraint.KeyConstraint;
import org.jiemamy.model.attribute.constraint.LocalKeyConstraint;
import org.jiemamy.model.entity.TableModel;
import org.jiemamy.utils.CollectionsUtil;
import org.jiemamy.utils.LogMarker;
import org.jiemamy.utils.model.JiemamyPropertyUtil;
import org.jiemamy.utils.model.KeyConstraintUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignKeyEditDialog
extends JiemamyEditDialog<ForeignKey> {
    private static Logger logger = LoggerFactory.getLogger(ForeignKeyEditDialog.class);
    private static final Point DEFAULT_SIZE = new Point(404, 250);
    private List<ColumnModel> sourceColumns;
    private List<LocalKeyConstraint> referenceKeys;
    private List<Combo> keyColumnCombos;
    private List<Label> referenceColumnLabels;
    private Text txtKeyName;
    private Combo cmbReferenceKey;
    private Button chkDeferrable;
    private Button radImmediate;
    private Button radDeferred;
    private Combo cmbMatchType;
    private Combo cmbOnDelete;
    private Combo cmbOnUpdate;
    private Group grpMapping;
    private Composite dialogArea;
    private Jiemamy jiemamy;
    private final JiemamyFacade jiemamyFacade;

    public ForeignKeyEditDialog(Shell shell, ForeignKey foreignKey, JiemamyFacade jiemamyFacade) {
        super(shell, foreignKey, ForeignKey.class);
        Validate.notNull((Object)foreignKey);
        Validate.notNull((Object)jiemamyFacade);
        this.jiemamyFacade = jiemamyFacade;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.jiemamy = foreignKey.getJiemamy();
        TableModel sourceTableModel = foreignKey.findDeclaringTable();
        TableModel targetTableModel = (TableModel)foreignKey.findReferencedEntity();
        this.sourceColumns = sourceTableModel.findColumns();
        this.referenceKeys = targetTableModel.findAttributes(LocalKeyConstraint.class, true);
        this.keyColumnCombos = CollectionsUtil.newArrayList((int)this.referenceKeys.size());
        this.referenceColumnLabels = CollectionsUtil.newArrayList((int)this.referenceKeys.size());
        logger.debug((Marker)LogMarker.LIFECYCLE, "construct");
    }

    public int open() {
        logger.debug((Marker)LogMarker.LIFECYCLE, "open");
        ForeignKey foreignKey = (ForeignKey)this.getTargetModel();
        this.create();
        logger.debug((Marker)LogMarker.LIFECYCLE, "set current value to controls");
        this.txtKeyName.setText(JiemamyPropertyUtil.careNull((String)foreignKey.getName()));
        ForeignKey.MatchType matchType = foreignKey.getMatchType();
        this.cmbMatchType.setText(matchType == null ? "" : matchType.name());
        ForeignKey.ReferentialAction onDelete = foreignKey.getOnDelete();
        this.cmbOnDelete.setText(onDelete == null ? "" : onDelete.name());
        ForeignKey.ReferentialAction onUpdate = foreignKey.getOnUpdate();
        this.cmbOnUpdate.setText(onUpdate == null ? "" : onUpdate.name());
        Deferrability deferrability = foreignKey.getDeferrability();
        if (deferrability == null) {
            this.radImmediate.setSelection(true);
            this.radDeferred.setSelection(false);
        } else {
            this.radImmediate.setSelection(deferrability.getInitiallyCheckTime() == Deferrability.InitiallyCheckTime.IMMEDIATE);
            this.radDeferred.setSelection(deferrability.getInitiallyCheckTime() == Deferrability.InitiallyCheckTime.DEFERRED);
        }
        if (deferrability != null && deferrability.isDeferrable()) {
            this.chkDeferrable.setSelection(true);
            this.radImmediate.setEnabled(true);
            this.radDeferred.setEnabled(true);
        } else {
            this.chkDeferrable.setSelection(false);
            this.radImmediate.setEnabled(false);
            this.radDeferred.setEnabled(false);
        }
        KeyConstraint referenceKeyConstraint = foreignKey.findReferencedKeyConstraint();
        if (referenceKeyConstraint == null) {
            this.cmbReferenceKey.setText(this.cmbReferenceKey.getItem(0));
        } else {
            this.cmbReferenceKey.setText(KeyConstraintUtil.toStringKeyColumns((KeyConstraint)referenceKeyConstraint));
        }
        assert (this.dialogArea != null);
        this.createMappingComponents(this.dialogArea);
        return super.open();
    }

    @Override
    protected boolean canExecuteOk() {
        for (Combo combo : this.keyColumnCombos) {
            if (combo.getSelectionIndex() != -1) continue;
            return false;
        }
        return super.canExecuteOk();
    }

    protected Control createDialogArea(Composite parent) {
        logger.debug((Marker)LogMarker.LIFECYCLE, "createDialogArea");
        this.getShell().setText(Messages.Dialog_Title);
        this.dialogArea = (Composite)super.createDialogArea(parent);
        this.dialogArea.setLayout((Layout)new GridLayout(5, false));
        Label label = new Label(this.dialogArea, 0);
        label.setText("\u5236\u7d04\u540d(&N):");
        this.txtKeyName = new Text(this.dialogArea, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 4;
        this.txtKeyName.setLayoutData((Object)gd);
        this.txtKeyName.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtKeyName));
        label = new Label(this.dialogArea, 0);
        label.setText("\u53c2\u7167\u30ad\u30fc(&K):");
        this.cmbReferenceKey = new Combo(this.dialogArea, 8);
        this.cmbReferenceKey.setLayoutData((Object)new GridData(768));
        for (LocalKeyConstraint referenceKey : this.referenceKeys) {
            StringBuilder sb = new StringBuilder();
            if (referenceKey.getName() != null) {
                sb.append(referenceKey.getName());
                sb.append(" ");
            }
            sb.append(KeyConstraintUtil.toStringKeyColumns((KeyConstraint)referenceKey));
            this.cmbReferenceKey.add(sb.toString());
        }
        this.cmbReferenceKey.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                logger.debug((Marker)LogMarker.LIFECYCLE, "cmbReferenceKey selected");
                ForeignKeyEditDialog.this.createMappingComponents((Composite)ForeignKeyEditDialog.this.grpMapping);
            }
        });
        this.createDeferrabilityComponents(this.dialogArea);
        Composite option = new Composite(this.dialogArea, 0);
        option.setLayout((Layout)new GridLayout(4, false));
        gd = new GridData(1808);
        gd.horizontalSpan = 5;
        option.setLayoutData((Object)gd);
        this.createReferentialActionComponents(option);
        label = new Label(option, 0);
        label.setText("\u30de\u30c3\u30c1\u578b(&M)");
        this.cmbMatchType = new Combo(option, 8);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.cmbMatchType.setLayoutData((Object)gd);
        this.cmbMatchType.add("");
        ForeignKey.MatchType[] matchTypeArray = ForeignKey.MatchType.values();
        int n = matchTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ForeignKey.MatchType matchType = matchTypeArray[n2];
            this.cmbMatchType.add(matchType.name());
            ++n2;
        }
        return this.dialogArea;
    }

    @Override
    protected Point getDefaultSize() {
        return DEFAULT_SIZE;
    }

    @Override
    protected boolean performOk() {
        logger.debug((Marker)LogMarker.LIFECYCLE, "performOk");
        ForeignKey foreignKey = (ForeignKey)this.getTargetModel();
        String name = JiemamyPropertyUtil.careNull((String)this.txtKeyName.getText(), (boolean)true);
        this.jiemamyFacade.changeModelProperty((JiemamyElement)foreignKey, (JiemamyProperty)JiemamyProperty.AttributeProperty.name, (Object)name);
        ForeignKey.MatchType matchType = null;
        try {
            matchType = ForeignKey.MatchType.valueOf((String)this.cmbMatchType.getText());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.warn(String.valueOf(this.cmbMatchType.getText()) + " is not MatchType element.");
        }
        this.jiemamyFacade.changeModelProperty((JiemamyElement)foreignKey, (JiemamyProperty)JiemamyProperty.ForeignKeyProperty.matchType, (Object)matchType);
        ForeignKey.ReferentialAction onDelete = null;
        try {
            onDelete = ForeignKey.ReferentialAction.valueOf((String)this.cmbOnDelete.getText());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.warn(String.valueOf(this.cmbOnDelete.getText()) + " is not ReferentialAction element.");
        }
        this.jiemamyFacade.changeModelProperty((JiemamyElement)foreignKey, (JiemamyProperty)JiemamyProperty.ForeignKeyProperty.onDelete, (Object)onDelete);
        ForeignKey.ReferentialAction onUpdate = null;
        try {
            onUpdate = ForeignKey.ReferentialAction.valueOf((String)this.cmbOnUpdate.getText());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.warn(String.valueOf(this.cmbOnUpdate.getText()) + " is not ReferentialAction element.");
        }
        this.jiemamyFacade.changeModelProperty((JiemamyElement)foreignKey, (JiemamyProperty)JiemamyProperty.ForeignKeyProperty.onUpdate, (Object)onUpdate);
        if (this.chkDeferrable.getSelection()) {
            Deferrability deferrability = foreignKey.getDeferrability();
            if (deferrability == null) {
                deferrability = (Deferrability)this.jiemamy.getFactory().newModel(Deferrability.class);
                this.jiemamyFacade.changeModelProperty((JiemamyElement)foreignKey, (JiemamyProperty)JiemamyProperty.KeyConstraintModelProperty.deferrability, (Object)deferrability);
            }
            this.jiemamyFacade.changeModelProperty((JiemamyElement)deferrability, (JiemamyProperty)JiemamyProperty.DeferrabilityProperty.deferrable, (Object)true);
            Deferrability.InitiallyCheckTime initiallyCheckTime = null;
            if (this.radImmediate.getSelection()) {
                initiallyCheckTime = Deferrability.InitiallyCheckTime.IMMEDIATE;
            } else if (this.radDeferred.getSelection()) {
                initiallyCheckTime = Deferrability.InitiallyCheckTime.DEFERRED;
            }
            this.jiemamyFacade.changeModelProperty((JiemamyElement)deferrability, (JiemamyProperty)JiemamyProperty.DeferrabilityProperty.initiallyCheckTime, (Object)initiallyCheckTime);
        }
        int selectionIndex = this.cmbReferenceKey.getSelectionIndex();
        LocalKeyConstraint referenceKeyConstraint = this.referenceKeys.get(selectionIndex);
        ArrayList newReferenceColumns = CollectionsUtil.newArrayList();
        for (ColumnRef referenceColumnRef : referenceKeyConstraint.getKeyColumns()) {
            newReferenceColumns.add(new ColumnRefImpl(this.jiemamy, referenceColumnRef.getReferenceId()));
        }
        ArrayList newKeyColumns = CollectionsUtil.newArrayList();
        int i = 0;
        while (i < this.keyColumnCombos.size()) {
            int index = this.keyColumnCombos.get(i).getSelectionIndex();
            ColumnModel keyColumn = this.sourceColumns.get(index);
            newKeyColumns.add(this.jiemamy.getFactory().newReference(keyColumn));
            this.jiemamyFacade.addKeyColumn((KeyConstraint)foreignKey, keyColumn);
            ++i;
        }
        this.jiemamyFacade.updateForeignKeyMapping((ForeignKey)this.getTargetModel(), (List)newKeyColumns, (List)newReferenceColumns);
        return true;
    }

    private void createDeferrabilityComponents(Composite parent) {
        this.chkDeferrable = new Button(parent, 32);
        this.chkDeferrable.setText("\u9045\u5ef6\u53ef\u80fd(&A)");
        this.chkDeferrable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (ForeignKeyEditDialog.this.chkDeferrable.getSelection()) {
                    ForeignKeyEditDialog.this.radImmediate.setEnabled(true);
                    ForeignKeyEditDialog.this.radDeferred.setEnabled(true);
                } else {
                    ForeignKeyEditDialog.this.radImmediate.setEnabled(false);
                    ForeignKeyEditDialog.this.radDeferred.setEnabled(false);
                }
            }
        });
        this.radImmediate = new Button(parent, 16);
        this.radImmediate.setText("\u5373\u6642\u8a55\u4fa1(&I)");
        this.radDeferred = new Button(parent, 16);
        this.radDeferred.setText("\u9045\u5ef6\u8a55\u4fa1(&R)");
    }

    private void createMappingComponents(Composite parent) {
        int selectionIndex;
        LocalKeyConstraint referenceKeyConstraint;
        GridData gd;
        this.keyColumnCombos.clear();
        this.referenceColumnLabels.clear();
        if (this.grpMapping == null || this.grpMapping.isDisposed()) {
            this.grpMapping = new Group(parent, 0);
            this.grpMapping.setText("\u30de\u30c3\u30d4\u30f3\u30b0");
            this.grpMapping.setLayout((Layout)new GridLayout(3, false));
            gd = new GridData(1808);
            gd.horizontalSpan = 5;
            this.grpMapping.setLayoutData((Object)gd);
        }
        if ((referenceKeyConstraint = this.referenceKeys.get(selectionIndex = this.cmbReferenceKey.getSelectionIndex())).getKeyColumns().size() == 0) {
            Label label = new Label((Composite)this.grpMapping, 0);
            gd = new GridData(768);
            gd.horizontalSpan = 3;
            label.setLayoutData((Object)gd);
            label.setText("\u53c2\u7167\u3059\u308b\u30ab\u30e9\u30e0\u304c\u3042\u308a\u307e\u305b\u3093");
        } else {
            Control[] controlArray = this.grpMapping.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
            Label label = new Label((Composite)this.grpMapping, 2048);
            label.setText("\u53c2\u7167\u5143");
            label.setLayoutData((Object)new GridData(768));
            label.setAlignment(0x1000000);
            label = new Label((Composite)this.grpMapping, 0);
            label.setText("=>");
            label = new Label((Composite)this.grpMapping, 2048);
            label.setText("\u53c2\u7167\u5148");
            label.setLayoutData((Object)new GridData(768));
            label.setAlignment(0x1000000);
            ReferenceResolver resolver = this.jiemamy.getReferenceResolver();
            ForeignKey foreignKey = (ForeignKey)this.getTargetModel();
            for (ColumnRef referenceColumnRef : referenceKeyConstraint.getKeyColumns()) {
                Combo cmbKeyColumn = new Combo((Composite)this.grpMapping, 8);
                cmbKeyColumn.setLayoutData((Object)new GridData(768));
                for (ColumnModel col : this.sourceColumns) {
                    cmbKeyColumn.add(col.getName());
                }
                int index = foreignKey.getReferenceColumns().indexOf(referenceColumnRef);
                if (index != -1) {
                    ColumnRef keyColumnRef = (ColumnRef)foreignKey.getKeyColumns().get(index);
                    ColumnModel keyColumnModel = (ColumnModel)resolver.resolve((ElementReference)keyColumnRef);
                    cmbKeyColumn.setText(keyColumnModel.getName());
                } else {
                    cmbKeyColumn.setText(cmbKeyColumn.getItem(0));
                }
                cmbKeyColumn.setVisibleItemCount(20);
                this.keyColumnCombos.add(cmbKeyColumn);
                label = new Label((Composite)this.grpMapping, 0);
                label.setText("=>");
                ColumnModel referenceColumnModel = (ColumnModel)resolver.resolve((ElementReference)referenceColumnRef);
                Label lblReferenceColumn = new Label((Composite)this.grpMapping, 2048);
                lblReferenceColumn.setText(referenceColumnModel.getName());
                lblReferenceColumn.setLayoutData((Object)new GridData(768));
                this.referenceColumnLabels.add(lblReferenceColumn);
            }
            this.getShell().pack(true);
            parent.layout(false);
        }
    }

    private void createReferentialActionComponents(Composite parent) {
        ForeignKey.ReferentialAction referentialAction;
        Label label = new Label(parent, 0);
        label.setText("ON DELETE(&D)");
        this.cmbOnDelete = new Combo(parent, 8);
        this.cmbOnDelete.setLayoutData((Object)new GridData(768));
        this.cmbOnDelete.add("");
        ForeignKey.ReferentialAction[] referentialActionArray = ForeignKey.ReferentialAction.values();
        int n = referentialActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            referentialAction = referentialActionArray[n2];
            this.cmbOnDelete.add(referentialAction.name());
            ++n2;
        }
        label = new Label(parent, 0);
        label.setText("ON UPDATE(&U)");
        this.cmbOnUpdate = new Combo(parent, 8);
        this.cmbOnUpdate.setLayoutData((Object)new GridData(768));
        this.cmbOnUpdate.add("");
        referentialActionArray = ForeignKey.ReferentialAction.values();
        n = referentialActionArray.length;
        n2 = 0;
        while (n2 < n) {
            referentialAction = referentialActionArray[n2];
            this.cmbOnUpdate.add(referentialAction.name());
            ++n2;
        }
    }
}

