/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.dialog;

import java.util.Collection;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.jiemamy.eclipse.editor.dialog.EditListener;
import org.jiemamy.eclipse.editor.dialog.TypeOptionHandler;
import org.jiemamy.eclipse.ui.UIConstant;
import org.jiemamy.eclipse.ui.helper.TextSelectionAdapter;
import org.jiemamy.eclipse.utils.ExceptionHandler;
import org.jiemamy.eclipse.utils.SwtUtil;
import org.jiemamy.model.datatype.BuiltinDataType;
import org.jiemamy.model.datatype.DataType;
import org.jiemamy.model.datatype.DataTypeHolder;
import org.jiemamy.model.datatype.adapter.PrecisionedDataTypeAdapter;
import org.jiemamy.model.datatype.adapter.SerialDataTypeAdapter;
import org.jiemamy.model.datatype.adapter.SizedDataTypeAdapter;
import org.jiemamy.model.datatype.adapter.TimezonedDataTypeAdapter;
import org.jiemamy.utils.LogMarker;
import org.jiemamy.utils.model.JiemamyPropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeOptionManager {
    private static Logger logger = LoggerFactory.getLogger(TypeOptionManager.class);
    private final DataTypeHolder<? extends DataType> holder;
    private final Composite composite;
    private final EditListener editListener;
    private final TypeOptionHandler handler;
    private Text txtSize;
    private Text txtPrecision;
    private Text txtScale;
    private Button chkWithTimezone;
    private Button chkSerial;

    public TypeOptionManager(DataTypeHolder<? extends DataType> holder, Composite composite, EditListener editListener, TypeOptionHandler handler) {
        Validate.notNull(holder);
        Validate.notNull((Object)composite);
        Validate.notNull((Object)editListener);
        this.holder = holder;
        this.composite = composite;
        this.editListener = editListener;
        this.handler = handler;
    }

    public void clearTypeOptionControl() {
        Control[] children;
        Control[] controlArray = children = this.composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
    }

    public void createTypeOptionControl(Collection<Class<?>> adapterClasses) {
        Label label;
        this.clearTypeOptionControl();
        DataType dataType = this.holder.getDataType();
        if (!(dataType instanceof BuiltinDataType)) {
            return;
        }
        BuiltinDataType builtinDataType = (BuiltinDataType)dataType;
        for (Class<?> clazz : adapterClasses) {
            if (builtinDataType.hasAdapter(clazz)) continue;
            try {
                builtinDataType.registerAdapter(clazz.newInstance());
            }
            catch (InstantiationException e) {
                ExceptionHandler.handleException(e);
            }
            catch (IllegalAccessException e) {
                ExceptionHandler.handleException(e);
            }
        }
        if (builtinDataType.hasAdapter(SizedDataTypeAdapter.class)) {
            label = new Label(this.composite, 0);
            label.setText("\u30b5\u30a4\u30ba");
            this.txtSize = new Text(this.composite, 2048);
            this.txtSize.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtSize));
            this.txtSize.addKeyListener((KeyListener)this.editListener);
        }
        if (builtinDataType.hasAdapter(PrecisionedDataTypeAdapter.class)) {
            label = new Label(this.composite, 0);
            label.setText("\u7cbe\u5ea6");
            this.txtPrecision = new Text(this.composite, 2048);
            this.txtPrecision.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtPrecision));
            this.txtPrecision.addKeyListener((KeyListener)this.editListener);
            label = new Label(this.composite, 0);
            label.setText("\u4f4d\u53d6\u308a");
            this.txtScale = new Text(this.composite, 2048);
            this.txtScale.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtScale));
            this.txtScale.addKeyListener((KeyListener)this.editListener);
        }
        if (builtinDataType.hasAdapter(TimezonedDataTypeAdapter.class)) {
            this.chkWithTimezone = new Button(this.composite, 32);
            this.chkWithTimezone.setText("WITH TIMEZONE");
            this.chkWithTimezone.addKeyListener((KeyListener)this.editListener);
        }
        if (builtinDataType.hasAdapter(SerialDataTypeAdapter.class)) {
            this.chkSerial = new Button(this.composite, 32);
            this.chkSerial.setText("\u81ea\u52d5\u63a1\u756a");
            this.chkSerial.addSelectionListener((SelectionListener)this.editListener);
        }
        if (this.handler != null) {
            this.handler.createControl(this.holder, this.composite, this.editListener);
        }
        Rectangle bounds = this.composite.getBounds();
        this.composite.setBounds(bounds.x, bounds.y, bounds.width - 1, bounds.height);
        logger.debug((Marker)LogMarker.DETAIL, "before pack: " + this.composite.getSize());
        this.composite.pack(true);
        logger.debug((Marker)LogMarker.DETAIL, "after pack: " + this.composite.getSize());
    }

    public void disable() {
        SwtUtil.setEnabledIfAlive((Control)this.txtSize, false);
        SwtUtil.setEnabledIfAlive((Control)this.txtPrecision, false);
        SwtUtil.setEnabledIfAlive((Control)this.txtScale, false);
        SwtUtil.setEnabledIfAlive((Control)this.chkWithTimezone, false);
        SwtUtil.setEnabledIfAlive((Control)this.chkSerial, false);
        if (this.handler != null) {
            this.handler.disable();
        }
    }

    public void enable() {
        SwtUtil.setEnabledIfAlive((Control)this.txtSize, true);
        SwtUtil.setEnabledIfAlive((Control)this.txtPrecision, true);
        SwtUtil.setEnabledIfAlive((Control)this.txtScale, true);
        SwtUtil.setEnabledIfAlive((Control)this.chkWithTimezone, true);
        SwtUtil.setEnabledIfAlive((Control)this.chkSerial, true);
        if (this.handler != null) {
            this.handler.enable();
        }
    }

    public void setValue(Class<?> clazz) {
        DataType dataType = this.holder.getDataType();
        if (!(dataType instanceof BuiltinDataType)) {
            return;
        }
        BuiltinDataType builtinDataType = (BuiltinDataType)dataType;
        for (Object adapter : builtinDataType.getAdapters()) {
            if (adapter instanceof SizedDataTypeAdapter) {
                SizedDataTypeAdapter sizedDataTypeAdapter = (SizedDataTypeAdapter)adapter;
                Integer size = sizedDataTypeAdapter.getSize();
                this.txtSize.setText(JiemamyPropertyUtil.careNull((String)ObjectUtils.toString((Object)size)));
            }
            if (adapter instanceof PrecisionedDataTypeAdapter) {
                PrecisionedDataTypeAdapter precisionedDataTypeAdapter = (PrecisionedDataTypeAdapter)adapter;
                Integer precision = precisionedDataTypeAdapter.getPrecision();
                Integer scale = precisionedDataTypeAdapter.getScale();
                this.txtPrecision.setText(JiemamyPropertyUtil.careNull((String)ObjectUtils.toString((Object)precision)));
                this.txtScale.setText(JiemamyPropertyUtil.careNull((String)ObjectUtils.toString((Object)scale)));
            }
            if (adapter instanceof TimezonedDataTypeAdapter) {
                TimezonedDataTypeAdapter timezonedDataTypeAdapter = (TimezonedDataTypeAdapter)adapter;
                Boolean withTimeZone = timezonedDataTypeAdapter.isWithTimezone();
                this.chkWithTimezone.setSelection(BooleanUtils.isTrue((Boolean)withTimeZone));
            }
            if (adapter instanceof SerialDataTypeAdapter) {
                SerialDataTypeAdapter serialDataTypeAdapter = (SerialDataTypeAdapter)adapter;
                Boolean serial = serialDataTypeAdapter.isSerial();
                this.chkSerial.setSelection(BooleanUtils.isTrue((Boolean)serial));
            }
            if (this.handler == null) continue;
            this.handler.setValue(clazz);
        }
    }

    public void writeBackToAdapter() {
        Integer value;
        String text;
        DataType dataType = this.holder.getDataType();
        if (!(dataType instanceof BuiltinDataType)) {
            return;
        }
        BuiltinDataType builtinDataType = (BuiltinDataType)dataType;
        if (SwtUtil.isAlive((Control)this.txtSize) && builtinDataType.hasAdapter(SizedDataTypeAdapter.class)) {
            text = this.txtSize.getText();
            value = null;
            try {
                value = Integer.valueOf(text);
                this.txtSize.setBackground(null);
            }
            catch (NumberFormatException numberFormatException) {
                this.txtSize.setBackground(UIConstant.COLOR_ERROR);
            }
            ((SizedDataTypeAdapter)builtinDataType.getAdapter(SizedDataTypeAdapter.class)).setSize(value);
        }
        if (SwtUtil.isAlive((Control)this.txtPrecision) && builtinDataType.hasAdapter(PrecisionedDataTypeAdapter.class)) {
            text = this.txtPrecision.getText();
            value = null;
            try {
                value = Integer.valueOf(text);
                this.txtPrecision.setBackground(null);
            }
            catch (NumberFormatException numberFormatException) {
                this.txtPrecision.setBackground(UIConstant.COLOR_ERROR);
            }
            ((PrecisionedDataTypeAdapter)builtinDataType.getAdapter(PrecisionedDataTypeAdapter.class)).setPrecision(value);
        }
        if (SwtUtil.isAlive((Control)this.txtScale) && builtinDataType.hasAdapter(PrecisionedDataTypeAdapter.class)) {
            text = this.txtScale.getText();
            value = null;
            if (StringUtils.isEmpty((String)text)) {
                this.txtScale.setBackground(null);
            } else {
                try {
                    value = Integer.valueOf(text);
                    this.txtScale.setBackground(null);
                }
                catch (NumberFormatException numberFormatException) {
                    this.txtScale.setBackground(UIConstant.COLOR_ERROR);
                }
            }
            ((PrecisionedDataTypeAdapter)builtinDataType.getAdapter(PrecisionedDataTypeAdapter.class)).setScale(value);
        }
        if (SwtUtil.isAlive((Control)this.chkWithTimezone) && builtinDataType.hasAdapter(TimezonedDataTypeAdapter.class)) {
            boolean value2 = this.chkWithTimezone.getSelection();
            ((TimezonedDataTypeAdapter)builtinDataType.getAdapter(TimezonedDataTypeAdapter.class)).setWithTimezone(!value2 ? null : Boolean.valueOf(value2));
        }
        if (SwtUtil.isAlive((Control)this.chkSerial) && builtinDataType.hasAdapter(SerialDataTypeAdapter.class)) {
            boolean value3 = this.chkSerial.getSelection();
            ((SerialDataTypeAdapter)builtinDataType.getAdapter(SerialDataTypeAdapter.class)).setSerial(!value3 ? null : Boolean.valueOf(value3));
        }
        if (this.handler != null) {
            this.handler.writeBackToAdapter();
        }
    }
}

