/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.command;

import org.eclipse.draw2d.geometry.Point;
import org.jiemamy.eclipse.editor.command.AbstractMovePositionCommand;
import org.jiemamy.eclipse.utils.ConvertUtil;
import org.jiemamy.facade.JiemamyViewFacade;
import org.jiemamy.facade.SavePoint;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.connection.ConnectionAdapter;
import org.jiemamy.model.geometory.JmPoint;

public class MoveBendpointCommand
extends AbstractMovePositionCommand {
    private ConnectionAdapter connectionAdapter;
    private Point newLocation;
    private int bendpointIndex;
    private SavePoint savePoint;
    private int diagramIndex;

    public MoveBendpointCommand(RootModel rootModel, int diagramIndex, ConnectionAdapter connectionAdapter, int bendpointIndex, Point newLocation) {
        super(diagramIndex, (JiemamyViewFacade)rootModel.getJiemamy().getFactory().newFacade(JiemamyViewFacade.class));
        this.diagramIndex = diagramIndex;
        this.connectionAdapter = connectionAdapter;
        this.bendpointIndex = bendpointIndex;
        this.newLocation = newLocation;
        int shiftX = newLocation.x < 0 ? Math.abs(newLocation.x) : 0;
        int shiftY = newLocation.y < 0 ? Math.abs(newLocation.y) : 0;
        this.setShift(new JmPoint(shiftX, shiftY));
    }

    public void execute() {
        JiemamyViewFacade jiemamyFacade = this.getJiemamyFacade();
        this.savePoint = jiemamyFacade.save();
        jiemamyFacade.moveBendpoint(this.diagramIndex, this.connectionAdapter, this.bendpointIndex, ConvertUtil.convert(this.newLocation));
        this.shiftPosition(false);
    }

    public void undo() {
        JiemamyViewFacade jiemamyFacade = this.getJiemamyFacade();
        jiemamyFacade.rollback(this.savePoint);
    }
}

