/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.command;

import org.apache.commons.lang.Validate;
import org.eclipse.gef.commands.Command;
import org.jiemamy.JiemamyProperty;
import org.jiemamy.JiemamyViewProperty;
import org.jiemamy.eclipse.JiemamyUIPlugin;
import org.jiemamy.eclipse.editor.DisplayStatus;
import org.jiemamy.exception.IllegalImplementationException;
import org.jiemamy.facade.JiemamyViewFacade;
import org.jiemamy.facade.SavePoint;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.Mode;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.entity.EntityModel;
import org.jiemamy.model.node.NodeAdapter;
import org.jiemamy.model.node.StickyModel;

public class DirectEditNodeCommand
extends Command {
    private String newValue;
    private final NodeAdapter nodeAdapter;
    private final DisplayStatus displayStatus;
    private final JiemamyViewFacade jiemamyFacade;
    private SavePoint savePoint;

    public DirectEditNodeCommand(RootModel rootModel, DisplayStatus displayStatus, NodeAdapter nodeAdapter) {
        Validate.notNull((Object)rootModel);
        Validate.notNull((Object)((Object)displayStatus));
        Validate.notNull((Object)nodeAdapter);
        this.displayStatus = displayStatus;
        this.nodeAdapter = nodeAdapter;
        this.jiemamyFacade = (JiemamyViewFacade)rootModel.getJiemamy().getFactory().newFacade(JiemamyViewFacade.class);
    }

    public void execute() {
        EntityModel entityModel = this.nodeAdapter.unwrap();
        if (entityModel != null) {
            if (this.displayStatus.getMode() == Mode.PHYSICAL) {
                this.savePoint = this.jiemamyFacade.save();
                this.jiemamyFacade.changeModelProperty((JiemamyElement)entityModel, (JiemamyProperty)JiemamyProperty.EntityProperty.name, (Object)this.newValue);
            } else if (this.displayStatus.getMode() == Mode.LOGICAL) {
                this.savePoint = this.jiemamyFacade.save();
                this.jiemamyFacade.changeModelProperty((JiemamyElement)entityModel, (JiemamyProperty)JiemamyProperty.EntityProperty.logicalName, (Object)this.newValue);
            } else {
                JiemamyUIPlugin.log("\u60f3\u5b9a\u5916\u306eenum\u8981\u7d20", 2);
            }
        } else if (this.nodeAdapter instanceof StickyModel) {
            StickyModel stickyModel = (StickyModel)this.nodeAdapter;
            this.savePoint = this.jiemamyFacade.save();
            this.jiemamyFacade.changeModelProperty((JiemamyElement)stickyModel, (JiemamyProperty)JiemamyViewProperty.StickyProperty.contents, (Object)this.newValue);
        } else {
            throw new IllegalImplementationException((Object)this.nodeAdapter, "Unknown node: " + this.nodeAdapter.getClass());
        }
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public void undo() {
        this.jiemamyFacade.rollback(this.savePoint);
    }
}

