/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.command;

import org.eclipse.gef.commands.Command;
import org.jiemamy.facade.JiemamyViewFacade;
import org.jiemamy.facade.SavePoint;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.attribute.AttributeModel;
import org.jiemamy.model.attribute.constraint.ForeignKey;
import org.jiemamy.model.connection.ConnectionAdapter;
import org.jiemamy.model.entity.TableModel;

public class DeleteConnectionCommand
extends Command {
    private RootModel rootModel;
    private ConnectionAdapter connection;
    private JiemamyViewFacade jiemamyFacade;
    private SavePoint save;

    public DeleteConnectionCommand(RootModel rootModel, ConnectionAdapter connection) {
        this.rootModel = rootModel;
        this.connection = connection;
        this.jiemamyFacade = (JiemamyViewFacade)rootModel.getJiemamy().getFactory().newFacade(JiemamyViewFacade.class);
    }

    public void execute() {
        ForeignKey foreignKey = this.connection.unwrap();
        TableModel definedTable = foreignKey.findDeclaringTable();
        this.save = this.jiemamyFacade.save();
        this.jiemamyFacade.removeAttribute(definedTable, (AttributeModel)foreignKey);
    }

    public void undo() {
        this.jiemamyFacade.rollback(this.save);
        this.rootModel.normalize();
    }
}

