/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.command;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.jiemamy.eclipse.utils.ConvertUtil;
import org.jiemamy.facade.JiemamyViewFacade;
import org.jiemamy.facade.SavePoint;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.node.NodeAdapter;
import org.jiemamy.utils.LogMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class CreateNodeCommand
extends Command {
    private static Logger logger = LoggerFactory.getLogger(CreateNodeCommand.class);
    private final int diagramIndex;
    private NodeAdapter nodeAdapter;
    private Rectangle rectangle;
    private JiemamyViewFacade jiemamyFacade;
    private SavePoint savePoint;

    public CreateNodeCommand(RootModel rootModel, int diagramIndex, NodeAdapter nodeAdapter, Rectangle rectangle) {
        this.diagramIndex = diagramIndex;
        this.nodeAdapter = nodeAdapter;
        this.rectangle = rectangle;
        this.jiemamyFacade = (JiemamyViewFacade)rootModel.getJiemamy().getFactory().newFacade(JiemamyViewFacade.class);
        logger.debug((Marker)LogMarker.LIFECYCLE, "construct");
    }

    public void execute() {
        logger.debug((Marker)LogMarker.LIFECYCLE, "execute");
        this.savePoint = this.jiemamyFacade.save();
        this.jiemamyFacade.addNode(this.diagramIndex, this.nodeAdapter, ConvertUtil.convert(this.rectangle));
    }

    public void undo() {
        logger.debug((Marker)LogMarker.LIFECYCLE, "undo");
        this.jiemamyFacade.rollback(this.savePoint);
    }
}

