/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.command;

import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.commands.Command;
import org.jiemamy.eclipse.JiemamyUIPlugin;
import org.jiemamy.eclipse.editor.command.Messages;
import org.jiemamy.exception.ElementNotFoundException;
import org.jiemamy.facade.JiemamyViewFacade;
import org.jiemamy.facade.SavePoint;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.attribute.constraint.LocalKeyConstraint;
import org.jiemamy.model.attribute.constraint.PrimaryKey;
import org.jiemamy.model.connection.ConnectionAdapter;
import org.jiemamy.model.entity.TableModel;
import org.jiemamy.model.entity.ViewModel;
import org.jiemamy.model.node.NodeAdapter;
import org.jiemamy.model.node.StickyModel;
import org.jiemamy.utils.LogMarker;
import org.seasar.eclipse.common.util.LogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class CreateConnectionCommand
extends Command {
    private static Logger logger = LoggerFactory.getLogger(CreateConnectionCommand.class);
    private NodeAdapter source;
    private int diagramIndex;
    private NodeAdapter target;
    private ConnectionAdapter connection;
    private Dimension figureSize;
    private JiemamyViewFacade jiemamyFacade;
    private SavePoint save;

    public CreateConnectionCommand(RootModel rootModel, int diagramIndex, ConnectionAdapter connection) {
        this.diagramIndex = diagramIndex;
        this.connection = connection;
        this.jiemamyFacade = (JiemamyViewFacade)rootModel.getJiemamy().getFactory().newFacade(JiemamyViewFacade.class);
        logger.debug((Marker)LogMarker.LIFECYCLE, "construct");
    }

    public boolean canExecute() {
        logger.debug((Marker)LogMarker.LIFECYCLE, "canExecute");
        if (this.source == null || this.target == null) {
            logger.debug("source or target is null: " + this.source + " " + this.target);
            return false;
        }
        if (this.source.unwrap() instanceof ViewModel || this.target.unwrap() instanceof ViewModel) {
            LogUtil.log((Plugin)JiemamyUIPlugin.getDefault(), (String)Messages.CreateConnectionCommand_log_canExecute_01);
            return false;
        }
        if (this.source.unwrap() instanceof StickyModel || this.target.unwrap() instanceof StickyModel) {
            LogUtil.log((Plugin)JiemamyUIPlugin.getDefault(), (String)Messages.CreateConnectionCommand_log_canExecute_02);
            return false;
        }
        if (((TableModel)this.source.unwrap()).findColumns().size() < 1) {
            LogUtil.log((Plugin)JiemamyUIPlugin.getDefault(), (String)Messages.CreateConnectionCommand_log_canExecute_03);
            return false;
        }
        if (this.getKey((TableModel)this.target.unwrap()) == null) {
            LogUtil.log((Plugin)JiemamyUIPlugin.getDefault(), (String)Messages.CreateConnectionCommand_log_canExecute_04);
            return false;
        }
        return true;
    }

    public void execute() {
        logger.debug((Marker)LogMarker.LIFECYCLE, "execute");
        if (this.connection.unwrap() != null) {
            TableModel sourceTable = (TableModel)this.source.unwrap();
            TableModel targetTable = (TableModel)this.target.unwrap();
            this.save = this.jiemamyFacade.save();
            this.jiemamyFacade.createConnection(this.diagramIndex, this.connection, sourceTable, targetTable);
        }
        this.jiemamyFacade.resetBendpoint(this.diagramIndex, this.connection);
    }

    public void setFigureSize(Dimension figureSize) {
        this.figureSize = figureSize;
    }

    public void setSource(NodeAdapter source) {
        logger.debug((Marker)LogMarker.LIFECYCLE, "setSource");
        logger.debug((Marker)LogMarker.DETAIL, "source = " + source);
        this.source = source;
    }

    public void setTarget(NodeAdapter target) {
        logger.debug((Marker)LogMarker.LIFECYCLE, "setTarget");
        logger.debug((Marker)LogMarker.DETAIL, "target = " + target);
        this.target = target;
    }

    public void undo() {
        logger.debug((Marker)LogMarker.LIFECYCLE, "undo");
        if (this.connection.unwrap() != null) {
            this.jiemamyFacade.rollback(this.save);
        }
    }

    private LocalKeyConstraint getKey(TableModel tableModel) {
        PrimaryKey key;
        block2: {
            key = null;
            try {
                key = tableModel.findPrimaryKey();
            }
            catch (ElementNotFoundException elementNotFoundException) {
                List attributes = tableModel.findAttributes(LocalKeyConstraint.class);
                if (attributes.size() <= 0) break block2;
                key = (LocalKeyConstraint)attributes.get(0);
            }
        }
        return key;
    }
}

