/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.command;

import org.eclipse.draw2d.geometry.Point;
import org.jiemamy.eclipse.editor.command.AbstractMovePositionCommand;
import org.jiemamy.eclipse.utils.ConvertUtil;
import org.jiemamy.facade.JiemamyViewFacade;
import org.jiemamy.facade.SavePoint;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.connection.ConnectionAdapter;
import org.jiemamy.model.geometory.JmPoint;

public class CreateBendpointCommand
extends AbstractMovePositionCommand {
    private ConnectionAdapter connectionAdapter;
    private Point location;
    private int bendpointIndex;
    private SavePoint save;
    private int diagramIndex;

    public CreateBendpointCommand(RootModel rootModel, int diagramIndex, ConnectionAdapter connectionAdapter, Point location, int bendpointIndex) {
        super(diagramIndex, (JiemamyViewFacade)rootModel.getJiemamy().getFactory().newFacade(JiemamyViewFacade.class));
        this.diagramIndex = diagramIndex;
        this.connectionAdapter = connectionAdapter;
        this.location = location;
        this.bendpointIndex = bendpointIndex;
        int shiftX = location.x < 0 ? Math.abs(location.x) : 0;
        int shiftY = location.y < 0 ? Math.abs(location.y) : 0;
        this.setShift(new JmPoint(shiftX, shiftY));
    }

    public void execute() {
        JiemamyViewFacade jiemamyFacade = this.getJiemamyFacade();
        this.save = jiemamyFacade.save();
        jiemamyFacade.addBendpoint(this.diagramIndex, this.connectionAdapter, this.bendpointIndex, ConvertUtil.convert(this.location));
        this.shiftPosition(false);
    }

    public void undo() {
        JiemamyViewFacade jiemamyFacade = this.getJiemamyFacade();
        jiemamyFacade.rollback(this.save);
    }
}

