/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.jiemamy.eclipse.editor.command.AbstractMovePositionCommand;
import org.jiemamy.eclipse.utils.ConvertUtil;
import org.jiemamy.facade.JiemamyViewFacade;
import org.jiemamy.facade.SavePoint;
import org.jiemamy.model.ConnectionProfile;
import org.jiemamy.model.DiagramPresentationModel;
import org.jiemamy.model.DiagramPresentations;
import org.jiemamy.model.NodeProfile;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.connection.ConnectionAdapter;
import org.jiemamy.model.geometory.JmPoint;
import org.jiemamy.model.geometory.JmRectangle;
import org.jiemamy.model.node.NodeAdapter;
import org.jiemamy.utils.JmPointUtil;
import org.jiemamy.utils.LogMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class ChangeNodeConstraintCommand
extends AbstractMovePositionCommand {
    private static Logger logger = LoggerFactory.getLogger(ChangeNodeConstraintCommand.class);
    private final RootModel rootModel;
    private final int diagramIndex;
    private final NodeAdapter nodeAdapter;
    private final JmRectangle boundary;
    private final JmRectangle oldBoundary;
    private final EditPartViewer viewer;
    private SavePoint save;

    public ChangeNodeConstraintCommand(RootModel rootModel, int diagramIndex, NodeAdapter nodeAdapter, JmRectangle boundary, EditPartViewer viewer) {
        super(diagramIndex, (JiemamyViewFacade)rootModel.getJiemamy().getFactory().newFacade(JiemamyViewFacade.class));
        this.rootModel = rootModel;
        this.diagramIndex = diagramIndex;
        this.nodeAdapter = nodeAdapter;
        DiagramPresentations diagramPresentations = (DiagramPresentations)rootModel.getAdapter(DiagramPresentations.class);
        DiagramPresentationModel presentationModel = diagramPresentations.get(diagramIndex);
        this.oldBoundary = ((NodeProfile)presentationModel.getNodeProfiles().get(nodeAdapter)).getBoundary();
        this.boundary = boundary;
        this.viewer = viewer;
        int shiftX = boundary.x < 0 ? Math.abs(boundary.x) : 0;
        int shiftY = boundary.y < 0 ? Math.abs(boundary.y) : 0;
        this.setShift(new JmPoint(shiftX, shiftY));
    }

    public ChangeNodeConstraintCommand(RootModel rootModel, int diagramIndex, NodeAdapter nodeAdapter, Rectangle rectangle, EditPartViewer viewer) {
        this(rootModel, diagramIndex, nodeAdapter, ConvertUtil.convert(rectangle), viewer);
    }

    public void execute() {
        logger.debug((Marker)LogMarker.LIFECYCLE, "execute");
        JiemamyViewFacade jiemamyFacade = this.getJiemamyFacade();
        this.save = jiemamyFacade.save();
        jiemamyFacade.changeNodeBoundary(this.diagramIndex, this.nodeAdapter, this.boundary);
        this.shiftBendpoints(false);
        this.shiftPosition(false);
    }

    public void undo() {
        JiemamyViewFacade jiemamyFacade = this.getJiemamyFacade();
        jiemamyFacade.rollback(this.save);
    }

    private void shiftBendpoints(boolean positive) {
        JmPoint delta = JmPointUtil.delta((JmRectangle)this.oldBoundary, (JmRectangle)this.boundary);
        ArrayList<Object> selectedModels = new ArrayList<Object>();
        for (Object obj : this.viewer.getSelectedEditParts()) {
            EditPart ep = (EditPart)obj;
            selectedModels.add(ep.getModel());
        }
        for (ConnectionAdapter connection : this.nodeAdapter.getSourceConnections()) {
            if (!selectedModels.contains(connection.getSource()) || !selectedModels.contains(connection.getTarget())) continue;
            JiemamyViewFacade jiemamyFacade = this.getJiemamyFacade();
            DiagramPresentations diagramPresentations = (DiagramPresentations)this.rootModel.getAdapter(DiagramPresentations.class);
            DiagramPresentationModel presentationModel = diagramPresentations.get(this.diagramIndex);
            List bendpoints = ((ConnectionProfile)presentationModel.getConnectionProfiles().get(connection)).getBendpoints();
            for (JmPoint bendpoint : bendpoints) {
                int bendpointIndex = bendpoints.indexOf(bendpoint);
                JmPoint newLocation = positive ? JmPointUtil.shiftPositive((JmPoint)bendpoint, (JmPoint)delta) : JmPointUtil.shiftNegative((JmPoint)bendpoint, (JmPoint)delta);
                jiemamyFacade.moveBendpoint(this.diagramIndex, connection, bendpointIndex, newLocation);
            }
        }
    }
}

