/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor.command;

import java.util.List;
import org.apache.commons.lang.Validate;
import org.eclipse.gef.commands.Command;
import org.jiemamy.JiemamyProperty;
import org.jiemamy.JiemamyViewProperty;
import org.jiemamy.eclipse.editor.JiemamyEditor;
import org.jiemamy.eclipse.utils.EditorUtil;
import org.jiemamy.facade.JiemamyViewFacade;
import org.jiemamy.model.ConnectionProfile;
import org.jiemamy.model.DiagramPresentationModel;
import org.jiemamy.model.DiagramPresentations;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.NodeProfile;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.connection.ConnectionAdapter;
import org.jiemamy.model.geometory.JmPoint;
import org.jiemamy.model.geometory.JmRectangle;
import org.jiemamy.model.node.NodeAdapter;

public abstract class AbstractMovePositionCommand
extends Command {
    private JmPoint shift;
    private int diagramIndex;
    private final JiemamyViewFacade jiemamyFacade;

    public AbstractMovePositionCommand(int diagramIndex, JiemamyViewFacade jiemamyFacade) {
        this.diagramIndex = diagramIndex;
        this.jiemamyFacade = jiemamyFacade;
    }

    public JmPoint getShift() {
        return this.shift;
    }

    public void setShift(JmPoint shift) {
        Validate.notNull((Object)shift);
        this.shift = shift;
    }

    protected JiemamyViewFacade getJiemamyFacade() {
        return this.jiemamyFacade;
    }

    protected void shiftPosition(boolean negative) {
        JiemamyEditor editor = (JiemamyEditor)EditorUtil.getActiveEditor();
        RootModel rootModel = editor.getRootModel();
        DiagramPresentations diagramPresentations = (DiagramPresentations)rootModel.getAdapter(DiagramPresentations.class);
        DiagramPresentationModel presentation = diagramPresentations.get(this.diagramIndex);
        for (NodeAdapter node : presentation.getNodeProfiles().keySet()) {
            NodeProfile nodeProfile = (NodeProfile)presentation.getNodeProfiles().get(node);
            JmRectangle old = nodeProfile.getBoundary();
            JmRectangle newBoundary = negative ? new JmRectangle(old.x - this.shift.x, old.y - this.shift.y, old.width, old.height) : new JmRectangle(old.x + this.shift.x, old.y + this.shift.y, old.width, old.height);
            this.jiemamyFacade.changeModelProperty((JiemamyElement)nodeProfile, (JiemamyProperty)JiemamyViewProperty.NodeProfileProperty.boundary, (Object)newBoundary);
            for (ConnectionAdapter connection : node.getSourceConnections()) {
                ConnectionProfile connectionProfile = (ConnectionProfile)presentation.getConnectionProfiles().get(connection);
                List bendpoints = connectionProfile.getBendpoints();
                for (JmPoint bendpoint : bendpoints) {
                    JmPoint newLocation = negative ? new JmPoint(bendpoint.x - this.shift.x, bendpoint.y - this.shift.y) : new JmPoint(bendpoint.x + this.shift.x, bendpoint.y + this.shift.y);
                    this.jiemamyFacade.moveBendpoint(this.diagramIndex, connection, bendpoints.indexOf(bendpoint), newLocation);
                }
            }
        }
    }
}

