/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SerializationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.jiemamy.Artemis;
import org.jiemamy.ArtemisExtender;
import org.jiemamy.ArtemisView;
import org.jiemamy.Jiemamy;
import org.jiemamy.JiemamyFactory;
import org.jiemamy.JiemamyImplementation;
import org.jiemamy.eclipse.editor.DiagramEditor;
import org.jiemamy.eclipse.editor.JiemamyEditor;
import org.jiemamy.eclipse.editor.JmContributor;
import org.jiemamy.eclipse.utils.ExceptionHandler;
import org.jiemamy.model.DiagramPresentationModel;
import org.jiemamy.model.DiagramPresentations;
import org.jiemamy.model.RootModel;
import org.jiemamy.utils.CollectionsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiDiagramEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
JiemamyEditor {
    private static Logger logger = LoggerFactory.getLogger(MultiDiagramEditor.class);
    private List<DiagramEditor> editors = CollectionsUtil.newArrayList();
    private RootModel rootModel;
    private Jiemamy jiemamy;

    public MultiDiagramEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        block6: {
            ByteArrayOutputStream out = null;
            ByteArrayInputStream in = null;
            try {
                try {
                    out = new ByteArrayOutputStream();
                    this.jiemamy.getSerializer().serialize(this.rootModel, (OutputStream)out);
                    in = new ByteArrayInputStream(out.toByteArray());
                    IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
                    file.setContents((InputStream)in, true, true, monitor);
                    for (DiagramEditor editor : this.editors) {
                        editor.doSave(monitor);
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handleException(e);
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly((OutputStream)out);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((OutputStream)out);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public void doSaveAs() {
        Shell shell = this.getSite().getWorkbenchWindow().getShell();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        dialog.setOriginalFile(((IFileEditorInput)this.getEditorInput()).getFile());
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            return;
        }
        final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        try {
            new ProgressMonitorDialog(shell).run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) {
                    block5: {
                        ByteArrayOutputStream out = null;
                        ByteArrayInputStream in = null;
                        try {
                            try {
                                out = new ByteArrayOutputStream();
                                MultiDiagramEditor.this.jiemamy.getSerializer().serialize(MultiDiagramEditor.this.rootModel, (OutputStream)out);
                                in = new ByteArrayInputStream(out.toByteArray());
                                file.create((InputStream)in, true, monitor);
                            }
                            catch (Exception e) {
                                ExceptionHandler.handleException(e);
                                IOUtils.closeQuietly(in);
                                IOUtils.closeQuietly((OutputStream)out);
                                break block5;
                            }
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(in);
                            IOUtils.closeQuietly((OutputStream)out);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)in);
                        IOUtils.closeQuietly((OutputStream)out);
                    }
                }
            });
            this.setInput((IEditorInput)new FileEditorInput(file));
            for (DiagramEditor editor : this.editors) {
                editor.doSaveAs();
            }
        }
        catch (InterruptedException e) {
            ExceptionHandler.handleException(e);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handleException(e);
        }
    }

    public RootModel getRootModel() {
        return this.rootModel;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        block13: {
            DiagramPresentations presentations;
            super.init(site, input);
            this.jiemamy = Jiemamy.newInstance((JiemamyImplementation)new Artemis(new ArtemisExtender[]{new ArtemisView()}));
            IFile file = ((IFileEditorInput)input).getFile();
            try {
                this.rootModel = this.jiemamy.getSerializer().deserialize(file.getContents());
                this.rootModel.normalize();
            }
            catch (SerializationException e) {
                DiagramPresentations presentations2;
                ExceptionHandler.handleException((Throwable)e, "Data file is broken.");
                JiemamyFactory factory = this.jiemamy.getFactory();
                if (this.rootModel == null) {
                    this.rootModel = factory.getRootModel();
                }
                if ((presentations2 = (DiagramPresentations)this.rootModel.getAdapter(DiagramPresentations.class)).size() == 0) {
                    DiagramPresentationModel presentationModel = (DiagramPresentationModel)factory.newModel(DiagramPresentationModel.class);
                    presentationModel.setName("default");
                    presentations2.add(presentationModel);
                }
                break block13;
            }
            catch (Exception e) {
                try {
                    ExceptionHandler.handleException(e);
                    break block13;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    DiagramPresentations presentations3;
                    JiemamyFactory factory = this.jiemamy.getFactory();
                    if (this.rootModel == null) {
                        this.rootModel = factory.getRootModel();
                    }
                    if ((presentations3 = (DiagramPresentations)this.rootModel.getAdapter(DiagramPresentations.class)).size() == 0) {
                        DiagramPresentationModel presentationModel = (DiagramPresentationModel)factory.newModel(DiagramPresentationModel.class);
                        presentationModel.setName("default");
                        presentations3.add(presentationModel);
                    }
                }
            }
            JiemamyFactory factory = this.jiemamy.getFactory();
            if (this.rootModel == null) {
                this.rootModel = factory.getRootModel();
            }
            if ((presentations = (DiagramPresentations)this.rootModel.getAdapter(DiagramPresentations.class)).size() == 0) {
                DiagramPresentationModel presentationModel = (DiagramPresentationModel)factory.newModel(DiagramPresentationModel.class);
                presentationModel.setName("default");
                presentations.add(presentationModel);
            }
        }
        this.setPartName(input.getName());
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void resourceChanged(IResourceChangeEvent event) {
    }

    public void setFocus() {
        super.setFocus();
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor != null) {
            ((JmContributor)contributor).selectCombo(this.rootModel);
        } else {
            logger.warn("contributor is null.");
        }
    }

    protected void createPages() {
        for (DiagramPresentationModel presentation : (DiagramPresentations)this.rootModel.getAdapter(DiagramPresentations.class)) {
            try {
                DiagramEditor editor = new DiagramEditor(this.rootModel, this.editors.size());
                int tabIndex = this.addPage(editor, this.getEditorInput());
                editor.setTabIndex(tabIndex);
                this.setPageText(tabIndex, presentation.getName());
                this.editors.add(editor);
            }
            catch (PartInitException e) {
                ExceptionHandler.handleException(e);
            }
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.setPartName(input.getName());
    }
}

