/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.gef.ui.actions.ActionBarContributor;
import org.eclipse.gef.ui.actions.AlignmentRetargetAction;
import org.eclipse.gef.ui.actions.DeleteRetargetAction;
import org.eclipse.gef.ui.actions.RedoRetargetAction;
import org.eclipse.gef.ui.actions.UndoRetargetAction;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.gef.ui.actions.ZoomInRetargetAction;
import org.eclipse.gef.ui.actions.ZoomOutRetargetAction;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.jiemamy.eclipse.JiemamyUIPlugin;
import org.jiemamy.eclipse.editor.DisplayStatus;
import org.jiemamy.eclipse.editor.JiemamyEditor;
import org.jiemamy.eclipse.utils.EditorUtil;
import org.jiemamy.eclipse.utils.ExceptionHandler;
import org.jiemamy.model.DiagramPresentationModel;
import org.jiemamy.model.DiagramPresentations;
import org.jiemamy.model.RootModel;
import org.jiemamy.utils.LogMarker;
import org.osgi.framework.Bundle;
import org.seasar.eclipse.common.util.LogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class JmContributor
extends ActionBarContributor {
    private static Logger logger = LoggerFactory.getLogger(JmContributor.class);
    private static final String JIEMAMY_UPDATE_SITE_URL = "http://jiemamy.sourceforge.jp/eclipse/";
    private Combo cmbDisplayStatus;

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add(this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
        toolBarManager.add(this.getActionRegistry().getAction((Object)ActionFactory.UNDO.getId()));
        toolBarManager.add(this.getActionRegistry().getAction((Object)ActionFactory.REDO.getId()));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_left"));
        toolBarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_center"));
        toolBarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_right"));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_top"));
        toolBarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_middle"));
        toolBarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_bottom"));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
        toolBarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_out"));
        toolBarManager.add((IContributionItem)new ZoomComboContributionItem((IPartService)this.getPage()));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IContributionItem)new JiemamyDiagramEditorContribution());
    }

    public void selectCombo(RootModel rootModel) {
        if (this.cmbDisplayStatus == null || this.cmbDisplayStatus.isDisposed()) {
            logger.error("combo is null or disposed");
            return;
        }
        DiagramPresentations presentations = (DiagramPresentations)rootModel.getAdapter(DiagramPresentations.class);
        DiagramPresentationModel presentation = presentations.get(0);
        DisplayStatus[] displayStatusArray = DisplayStatus.values();
        int n = displayStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayStatus displayStatus = displayStatusArray[n2];
            if (presentation.getMode() == displayStatus.getMode() && presentation.getLevel() == displayStatus.getLevel()) {
                this.cmbDisplayStatus.select(displayStatus.ordinal());
                return;
            }
            ++n2;
        }
        logger.error("matched DisplayStatus is not found");
        this.cmbDisplayStatus.select(0);
    }

    protected void buildActions() {
        this.addRetargetAction((RetargetAction)new UndoRetargetAction());
        this.addRetargetAction((RetargetAction)new RedoRetargetAction());
        this.addRetargetAction((RetargetAction)new DeleteRetargetAction());
        this.addRetargetAction((RetargetAction)new ZoomInRetargetAction());
        this.addRetargetAction((RetargetAction)new ZoomOutRetargetAction());
        this.addRetargetAction((RetargetAction)new AlignmentRetargetAction(1));
        this.addRetargetAction((RetargetAction)new AlignmentRetargetAction(2));
        this.addRetargetAction((RetargetAction)new AlignmentRetargetAction(4));
        this.addRetargetAction((RetargetAction)new AlignmentRetargetAction(8));
        this.addRetargetAction((RetargetAction)new AlignmentRetargetAction(16));
        this.addRetargetAction((RetargetAction)new AlignmentRetargetAction(32));
    }

    protected void declareGlobalActionKeys() {
        this.addGlobalActionKey(ActionFactory.SELECT_ALL.getId());
    }

    private class JiemamyDiagramEditorContribution
    extends ControlContribution {
        private JiemamyDiagramEditorContribution() {
            super("org.jiemamy.eclipse.displayMode");
        }

        public void checkUpdate(Composite parent) {
            try {
                ISite rs = SiteManager.getSite((URL)new URL(JmContributor.JIEMAMY_UPDATE_SITE_URL), (IProgressMonitor)new NullProgressMonitor());
                ISiteFeatureReference[] frs = rs.getFeatureReferences();
                VersionedIdentifier frsVi = frs[frs.length - 1].getVersionedIdentifier();
                PluginVersionIdentifier latestVer = frsVi.getVersion();
                Bundle bundle = JiemamyUIPlugin.getDefault().getBundle();
                String version = (String)bundle.getHeaders().get("Bundle-Version");
                PluginVersionIdentifier currentVer = new PluginVersionIdentifier(version);
                if (latestVer.isGreaterThan(currentVer)) {
                    Label label = new Label(parent, 0);
                    label.setText("New version is available.");
                }
            }
            catch (CoreException coreException) {
                LogUtil.log((Plugin)JiemamyUIPlugin.getDefault(), (String)"Network is not connected.");
            }
            catch (MalformedURLException e) {
                ExceptionHandler.handleException(e);
            }
        }

        protected Control createControl(Composite parent) {
            RootModel rootModel;
            JmContributor.this.cmbDisplayStatus = new Combo(parent, 8);
            DisplayStatus[] displayStatusArray = DisplayStatus.values();
            int n = displayStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                DisplayStatus mode = displayStatusArray[n2];
                JmContributor.this.cmbDisplayStatus.add(mode.getLabel());
                ++n2;
            }
            JmContributor.this.cmbDisplayStatus.addSelectionListener((SelectionListener)new ComboSelectionListener());
            IEditorPart editor = EditorUtil.getActiveEditor();
            if (editor instanceof JiemamyEditor && (rootModel = ((JiemamyEditor)editor).getRootModel()) != null) {
                JmContributor.this.selectCombo(rootModel);
            }
            return JmContributor.this.cmbDisplayStatus;
        }

        private class ComboSelectionListener
        extends SelectionAdapter {
            private ComboSelectionListener() {
            }

            public void widgetSelected(SelectionEvent e) {
                logger.debug((Marker)LogMarker.LIFECYCLE, "DisplayStatus changed");
                int index = JmContributor.this.cmbDisplayStatus.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                IEditorPart editor = EditorUtil.getActiveEditor();
                if (!(editor instanceof JiemamyEditor)) {
                    return;
                }
                RootModel rootModel = ((JiemamyEditor)editor).getRootModel();
                DiagramPresentations presentations = (DiagramPresentations)rootModel.getAdapter(DiagramPresentations.class);
                DiagramPresentationModel presentation = presentations.get(0);
                DisplayStatus[] displayStatusArray = DisplayStatus.values();
                int n = displayStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DisplayStatus displayStatus = displayStatusArray[n2];
                    if (displayStatus.ordinal() == index) {
                        presentation.setMode(displayStatus.getMode());
                        presentation.setLevel(displayStatus.getLevel());
                        break;
                    }
                    ++n2;
                }
            }
        }
    }
}

