/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang.Validate;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jiemamy.JiemamyProperty;
import org.jiemamy.eclipse.utils.ExceptionHandler;
import org.jiemamy.facade.JiemamyFacade;
import org.jiemamy.model.Adapter;
import org.jiemamy.model.AdapterType;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.entity.EntityModel;
import org.jiemamy.utils.ReflectionUtil;

@Adapter(value=AdapterType.LOGIC)
public class EntityPropertySource
implements IPropertySource {
    private final JiemamyFacade jiemamyFacade;
    private final EntityModel entityModel;

    public EntityPropertySource(EntityModel entityModel) {
        Validate.notNull((Object)entityModel);
        this.jiemamyFacade = entityModel.getJiemamy().getFactory().newFacade(JiemamyFacade.class);
        this.entityModel = entityModel;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)JiemamyProperty.EntityProperty.name, "\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u540d")};
    }

    public Object getPropertyValue(Object id) {
        if (id instanceof JiemamyProperty) {
            JiemamyProperty prop = (JiemamyProperty)id;
            Class<?> clazz = this.entityModel.getClass();
            try {
                String getterName = ReflectionUtil.convertFieldNameToAccessorName((String)prop.name(), (String)"get");
                Method m = clazz.getMethod(getterName, new Class[0]);
                return m.invoke((Object)this.entityModel, new Object[0]);
            }
            catch (SecurityException e) {
                ExceptionHandler.handleException(e);
            }
            catch (IllegalArgumentException e) {
                ExceptionHandler.handleException(e);
            }
            catch (NoSuchMethodException e) {
                ExceptionHandler.handleException(e);
            }
            catch (IllegalAccessException e) {
                ExceptionHandler.handleException(e);
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handleException(e);
            }
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        this.jiemamyFacade.changeModelProperty((JiemamyElement)this.entityModel, (JiemamyProperty)id, value);
    }
}

