/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor;

import org.jiemamy.eclipse.editor.Messages;
import org.jiemamy.model.DiagramPresentationModel;
import org.jiemamy.model.Level;
import org.jiemamy.model.Mode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DisplayStatus {
    PHYSICAL_ATTRTYPE(Mode.PHYSICAL, Level.ATTRTYPE, Messages.Physical_AttrAndType),
    PHYSICAL_ATTR(Mode.PHYSICAL, Level.ATTR, Messages.Physical_Attribute),
    PHYSICAL_KEY(Mode.PHYSICAL, Level.KEY, Messages.Physical_Key),
    PHYSICAL_ENTITY(Mode.PHYSICAL, Level.ENTITY, Messages.Physical_Entity),
    LOGICAL_ATTRTYPE(Mode.LOGICAL, Level.ATTRTYPE, Messages.Logical_AttrAndType),
    LOGICAL_ATTR(Mode.LOGICAL, Level.ATTR, Messages.Logical_Attribute),
    LOGICAL_KEY(Mode.LOGICAL, Level.KEY, Messages.Logical_Key),
    LOGICAL_ENTITY(Mode.LOGICAL, Level.ENTITY, Messages.Logical_Entity);

    private Mode mode;
    private Level level;
    private String label;

    public static DisplayStatus find(DiagramPresentationModel presentationModel) {
        DisplayStatus[] displayStatusArray = DisplayStatus.values();
        int n = displayStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayStatus status = displayStatusArray[n2];
            if (presentationModel.getMode() == status.mode && presentationModel.getLevel() == status.level) {
                return status;
            }
            ++n2;
        }
        return null;
    }

    private DisplayStatus(Mode mode, Level level, String label) {
        this.mode = mode;
        this.level = level;
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public Level getLevel() {
        return this.level;
    }

    public Mode getMode() {
        return this.mode;
    }
}

