/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor;

import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.PanningSelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageRegistry;
import org.jiemamy.eclipse.JiemamyUIPlugin;
import org.jiemamy.eclipse.editor.JiemamyEditor;
import org.jiemamy.eclipse.utils.EditorUtil;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.attribute.constraint.ForeignKey;
import org.jiemamy.model.entity.TableModel;
import org.jiemamy.model.entity.ViewModel;
import org.jiemamy.model.node.StickyModel;

public final class DiagramEditorPaletteFactory {
    private static ImageRegistry imageRegistry = JiemamyUIPlugin.getDefault().getImageRegistry();

    public static PaletteRoot createPalette() {
        PaletteRoot palette = new PaletteRoot();
        palette.add((PaletteEntry)DiagramEditorPaletteFactory.createBasicToolsGroup(palette));
        palette.add((PaletteEntry)DiagramEditorPaletteFactory.createEntityDrawer(palette));
        palette.add((PaletteEntry)DiagramEditorPaletteFactory.createRelationDrawer(palette));
        palette.add((PaletteEntry)DiagramEditorPaletteFactory.createOtherDrawer(palette));
        return palette;
    }

    private static PaletteContainer createBasicToolsGroup(PaletteRoot palette) {
        PaletteGroup toolGroup = new PaletteGroup("palette.tools");
        PanningSelectionToolEntry tool = new PanningSelectionToolEntry();
        toolGroup.add((PaletteEntry)tool);
        palette.setDefaultEntry((ToolEntry)tool);
        toolGroup.add((PaletteEntry)new MarqueeToolEntry());
        toolGroup.add((PaletteEntry)new PaletteSeparator());
        return toolGroup;
    }

    private static PaletteContainer createEntityDrawer(PaletteRoot palette) {
        PaletteDrawer drawer = new PaletteDrawer("\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3");
        CombinedTemplateCreationEntry tableCreationEntry = new CombinedTemplateCreationEntry("\u30c6\u30fc\u30d6\u30eb", "\u65b0\u3057\u3044\u30c6\u30fc\u30d6\u30eb\u3092\u4f5c\u6210\u3057\u307e\u3059", (CreationFactory)new JiemamyModelCreationFactory(TableModel.class), imageRegistry.getDescriptor("BUTTON_TABLE"), imageRegistry.getDescriptor("BUTTON_TABLE"));
        drawer.add((PaletteEntry)tableCreationEntry);
        CombinedTemplateCreationEntry viewCreationEntry = new CombinedTemplateCreationEntry("\u30d3\u30e5\u30fc", "\u65b0\u3057\u3044\u30d3\u30e5\u30fc\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002", (CreationFactory)new JiemamyModelCreationFactory(ViewModel.class), imageRegistry.getDescriptor("BUTTON_VIEW"), imageRegistry.getDescriptor("BUTTON_VIEW"));
        drawer.add((PaletteEntry)viewCreationEntry);
        return drawer;
    }

    private static PaletteContainer createOtherDrawer(PaletteRoot palette) {
        PaletteDrawer drawer = new PaletteDrawer("\u305d\u306e\u4ed6");
        CombinedTemplateCreationEntry stickyCreationEntry = new CombinedTemplateCreationEntry("\u30e1\u30e2", "\u65b0\u3057\u3044\u30e1\u30e2\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002", (CreationFactory)new JiemamyModelCreationFactory(StickyModel.class), imageRegistry.getDescriptor("BUTTON_VIEW"), imageRegistry.getDescriptor("BUTTON_VIEW"));
        drawer.add((PaletteEntry)stickyCreationEntry);
        return drawer;
    }

    private static PaletteContainer createRelationDrawer(PaletteRoot palette) {
        PaletteDrawer drawer = new PaletteDrawer("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3");
        ConnectionCreationToolEntry foreignKeyCreationEntry = new ConnectionCreationToolEntry("\u5916\u90e8\u30ad\u30fc", "\u65b0\u3057\u3044\u5916\u90e8\u30ad\u30fc\u3092\u5b9a\u7fa9\u3057\u307e\u3059\u3002", (CreationFactory)new JiemamyModelCreationFactory(ForeignKey.class), imageRegistry.getDescriptor("BUTTON_FK"), imageRegistry.getDescriptor("BUTTON_FK"));
        drawer.add((PaletteEntry)foreignKeyCreationEntry);
        return drawer;
    }

    private DiagramEditorPaletteFactory() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JiemamyModelCreationFactory
    implements CreationFactory {
        private Class<? extends JiemamyElement> type;

        public JiemamyModelCreationFactory(Class<? extends JiemamyElement> type) {
            this.type = type;
        }

        public Object getNewObject() {
            JiemamyEditor activeEditor = (JiemamyEditor)EditorUtil.getActiveEditor();
            RootModel rootModel = activeEditor.getRootModel();
            return rootModel.getJiemamy().getFactory().newModel(this.type);
        }

        public Object getObjectType() {
            return this.type;
        }
    }
}

