/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.actions.ActionFactory;
import org.jiemamy.composer.ExportConfig;
import org.jiemamy.composer.Exporter;
import org.jiemamy.composer.ImportConfig;
import org.jiemamy.composer.Importer;
import org.jiemamy.eclipse.JiemamyCorePlugin;
import org.jiemamy.eclipse.action.AutoLayoutAction;
import org.jiemamy.eclipse.action.ChangeNodeBackgroundColorAction;
import org.jiemamy.eclipse.action.ExportAction;
import org.jiemamy.eclipse.action.FitNodeConstraintAction;
import org.jiemamy.eclipse.action.ImportAction;
import org.jiemamy.eclipse.action.PropertyAction;
import org.jiemamy.eclipse.action.SaveDiagramImageAction;
import org.jiemamy.eclipse.editor.DiagramEditor;
import org.jiemamy.eclipse.extension.ExtensionResolver;
import org.jiemamy.eclipse.ui.ExporterWizard;
import org.jiemamy.eclipse.ui.ImporterWizard;
import org.jiemamy.eclipse.utils.ExceptionHandler;

public class DiagramEditorContextMenuProvider
extends ContextMenuProvider {
    private DiagramEditor editorPart;
    private ActionRegistry actionRegistry;

    public DiagramEditorContextMenuProvider(EditPartViewer viewer, DiagramEditor editor, ActionRegistry registry) {
        super(viewer);
        if (registry == null) {
            throw new IllegalArgumentException();
        }
        this.editorPart = editor;
        this.actionRegistry = registry;
    }

    public void buildContextMenu(IMenuManager menu) {
        GEFActionConstants.addStandardActionGroups((IMenuManager)menu);
        GraphicalViewer viewer = (GraphicalViewer)this.getViewer();
        menu.appendToGroup("org.eclipse.gef.group.undo", this.getAction(ActionFactory.UNDO.getId()));
        menu.appendToGroup("org.eclipse.gef.group.undo", this.getAction(ActionFactory.REDO.getId()));
        menu.appendToGroup("org.eclipse.gef.group.edit", this.getAction(ActionFactory.DELETE.getId()));
        menu.appendToGroup("org.eclipse.gef.group.view", this.getAction("org.eclipse.gef.zoom_in"));
        menu.appendToGroup("org.eclipse.gef.group.view", this.getAction("org.eclipse.gef.zoom_out"));
        IAction action = this.getAction("org.eclipse.gef.direct_edit");
        if (action.isEnabled()) {
            menu.appendToGroup("org.eclipse.gef.group.edit", action);
        }
        menu.appendToGroup("org.eclipse.gef.group.edit", (IAction)new ChangeNodeBackgroundColorAction(viewer));
        menu.appendToGroup("org.eclipse.gef.group.edit", (IAction)new SaveDiagramImageAction(viewer));
        menu.appendToGroup("org.eclipse.gef.group.edit", (IAction)new AutoLayoutAction(viewer));
        this.buildImporterMenu(menu, viewer);
        this.buildExporterMenu(menu, viewer);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)new PropertyAction(viewer));
        MenuManager alignMenu = new MenuManager("\u4f4d\u7f6e\u8abf\u6574(&O)");
        action = this.getAction("org.eclipse.gef.align_left");
        action.setEnabled(true);
        if (action.isEnabled()) {
            alignMenu.add(action);
        }
        action = this.getAction("org.eclipse.gef.align_center");
        action.setEnabled(true);
        if (action.isEnabled()) {
            alignMenu.add(action);
        }
        action = this.getAction("org.eclipse.gef.align_right");
        action.setEnabled(true);
        if (action.isEnabled()) {
            alignMenu.add(action);
        }
        alignMenu.add((IContributionItem)new Separator());
        action = this.getAction("org.eclipse.gef.align_top");
        action.setEnabled(true);
        if (action.isEnabled()) {
            alignMenu.add(action);
        }
        action = this.getAction("org.eclipse.gef.align_middle");
        action.setEnabled(true);
        if (action.isEnabled()) {
            alignMenu.add(action);
        }
        action = this.getAction("org.eclipse.gef.align_bottom");
        action.setEnabled(true);
        if (action.isEnabled()) {
            alignMenu.add(action);
        }
        if (!alignMenu.isEmpty()) {
            menu.appendToGroup("org.eclipse.gef.group.rest", (IContributionItem)alignMenu);
        }
        MenuManager matchSizeMenu = new MenuManager("\u30b5\u30a4\u30ba\u8abf\u6574(&Z)");
        matchSizeMenu.add((IAction)new FitNodeConstraintAction(viewer));
        action = this.getAction("org.eclipse.gef.match.height");
        action.setEnabled(true);
        if (action.isEnabled()) {
            matchSizeMenu.add(action);
        }
        action = this.getAction("org.eclipse.gef.match.width");
        action.setEnabled(true);
        if (action.isEnabled()) {
            matchSizeMenu.add(action);
        }
        if (!matchSizeMenu.isEmpty()) {
            menu.appendToGroup("org.eclipse.gef.group.rest", (IContributionItem)matchSizeMenu);
        }
    }

    private void buildExporterMenu(IMenuManager menu, GraphicalViewer viewer) {
        ExtensionResolver exporterResolver = JiemamyCorePlugin.getExporterResolver();
        Map configurationElements = exporterResolver.getExtensionConfigurationElements();
        if (configurationElements.size() > 0) {
            MenuManager exportMenu = new MenuManager("\u30a8\u30af\u30b9\u30dd\u30fc\u30c8(&E)");
            for (IConfigurationElement exporterElement : configurationElements.values()) {
                this.registerExporterToMenu(viewer, exportMenu, exporterElement);
            }
            menu.add((IContributionItem)exportMenu);
        }
    }

    private void buildImporterMenu(IMenuManager menu, GraphicalViewer viewer) {
        ExtensionResolver importerResolver = JiemamyCorePlugin.getImporterResolver();
        Map configurationElements = importerResolver.getExtensionConfigurationElements();
        if (configurationElements.size() > 0) {
            MenuManager importMenu = new MenuManager("\u30a4\u30f3\u30dd\u30fc\u30c8(&I)");
            for (IConfigurationElement importerElement : configurationElements.values()) {
                this.registerImporterToMenu(viewer, importMenu, importerElement);
            }
            menu.add((IContributionItem)importMenu);
        }
    }

    private IAction getAction(String actionId) {
        return this.getActionRegistry().getAction((Object)actionId);
    }

    private ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    private void registerExporterToMenu(GraphicalViewer viewer, MenuManager menu, IConfigurationElement element) {
        try {
            Exporter exporter = (Exporter)element.createExecutableExtension("class");
            ExporterWizard wizard = (ExporterWizard)element.createExecutableExtension("wizard");
            menu.add((IAction)new ExportAction((Exporter<ExportConfig>)exporter, wizard, viewer, this.editorPart));
        }
        catch (ClassCastException e) {
            ExceptionHandler.handleException(e);
        }
        catch (CoreException e) {
            ExceptionHandler.handleException(e);
        }
    }

    private void registerImporterToMenu(GraphicalViewer viewer, MenuManager menu, IConfigurationElement element) {
        try {
            Importer importer = (Importer)element.createExecutableExtension("class");
            ImporterWizard wizard = (ImporterWizard)element.createExecutableExtension("wizard");
            menu.add((IAction)new ImportAction((Importer<ImportConfig>)importer, wizard, viewer, this.editorPart));
        }
        catch (ClassCastException e) {
            ExceptionHandler.handleException(e);
        }
        catch (CoreException e) {
            ExceptionHandler.handleException(e);
        }
    }
}

