/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.editor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.SortedSet;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.MatchHeightAction;
import org.eclipse.gef.ui.actions.MatchWidthAction;
import org.eclipse.gef.ui.actions.SelectAllAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.jiemamy.Artemis;
import org.jiemamy.ArtemisExtender;
import org.jiemamy.ArtemisView;
import org.jiemamy.DispatchStrategy;
import org.jiemamy.InstanceProvider;
import org.jiemamy.Jiemamy;
import org.jiemamy.JiemamyFactory;
import org.jiemamy.JiemamyImplementation;
import org.jiemamy.dialect.Dialect;
import org.jiemamy.eclipse.EclipseDialectProvider;
import org.jiemamy.eclipse.JiemamyCorePlugin;
import org.jiemamy.eclipse.editor.DiagramEditorContextMenuProvider;
import org.jiemamy.eclipse.editor.DiagramEditorPaletteFactory;
import org.jiemamy.eclipse.editor.EntityPropertySource;
import org.jiemamy.eclipse.editor.JiemamyEditor;
import org.jiemamy.eclipse.editor.JmContributor;
import org.jiemamy.eclipse.editor.editpart.DiagramEditPartFactory;
import org.jiemamy.eclipse.editor.editpart.OutlineTreeEditPartFactory;
import org.jiemamy.eclipse.utils.ExceptionHandler;
import org.jiemamy.eclipse.utils.MarkerUtil;
import org.jiemamy.editcommand.Command;
import org.jiemamy.editcommand.CommandListener;
import org.jiemamy.internal.EventBrokerImpl;
import org.jiemamy.model.DiagramPresentationModel;
import org.jiemamy.model.DiagramPresentations;
import org.jiemamy.model.JiemamyElement;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.entity.EntityModel;
import org.jiemamy.serializer.SerializationException;
import org.jiemamy.utils.CollectionsUtil;
import org.jiemamy.utils.LogMarker;
import org.jiemamy.validator.Problem;
import org.jiemamy.validator.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class DiagramEditor
extends GraphicalEditorWithFlyoutPalette
implements IResourceChangeListener,
CommandListener,
JiemamyEditor {
    private static final int KEYCODE_DEL = 127;
    private static Logger logger = LoggerFactory.getLogger(DiagramEditor.class);
    private static PaletteRoot paletteModel;
    private static final double[] ZOOM_LEVELS;
    private ScalableRootEditPart rootEditPart = new ScalableRootEditPart();
    private RootModel rootModel;
    private boolean savePreviouslyNeeded = false;
    private Jiemamy jiemamy;
    private int tabIndex;

    static {
        ZOOM_LEVELS = new double[]{0.1, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.2, 1.5, 2.0, 2.5, 3.0, 5.0, 7.0, 10.0};
    }

    private static int findSeverity(Problem.Severity severity) {
        if (severity == Problem.Severity.ERROR || severity == Problem.Severity.FATAL) {
            return 2;
        }
        if (severity == Problem.Severity.WARN) {
            return 1;
        }
        if (severity == Problem.Severity.INFO || severity == Problem.Severity.NOTICE) {
            return 0;
        }
        return -1;
    }

    public DiagramEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        logger.debug((Marker)LogMarker.LIFECYCLE, "constructed - single");
    }

    public DiagramEditor(RootModel rootModel, int tabIndex) {
        this.tabIndex = tabIndex;
        logger.debug((Marker)LogMarker.LIFECYCLE, "constructed - multi");
    }

    public void commandExecuted(Command command) {
        Dialect dialect;
        try {
            dialect = this.jiemamy.getDialect(this.rootModel);
        }
        catch (ClassNotFoundException classNotFoundException) {
            dialect = (Dialect)JiemamyCorePlugin.getDialectResolver().getAllInstance().get(0);
        }
        Validator validator = dialect.getValidator();
        IResource resource = (IResource)this.getEditorInput().getAdapter(IResource.class);
        MarkerUtil.deleteAllMarkers();
        for (Problem problem : validator.validate(this.rootModel)) {
            Problem.Severity severity = problem.getSeverity();
            String message = problem.getMessage();
            MarkerUtil.createMarker(resource, 1, DiagramEditor.findSeverity(severity), message);
        }
    }

    public void commandStackChanged(EventObject event) {
        if (this.isDirty()) {
            if (!this.savePreviouslyNeeded) {
                this.savePreviouslyNeeded = true;
                this.firePropertyChange(257);
            }
        } else {
            this.savePreviouslyNeeded = false;
            this.firePropertyChange(257);
        }
        super.commandStackChanged(event);
    }

    public void dispose() {
        this.jiemamy.getEventBroker().removeListener((CommandListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
        logger.debug((Marker)LogMarker.LIFECYCLE, "disposed");
        List listeners = ((EventBrokerImpl)this.jiemamy.getEventBroker()).getListeners();
        for (CommandListener listener : listeners) {
            logger.warn(listener + " is not removed from EventBroker.");
        }
    }

    public void doSave(IProgressMonitor monitor) {
        block5: {
            ByteArrayOutputStream out = null;
            ByteArrayInputStream in = null;
            try {
                try {
                    out = new ByteArrayOutputStream();
                    this.jiemamy.getSerializer().serialize(this.rootModel, (OutputStream)out);
                    in = new ByteArrayInputStream(out.toByteArray());
                    IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
                    file.setContents((InputStream)in, true, true, monitor);
                    this.getCommandStack().markSaveLocation();
                }
                catch (Exception e) {
                    ExceptionHandler.handleException(e);
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly((OutputStream)out);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((OutputStream)out);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public void doSaveAs() {
        Shell shell = this.getSite().getWorkbenchWindow().getShell();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        dialog.setOriginalFile(((IFileEditorInput)this.getEditorInput()).getFile());
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            return;
        }
        final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        try {
            new ProgressMonitorDialog(shell).run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) {
                    block5: {
                        ByteArrayOutputStream out = null;
                        ByteArrayInputStream in = null;
                        try {
                            try {
                                out = new ByteArrayOutputStream();
                                DiagramEditor.this.jiemamy.getSerializer().serialize(DiagramEditor.this.rootModel, (OutputStream)out);
                                in = new ByteArrayInputStream(out.toByteArray());
                                file.create((InputStream)in, true, monitor);
                            }
                            catch (Exception e) {
                                ExceptionHandler.handleException(e);
                                IOUtils.closeQuietly(in);
                                IOUtils.closeQuietly((OutputStream)out);
                                break block5;
                            }
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(in);
                            IOUtils.closeQuietly((OutputStream)out);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)in);
                        IOUtils.closeQuietly((OutputStream)out);
                    }
                }
            });
            this.setInput((IEditorInput)new FileEditorInput(file));
            this.getCommandStack().markSaveLocation();
        }
        catch (InterruptedException e) {
            ExceptionHandler.handleException(e);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handleException(e);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ZoomManager.class) {
            return ((ScalableRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        if (adapter == IContentOutlinePage.class) {
            return new DiagramOutlinePage((EditPartViewer)new TreeViewer());
        }
        return super.getAdapter(adapter);
    }

    public RootModel getRootModel() {
        return this.rootModel;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public JiemamyElement getTargetModel() {
        return this.rootModel;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.jiemamy = Jiemamy.newInstance((JiemamyImplementation)new Artemis(new ArtemisExtender[]{new ArtemisView()}), (InstanceProvider)new EclipseDialectProvider());
        this.jiemamy.getEventBroker().setStrategy(new DispatchStrategy(){

            public boolean needToDispatch(CommandListener listener, Command command) {
                return true;
            }
        });
        this.jiemamy.getEventBroker().addListener((CommandListener)this);
        logger.debug((Marker)LogMarker.LIFECYCLE, "initialized");
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IEditorInput input;
        if (event.getType() == 1 && (input = this.getEditorInput()) instanceof IFileEditorInput) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IFile file = ((IFileEditorInput)input).getFile();
                    if (!file.exists()) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        page.closeEditor((IEditorPart)DiagramEditor.this, true);
                    } else if (!DiagramEditor.this.getPartName().equals(file.getName())) {
                        DiagramEditor.this.setPartName(file.getName());
                    }
                }
            });
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part.getSite().getWorkbenchWindow().getActivePage() == null) {
            return;
        }
        super.selectionChanged(part, selection);
    }

    public void setFocus() {
        super.setFocus();
        JmContributor contributor = (JmContributor)this.getEditorSite().getActionBarContributor();
        contributor.selectCombo(this.rootModel);
        logger.debug((Marker)LogMarker.LIFECYCLE, "setFocus");
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new DiagramEditPartFactory());
        viewer.setRootEditPart((RootEditPart)this.rootEditPart);
        ActionRegistry actionRegistry = this.getActionRegistry();
        GraphicalViewerKeyHandler keyHandler = new GraphicalViewerKeyHandler(viewer);
        keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), actionRegistry.getAction((Object)ActionFactory.DELETE.getId()));
        keyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), actionRegistry.getAction((Object)"org.eclipse.gef.direct_edit"));
        viewer.setKeyHandler((KeyHandler)keyHandler);
        viewer.setContextMenu((MenuManager)new DiagramEditorContextMenuProvider((EditPartViewer)viewer, this, actionRegistry));
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry actionRegistry = this.getActionRegistry();
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        ZoomManager zoomManager = this.rootEditPart.getZoomManager();
        ArrayList zoomContributions = CollectionsUtil.newArrayList((int)3);
        zoomContributions.add(ZoomManager.FIT_ALL);
        zoomContributions.add(ZoomManager.FIT_HEIGHT);
        zoomContributions.add(ZoomManager.FIT_WIDTH);
        zoomManager.setZoomLevelContributions((List)zoomContributions);
        zoomManager.setZoomLevels(ZOOM_LEVELS);
        List selectionActions = this.getSelectionActions();
        ZoomInAction action = new ZoomInAction(zoomManager);
        actionRegistry.registerAction((IAction)action);
        handlerService.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)action));
        selectionActions.add(action.getId());
        action = new ZoomOutAction(zoomManager);
        actionRegistry.registerAction((IAction)action);
        handlerService.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)action));
        selectionActions.add(action.getId());
        action = new SelectAllAction((IWorkbenchPart)this);
        actionRegistry.registerAction((IAction)action);
        action = new MatchWidthAction((IWorkbenchPart)this);
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new MatchHeightAction((IWorkbenchPart)this);
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new DirectEditAction((IWorkbenchPart)this);
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 1);
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 4);
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 8);
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 32);
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 2);
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 16);
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
    }

    protected PaletteRoot getPaletteRoot() {
        if (paletteModel == null) {
            paletteModel = DiagramEditorPaletteFactory.createPalette();
        }
        return paletteModel;
    }

    /*
     * Loose catch block
     */
    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer;
        block18: {
            DiagramPresentationModel presentationModel;
            DiagramPresentations diagramPresentations;
            JiemamyFactory factory;
            super.initializeGraphicalViewer();
            viewer = this.getGraphicalViewer();
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            try {
                this.rootModel = this.jiemamy.getSerializer().deserialize(file.getContents());
                this.rootModel.normalize();
            }
            catch (SerializationException e) {
                ExceptionHandler.handleException((Throwable)e, "Data file is broken.");
                factory = this.jiemamy.getFactory();
                if (this.rootModel == null) {
                    this.rootModel = factory.getRootModel();
                }
                if ((diagramPresentations = (DiagramPresentations)this.rootModel.getAdapter(DiagramPresentations.class)).size() < 1) {
                    presentationModel = (DiagramPresentationModel)factory.newModel(DiagramPresentationModel.class);
                    presentationModel.setName("default");
                    diagramPresentations.add(presentationModel);
                }
                break block18;
            }
            catch (CoreException e) {
                ExceptionHandler.handleException(e, 4, "May be, resource is not synchronized.  Try to hit F5 to refresh workspace.");
                break block18;
            }
            catch (Exception e) {
                ExceptionHandler.handleException(e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                factory = this.jiemamy.getFactory();
                if (this.rootModel == null) {
                    this.rootModel = factory.getRootModel();
                }
                if ((diagramPresentations = (DiagramPresentations)this.rootModel.getAdapter(DiagramPresentations.class)).size() < 1) {
                    presentationModel = (DiagramPresentationModel)factory.newModel(DiagramPresentationModel.class);
                    presentationModel.setName("default");
                    diagramPresentations.add(presentationModel);
                }
                break block18;
            }
            {
                finally {
                    factory = this.jiemamy.getFactory();
                    if (this.rootModel == null) {
                        this.rootModel = factory.getRootModel();
                    }
                    if ((diagramPresentations = (DiagramPresentations)this.rootModel.getAdapter(DiagramPresentations.class)).size() < 1) {
                        presentationModel = (DiagramPresentationModel)factory.newModel(DiagramPresentationModel.class);
                        presentationModel.setName("default");
                        diagramPresentations.add(presentationModel);
                    }
                }
            }
            factory = this.jiemamy.getFactory();
            if (this.rootModel == null) {
                this.rootModel = factory.getRootModel();
            }
            if ((diagramPresentations = (DiagramPresentations)this.rootModel.getAdapter(DiagramPresentations.class)).size() < 1) {
                presentationModel = (DiagramPresentationModel)factory.newModel(DiagramPresentationModel.class);
                presentationModel.setName("default");
                diagramPresentations.add(presentationModel);
            }
        }
        this.commandExecuted(null);
        SortedSet entities = this.rootModel.getEntities();
        for (EntityModel entityModel : entities) {
            entityModel.registerAdapter((Object)new EntityPropertySource(entityModel));
        }
        viewer.setContents((Object)this.rootModel);
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.setPartName(input.getName());
    }

    private class DiagramOutlinePage
    extends ContentOutlinePage {
        private SashForm sash;
        private Canvas overview;
        private ScrollableThumbnail thumbnail;
        private DisposeListener disposeListener;
        private final EditPartViewer viewer;

        public DiagramOutlinePage(EditPartViewer viewer) {
            super(viewer);
            this.viewer = viewer;
        }

        public void createControl(Composite parent) {
            this.sash = new SashForm(parent, 512);
            this.viewer.createControl((Composite)this.sash);
            this.configureOutlineViewer();
            this.hookOutlineViewer();
            this.initializeOutlineViewer();
            this.overview = new Canvas((Composite)this.sash, 2048);
            LightweightSystem lws = new LightweightSystem(this.overview);
            ScalableRootEditPart rep = (ScalableRootEditPart)DiagramEditor.this.getGraphicalViewer().getRootEditPart();
            this.thumbnail = new ScrollableThumbnail((Viewport)rep.getFigure());
            this.thumbnail.setSource(rep.getLayer((Object)"Printable Layers"));
            lws.setContents((IFigure)this.thumbnail);
            this.disposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (DiagramOutlinePage.this.thumbnail != null) {
                        DiagramOutlinePage.this.thumbnail.deactivate();
                        DiagramOutlinePage.this.thumbnail = null;
                    }
                }
            };
            DiagramEditor.this.getGraphicalViewer().getControl().addDisposeListener(this.disposeListener);
        }

        public void dispose() {
            SelectionSynchronizer selectionSynchronizer = DiagramEditor.this.getSelectionSynchronizer();
            selectionSynchronizer.removeViewer(this.viewer);
            Control control = DiagramEditor.this.getGraphicalViewer().getControl();
            if (control != null && !control.isDisposed()) {
                control.removeDisposeListener(this.disposeListener);
            }
            super.dispose();
        }

        public Control getControl() {
            return this.sash;
        }

        public void init(IPageSite pageSite) {
            super.init(pageSite);
            ActionRegistry registry = DiagramEditor.this.getActionRegistry();
            IActionBars bars = pageSite.getActionBars();
            String id = ActionFactory.UNDO.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = ActionFactory.REDO.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = ActionFactory.DELETE.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            bars.updateActionBars();
        }

        public void setContents(Object contents) {
            this.viewer.setContents(contents);
        }

        protected void configureOutlineViewer() {
            this.viewer.setEditDomain((EditDomain)DiagramEditor.this.getEditDomain());
            this.viewer.setEditPartFactory((EditPartFactory)new OutlineTreeEditPartFactory());
        }

        protected void hookOutlineViewer() {
            SelectionSynchronizer selectionSynchronizer = DiagramEditor.this.getSelectionSynchronizer();
            selectionSynchronizer.addViewer(this.getViewer());
        }

        protected void initializeOutlineViewer() {
            this.setContents(DiagramEditor.this.rootModel);
        }
    }
}

