/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.composer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.jiemamy.composer.exporter.DefaultSqlExportConfig;
import org.jiemamy.composer.exporter.SqlExportConfig;
import org.jiemamy.composer.exporter.SqlExporter;
import org.jiemamy.eclipse.JiemamyUIPlugin;
import org.jiemamy.eclipse.composer.SqlExportWizardPage;
import org.jiemamy.eclipse.editor.JiemamyEditor;
import org.jiemamy.eclipse.ui.ExporterWizard;
import org.jiemamy.eclipse.ui.FileSelectWizardPage;
import org.jiemamy.eclipse.utils.EditorUtil;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.dataset.DataSetModel;
import org.jiemamy.utils.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlExportWizard
extends Wizard
implements ExporterWizard<SqlExporter, SqlExportConfig>,
IWorkbenchWizard {
    private FileSelectWizardPage page1;
    private SqlExportWizardPage page2;
    private DefaultSqlExportConfig config;

    public SqlExportWizard() {
        IDialogSettings workbenchSettings = JiemamyUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("ExportWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("ExportWizard");
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        IEditorPart activeEditor = EditorUtil.getActiveEditor();
        ArrayList dataSetNames = CollectionsUtil.newArrayList();
        if (activeEditor instanceof JiemamyEditor) {
            JiemamyEditor jiemamyEditor = (JiemamyEditor)activeEditor;
            RootModel rootModel = jiemamyEditor.getRootModel();
            List dataSets = rootModel.getDataSets();
            for (DataSetModel dataSetModel : dataSets) {
                dataSetNames.add(dataSetModel.getName());
            }
        }
        super.addPages();
        this.page1 = new FileSelectWizardPage("\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u9078\u629e", "\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u9078\u629e", null, new String[]{"SQL\u30d5\u30a1\u30a4\u30eb(.sql)", "\u3059\u3079\u3066"}, new String[]{"*.sql", "*.*"});
        this.addPage((IWizardPage)this.page1);
        this.page2 = new SqlExportWizardPage(dataSetNames);
        this.addPage((IWizardPage)this.page2);
    }

    @Override
    public SqlExportConfig getConfig() {
        return this.config;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.setWindowTitle("SQL\u306b\u30a8\u30af\u30b9\u30dd\u30fc\u30c8");
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        this.config = new DefaultSqlExportConfig();
        this.config.setOutputFile(new File(this.page1.getPath()));
        this.config.setOverwrite(this.page1.getOverwrite());
        this.config.setDataSetIndex(this.page2.getDataSetIndex());
        this.config.setEmitDropStatements(this.page2.getEmitDropStatements());
        this.config.setEmitCreateSchema(this.page2.getEmitCreateSchema());
        return true;
    }

    @Override
    public void setInput(IFileEditorInput input) {
    }
}

