/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.composer;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jiemamy.dialect.Dialect;
import org.jiemamy.eclipse.JiemamyCorePlugin;
import org.jiemamy.eclipse.composer.Messages;
import org.jiemamy.eclipse.extension.ExtensionResolver;
import org.jiemamy.eclipse.ui.helper.TextSelectionAdapter;
import org.jiemamy.eclipse.utils.ExceptionHandler;
import org.jiemamy.utils.CollectionsUtil;
import org.jiemamy.utils.DriverUtil;

class DatabaseImportWizardPage
extends WizardPage {
    protected static final String[] JAR_EXTENSIONS = new String[]{"*.jar", "*.*"};
    private Combo cmbDialect;
    private org.eclipse.swt.widgets.List lstDriverJars;
    private Button btnAddJar;
    private Button btnRemoveJar;
    private Combo cmbDriverClass;
    private Text txtUri;
    private Text txtUsername;
    private Text txtPassword;
    private Text txtSchema;
    private Button btnImportDataSet;
    private Button btnTest;
    private ExtensionResolver<Dialect> dialectResolver = JiemamyCorePlugin.getDialectResolver();

    DatabaseImportWizardPage() {
        super(Messages.DatabaseImportWizardPage_title, Messages.DatabaseImportWizardPage_title, null);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(Messages.DatabaseImportWizardPage_label_dbType);
        this.cmbDialect = new Combo(composite, 8);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.cmbDialect.setLayoutData((Object)gd);
        for (Dialect dialect : this.dialectResolver.getAllInstance()) {
            this.cmbDialect.add(dialect.toString());
        }
        this.cmbDialect.select(0);
        this.cmbDialect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String connectionUriTemplate = DatabaseImportWizardPage.this.getDialect().getConnectionUriTemplate();
                DatabaseImportWizardPage.this.txtUri.setText(StringUtils.defaultIfEmpty((String)connectionUriTemplate, (String)DatabaseImportWizardPage.this.txtUri.getText()));
            }
        });
        label = new Label(composite, 0);
        label.setText("JDBC\u30c9\u30e9\u30a4\u30d0jar(&J)");
        this.lstDriverJars = new org.eclipse.swt.widgets.List(composite, 2050);
        this.lstDriverJars.setLayoutData((Object)new GridData(1808));
        Composite cmpButtons = new Composite(composite, 0);
        cmpButtons.setLayout((Layout)new RowLayout(512));
        this.createButtons(cmpButtons);
        label = new Label(composite, 0);
        label.setText("JDBC\u30c9\u30e9\u30a4\u30d0\u30af\u30e9\u30b9(&C)");
        this.cmbDriverClass = new Combo(composite, 2056);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.cmbDriverClass.setLayoutData((Object)gd);
        label = new Label(composite, 0);
        label.setText("\u63a5\u7d9aURI(&I)");
        this.txtUri = new Text(composite, 2048);
        this.txtUri.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtUri));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.txtUri.setLayoutData((Object)gd);
        label = new Label(composite, 0);
        label.setText("\u63a5\u7d9a\u30e6\u30fc\u30b6\u540d(&U)");
        this.txtUsername = new Text(composite, 2048);
        this.txtUsername.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtUsername));
        this.txtUsername.setText("sa");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.txtUsername.setLayoutData((Object)gd);
        label = new Label(composite, 0);
        label.setText("\u63a5\u7d9a\u30d1\u30b9\u30ef\u30fc\u30c9(&P)");
        this.txtPassword = new Text(composite, 0x400800);
        this.txtPassword.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtPassword));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.txtPassword.setLayoutData((Object)gd);
        label = new Label(composite, 0);
        label.setText("\u30b9\u30ad\u30fc\u30de\u540d(&S)");
        this.txtSchema = new Text(composite, 2048);
        this.txtSchema.addFocusListener((FocusListener)new TextSelectionAdapter(this.txtSchema));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.txtSchema.setLayoutData((Object)gd);
        new Label(composite, 0);
        this.btnImportDataSet = new Button(composite, 32);
        this.btnImportDataSet.setText("DataSet\u3092\u30a4\u30f3\u30dd\u30fc\u30c8\u3059\u308b");
        this.btnImportDataSet.setEnabled(false);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.txtSchema.setLayoutData((Object)gd);
        this.createTestButton(composite);
        this.setControl((Control)composite);
    }

    public Dialect getDialect() {
        Dialect instance;
        try {
            instance = (Dialect)this.dialectResolver.getInstance(this.cmbDialect.getText());
        }
        catch (CoreException coreException) {
            instance = (Dialect)this.dialectResolver.getAllInstance().get(0);
        }
        return instance;
    }

    public String getDriverClassName() {
        return this.cmbDriverClass.getText();
    }

    public URL[] getDriverJarPaths() {
        String[] paths = this.lstDriverJars.getItems();
        ArrayList result = CollectionsUtil.newArrayList((int)paths.length);
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            try {
                File file = new File(path.replace(" ", "%20"));
                result.add(file.toURL());
            }
            catch (MalformedURLException e) {
                ExceptionHandler.handleException(e);
            }
            ++n2;
        }
        return result.toArray(new URL[paths.length]);
    }

    public String getPassword() {
        return this.txtPassword.getText();
    }

    public String getSchema() {
        return this.txtSchema.getText();
    }

    public String getUri() {
        return this.txtUri.getText();
    }

    public String getUsername() {
        return this.txtUsername.getText();
    }

    public boolean isImportDataSet() {
        return this.btnImportDataSet.getSelection();
    }

    private void connectionSettingReconfigure() {
        this.setPageComplete(false);
        this.cmbDialect.setEnabled(true);
        this.lstDriverJars.setEnabled(true);
        this.btnAddJar.setEnabled(true);
        this.btnRemoveJar.setEnabled(true);
        this.cmbDriverClass.setEnabled(true);
        this.txtUri.setEnabled(true);
        this.txtUsername.setEnabled(true);
        this.txtPassword.setEnabled(true);
        this.txtSchema.setEnabled(true);
        this.btnTest.setText(Messages.DatabaseImportWizardPage_btn_connectionTest);
    }

    private void connectionSucceeded() {
        this.btnTest.setText(Messages.DatabaseImportWizardPage_btn_reconfigure);
        this.cmbDialect.setEnabled(false);
        this.lstDriverJars.setEnabled(false);
        this.btnAddJar.setEnabled(false);
        this.btnRemoveJar.setEnabled(false);
        this.cmbDriverClass.setEnabled(false);
        this.txtUri.setEnabled(false);
        this.txtUsername.setEnabled(false);
        this.txtPassword.setEnabled(false);
        this.txtSchema.setEnabled(false);
        this.btnImportDataSet.setEnabled(false);
        this.setPageComplete(true);
    }

    private void createButtons(Composite cmpButtons) {
        this.btnAddJar = new Button(cmpButtons, 8);
        this.btnAddJar.setText("\u8ffd\u52a0(&A)");
        this.btnAddJar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(DatabaseImportWizardPage.this.getShell(), 4098);
                fileDialog.setText("JDBC\u30c9\u30e9\u30a4\u30d0jar\u306e\u9078\u629e");
                fileDialog.setFilterExtensions(JAR_EXTENSIONS);
                if (fileDialog.open() == null) {
                    return;
                }
                Object[] fileNames = fileDialog.getFileNames();
                String filterPath = fileDialog.getFilterPath();
                Object[] objectArray = fileNames;
                int n = fileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    Object fileName = objectArray[n2];
                    DatabaseImportWizardPage.this.lstDriverJars.add(String.valueOf(filterPath) + SystemUtils.FILE_SEPARATOR + (String)fileName);
                    ++n2;
                }
                if (!ArrayUtils.isEmpty((Object[])fileNames)) {
                    DatabaseImportWizardPage.this.driverListChanged();
                }
            }
        });
        this.btnRemoveJar = new Button(cmpButtons, 8);
        this.btnRemoveJar.setText("\u524a\u9664(&R)");
        this.btnRemoveJar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] selectionIndices = DatabaseImportWizardPage.this.lstDriverJars.getSelectionIndices();
                if (ArrayUtils.isEmpty((int[])selectionIndices)) {
                    return;
                }
                Arrays.sort(selectionIndices);
                ArrayUtils.reverse((int[])selectionIndices);
                int[] nArray = selectionIndices;
                int n = selectionIndices.length;
                int n2 = 0;
                while (n2 < n) {
                    int selectionIndex = nArray[n2];
                    DatabaseImportWizardPage.this.lstDriverJars.remove(selectionIndex);
                    ++n2;
                }
                if (!ArrayUtils.isEmpty((int[])selectionIndices)) {
                    DatabaseImportWizardPage.this.driverListChanged();
                }
            }
        });
    }

    private void createTestButton(Composite composite) {
        this.btnTest = new Button(composite, 8);
        this.btnTest.setText(Messages.DatabaseImportWizardPage_btn_connectionTest);
        this.btnTest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DatabaseImportWizardPage.this.btnTest.getText().equals(Messages.DatabaseImportWizardPage_btn_reconfigure)) {
                    DatabaseImportWizardPage.this.connectionSettingReconfigure();
                } else {
                    DatabaseImportWizardPage.this.testConnection();
                }
            }
        });
    }

    private void driverListChanged() {
        String oldSelection = this.cmbDriverClass.getText();
        this.cmbDriverClass.removeAll();
        try {
            List driverClasses = DriverUtil.getDriverClasses((URL[])this.getDriverJarPaths());
            for (Class clazz : driverClasses) {
                String className = clazz.getName();
                this.cmbDriverClass.add(className);
                if (!className.equals(oldSelection)) continue;
                this.cmbDriverClass.setText(className);
            }
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e);
        }
        if (StringUtils.isEmpty((String)this.cmbDriverClass.getText())) {
            this.cmbDriverClass.select(0);
        }
        this.setPageComplete(false);
    }

    /*
     * Exception decompiling
     */
    private void testConnection() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

