/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.action;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.jiemamy.eclipse.CommonMessages;
import org.jiemamy.eclipse.action.AbstractJiemamyAction;
import org.jiemamy.eclipse.action.Messages;
import org.jiemamy.eclipse.ui.FileSelectWizardPage;
import org.jiemamy.eclipse.utils.ExceptionHandler;
import org.jiemamy.model.RootModel;

public class SaveDiagramImageAction
extends AbstractJiemamyAction {
    private static final int MARGIN = 50;
    private File file;
    private int format;
    private boolean overwrite;

    public SaveDiagramImageAction(GraphicalViewer viewer) {
        super(Messages.SaveDiagramImageAction_name, viewer);
    }

    public void run() {
        if (this.prepare()) {
            try {
                this.export(this.getViewer(), this.file, this.format, this.overwrite);
            }
            catch (IOException e) {
                ExceptionHandler.handleException(e);
            }
        }
    }

    private void export(GraphicalViewer viewer, File file, int format, boolean overwrite) throws IOException {
        IFigure figure = ((AbstractGraphicalEditPart)viewer.getRootEditPart()).getFigure();
        if (file.exists() && !overwrite) {
            if (!MessageDialog.openQuestion(null, (String)Messages.GraphicWizard_title, (String)NLS.bind((String)CommonMessages.Common_fileOverwrite, (Object)file.getPath()))) {
                return;
            }
        } else if (!file.createNewFile()) {
            throw new IOException();
        }
        if (figure instanceof Viewport) {
            Viewport viewport = (Viewport)figure;
            viewport.setViewLocation(0, 0);
        }
        Dimension size = figure.getPreferredSize();
        Image image = new Image((Device)Display.getDefault(), size.width + 50, size.height + 50);
        GC gc = new GC((Drawable)image);
        SWTGraphics graphics = new SWTGraphics(gc);
        figure.paint((Graphics)graphics);
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image.getImageData()};
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            loader.save((OutputStream)out, format);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    private boolean prepare() {
        RootModel rootModel = (RootModel)this.getViewer().getContents().getModel();
        WizardDialog dialog = new WizardDialog(null, (IWizard)new GraphicWizard(rootModel));
        if (dialog.open() == 1) {
            return false;
        }
        this.overwrite = false;
        if (this.file.exists() && MessageDialog.openConfirm(null, (String)Messages.GraphicWizard_title, (String)NLS.bind((String)CommonMessages.Common_fileOverwrite, (Object)this.file.getPath()))) {
            this.overwrite = true;
        }
        return true;
    }

    private class GraphicWizard
    extends Wizard {
        private GraphicWizardPage page;

        public GraphicWizard(RootModel rootModel) {
            this.setWindowTitle(Messages.GraphicWizard_title);
        }

        public void addPages() {
            this.page = new GraphicWizardPage();
            this.addPage((IWizardPage)this.page);
        }

        public boolean performFinish() {
            SaveDiagramImageAction.this.file = new File(this.page.getPath());
            SaveDiagramImageAction.this.format = this.page.getFormat();
            return true;
        }
    }

    private static class GraphicWizardPage
    extends FileSelectWizardPage {
        private Combo cmbFormat;
        private List<ImageFileFormat> formatList = new ArrayList<ImageFileFormat>(6);

        public GraphicWizardPage() {
            super("GraphicWizardPage", Messages.GraphicWizard_title, null, new String[]{"\u3059\u3079\u3066"}, new String[]{"*.*"});
            this.setDescription(Messages.GraphicWizard_description);
            this.formatList.add(new ImageFileFormat(Messages.FileFormat_jpg_description, "jpeg", 4));
            this.formatList.add(new ImageFileFormat("GIF file format", "gif", 2));
            this.formatList.add(new ImageFileFormat("PNG file format", "png", 5));
            this.formatList.add(new ImageFileFormat(Messages.FileFormat_bmp_description, "bmp", 0));
            this.formatList.add(new ImageFileFormat(Messages.FileFormat_bmpRLE_description, "bmp", 1));
            this.formatList.add(new ImageFileFormat(Messages.FileFormat_ico_description, "ico", 3));
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            Composite composite = (Composite)this.getControl();
            Label label = new Label(composite, 0);
            label.setText(Messages.GraphicWizard_fileFormat_label);
            this.cmbFormat = new Combo(composite, 8);
            for (ImageFileFormat format : this.formatList) {
                this.cmbFormat.add(format.getFormatDescription());
            }
            this.cmbFormat.setText(this.formatList.get(0).getFormatDescription());
            this.cmbFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String path = GraphicWizardPage.this.getPath();
                    int extensionIndex = path.lastIndexOf(".") + 1;
                    StringBuilder sb = new StringBuilder();
                    if (extensionIndex > 0) {
                        sb.append(path.substring(0, extensionIndex));
                    } else {
                        sb.append(path).append(".");
                    }
                    sb.append(GraphicWizardPage.this.getExtension());
                    GraphicWizardPage.this.setPath(sb.toString());
                }
            });
            this.cmbFormat.setFocus();
        }

        public String getExtension() {
            return this.formatList.get(this.cmbFormat.getSelectionIndex()).getExtension();
        }

        public int getFormat() {
            return this.formatList.get(this.cmbFormat.getSelectionIndex()).getFormat();
        }

        private static class ImageFileFormat {
            private String formatDescription;
            private String extension;
            private int format;

            public ImageFileFormat(String formatDescription, String extension, int format) {
                this.formatDescription = formatDescription;
                this.format = format;
                this.extension = extension;
            }

            public String getExtension() {
                return this.extension;
            }

            public int getFormat() {
                return this.format;
            }

            public String getFormatDescription() {
                return this.formatDescription;
            }
        }
    }
}

