/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.action;

import java.util.ArrayList;
import org.apache.commons.lang.Validate;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFileEditorInput;
import org.jiemamy.composer.ImportConfig;
import org.jiemamy.composer.ImportException;
import org.jiemamy.composer.Importer;
import org.jiemamy.eclipse.action.AbstractJiemamyAction;
import org.jiemamy.eclipse.editor.JiemamyEditor;
import org.jiemamy.eclipse.editor.editpart.diagram.RootEditPart;
import org.jiemamy.eclipse.ui.ImporterWizard;
import org.jiemamy.eclipse.utils.ExceptionHandler;
import org.jiemamy.model.RootModel;
import org.jiemamy.utils.CollectionsUtil;
import org.jiemamy.utils.LogMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportAction
extends AbstractJiemamyAction {
    private static Logger logger = LoggerFactory.getLogger(ImportAction.class);
    private final Importer<ImportConfig> importer;
    private final ImporterWizard<Importer<ImportConfig>, ImportConfig> wizard;
    private final JiemamyEditor editor;

    public ImportAction(Importer<ImportConfig> importer, ImporterWizard<Importer<ImportConfig>, ImportConfig> wizard, GraphicalViewer viewer, JiemamyEditor editor) {
        super(importer == null ? null : importer.getName(), viewer);
        Validate.notNull(importer);
        Validate.notNull(wizard);
        Validate.notNull((Object)viewer);
        Validate.notNull((Object)editor);
        this.importer = importer;
        this.wizard = wizard;
        this.editor = editor;
        assert (importer != null);
        logger.debug((Marker)LogMarker.LIFECYCLE, "instanciated " + importer.getName());
    }

    public void run() {
        block17: {
            logger.debug((Marker)LogMarker.LIFECYCLE, "run " + this.importer.getName());
            GraphicalViewer viewer = this.getViewer();
            RootEditPart rootEditPart = (RootEditPart)viewer.getContents();
            RootModel rootModel = rootEditPart.getModel();
            IFileEditorInput input = (IFileEditorInput)this.editor.getEditorInput();
            this.wizard.setInput(input);
            IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
            ArrayList selectedModels = CollectionsUtil.newArrayList();
            for (Object selectedObject : selection.toList()) {
                if (!(selectedObject instanceof EditPart)) continue;
                EditPart editPart = (EditPart)selectedObject;
                selectedModels.add(editPart.getModel());
            }
            Shell shell = viewer.getControl().getShell();
            try {
                WizardDialog dialog = new WizardDialog(shell, this.wizard);
                if (dialog.open() != 0) {
                    logger.debug((Marker)LogMarker.LIFECYCLE, "canceled " + this.importer.getName());
                    return;
                }
                try {
                    ImportConfig config = this.wizard.getConfig();
                    boolean success = this.importer.importModel(rootModel, config);
                    if (success) {
                        rootEditPart.refresh();
                        MessageDialog.openInformation((Shell)shell, (String)"import succeeded", (String)"\u30a4\u30f3\u30dd\u30fc\u30c8\u304c\u6b63\u5e38\u306b\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
                        break block17;
                    }
                    MessageDialog.openWarning((Shell)shell, (String)"import aborted", (String)"\u30a4\u30f3\u30dd\u30fc\u30c8\u306f\u884c\u308f\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                }
                catch (ImportException e) {
                    ExceptionHandler.handleException(e.getCause());
                }
            }
            finally {
                try {
                    ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    ExceptionHandler.handleException(e);
                }
            }
        }
    }
}

