/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.action;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFileEditorInput;
import org.jiemamy.composer.ExportConfig;
import org.jiemamy.composer.ExportException;
import org.jiemamy.composer.Exporter;
import org.jiemamy.composer.FileExportConfig;
import org.jiemamy.eclipse.action.AbstractJiemamyAction;
import org.jiemamy.eclipse.editor.JiemamyEditor;
import org.jiemamy.eclipse.ui.ExporterWizard;
import org.jiemamy.eclipse.utils.ExceptionHandler;
import org.jiemamy.model.RootModel;
import org.jiemamy.utils.CollectionsUtil;
import org.jiemamy.utils.LogMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportAction
extends AbstractJiemamyAction {
    private static Logger logger = LoggerFactory.getLogger(ExportAction.class);
    private final Exporter<ExportConfig> exporter;
    private final ExporterWizard<Exporter<ExportConfig>, ExportConfig> wizard;
    private final JiemamyEditor editor;

    public ExportAction(Exporter<ExportConfig> exporter, ExporterWizard<Exporter<ExportConfig>, ExportConfig> wizard, GraphicalViewer viewer, JiemamyEditor editor) {
        super(exporter == null ? null : exporter.getName(), viewer);
        Validate.notNull(exporter);
        Validate.notNull(wizard);
        Validate.notNull((Object)viewer);
        Validate.notNull((Object)editor);
        this.exporter = exporter;
        this.wizard = wizard;
        this.editor = editor;
        assert (exporter != null);
        logger.debug((Marker)LogMarker.LIFECYCLE, "instanciated " + exporter.getName());
    }

    public void run() {
        block22: {
            logger.debug((Marker)LogMarker.LIFECYCLE, "run " + this.exporter.getName());
            RootModel rootModel = (RootModel)this.getViewer().getContents().getModel();
            IFileEditorInput input = (IFileEditorInput)this.editor.getEditorInput();
            this.wizard.setInput(input);
            IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
            ArrayList selectedModels = CollectionsUtil.newArrayList();
            for (Object selectedObject : selection.toList()) {
                if (!(selectedObject instanceof EditPart)) continue;
                EditPart editPart = (EditPart)selectedObject;
                selectedModels.add(editPart.getModel());
            }
            Shell shell = this.getViewer().getControl().getShell();
            try {
                WizardDialog dialog = new WizardDialog(shell, this.wizard);
                if (dialog.open() != 0) {
                    logger.debug((Marker)LogMarker.LIFECYCLE, "canceled " + this.exporter.getName());
                    return;
                }
                try {
                    ExportConfig config = this.wizard.getConfig();
                    boolean success = this.exporter.exportModel(rootModel, config);
                    if (success) {
                        if (SystemUtils.IS_OS_WINDOWS && config instanceof FileExportConfig) {
                            FileExportConfig fileExportConfig = (FileExportConfig)config;
                            boolean result = MessageDialog.openQuestion(null, (String)"Success", (String)"\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304d\u307e\u3059\u304b\uff1f");
                            if (result) {
                                try {
                                    Runtime.getRuntime().exec("cmd /c \"" + fileExportConfig.getOutputFile().getAbsolutePath() + "\"");
                                }
                                catch (IOException iOException) {
                                    MessageDialog.openError((Shell)shell, (String)"Failed", (String)"\u30d5\u30a1\u30a4\u30eb\u304c\u958b\u3051\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                                }
                            }
                        } else {
                            MessageDialog.openInformation((Shell)shell, (String)"export succeeded", (String)"\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u304c\u6b63\u5e38\u306b\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
                        }
                        break block22;
                    }
                    MessageDialog.openWarning((Shell)shell, (String)"export aborted", (String)"\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u306f\u884c\u308f\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                }
                catch (ExportException e) {
                    MessageDialog.openError((Shell)shell, (String)"export error", (String)e.getMessage());
                }
            }
            finally {
                try {
                    ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    ExceptionHandler.handleException(e);
                }
            }
        }
    }
}

