/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.jiemamy.eclipse.action.AbstractJiemamyAction;
import org.jiemamy.eclipse.action.Messages;
import org.jiemamy.eclipse.editor.editpart.diagram.AbstractJmNodeEditPart;
import org.jiemamy.eclipse.editor.editpart.diagram.RootEditPart;
import org.jiemamy.model.ConnectionProfile;
import org.jiemamy.model.DiagramPresentationModel;
import org.jiemamy.model.DiagramPresentations;
import org.jiemamy.model.NodeProfile;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.connection.ConnectionAdapter;
import org.jiemamy.model.geometory.JmPoint;
import org.jiemamy.model.geometory.JmRectangle;
import org.jiemamy.model.node.NodeAdapter;
import org.jiemamy.utils.model.PresentationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoLayoutAction
extends AbstractJiemamyAction {
    private static final int PADDING = 40;

    private static Node getNode(List<Node> list, NodeAdapter model) {
        for (Node obj : list) {
            EntityNode node = (EntityNode)obj;
            if (node.model != model) continue;
            return node;
        }
        return null;
    }

    public AutoLayoutAction(GraphicalViewer viewer) {
        super(Messages.AutoLayoutAction_name, viewer);
    }

    public void run() {
        RootEditPart rootEditPart = (RootEditPart)this.getViewer().getContents();
        RootModel rootModel = rootEditPart.getModel();
        CompoundCommand commands = new CompoundCommand();
        List editParts = rootEditPart.getChildren();
        NodeList graphNodes = new NodeList();
        EdgeList graphEdges = new EdgeList();
        for (Object obj : editParts) {
            if (!(obj instanceof AbstractJmNodeEditPart)) continue;
            AbstractJmNodeEditPart editPart = (AbstractJmNodeEditPart)obj;
            NodeAdapter model = editPart.getModel();
            EntityNode node = new EntityNode();
            node.model = model;
            node.width = editPart.getFigure().getSize().width;
            node.height = editPart.getFigure().getSize().height;
            graphNodes.add(node);
        }
        for (Object obj : graphNodes) {
            EntityNode node = (EntityNode)((Object)obj);
            Collection conns = node.model.getSourceConnections();
            block2: for (ConnectionAdapter conn : conns) {
                if (conn.isSelfConnection()) continue;
                for (Object obj2 : graphEdges) {
                    ConnectionEdge edge = (ConnectionEdge)((Object)obj2);
                    if (edge.model == conn) continue block2;
                }
                Node source = AutoLayoutAction.getNode((List<Node>)graphNodes, conn.getSource());
                Node target = AutoLayoutAction.getNode((List<Node>)graphNodes, conn.getTarget());
                if (source == null || target == null) continue;
                graphEdges.add(new ConnectionEdge(source, target, conn));
            }
        }
        DirectedGraph graph = new DirectedGraph();
        graph.setDefaultPadding(new Insets(40));
        graph.nodes = graphNodes;
        graph.edges = graphEdges;
        new DirectedGraphLayout().visit(graph);
        for (Object obj : graph.nodes) {
            EntityNode node = (EntityNode)((Object)obj);
            commands.add((Command)new LayoutCommand(rootModel, 0, node.model, node.x, node.y));
        }
        this.getViewer().getEditDomain().getCommandStack().execute((Command)commands);
    }

    private static class ConnectionEdge
    extends Edge {
        private ConnectionAdapter model;

        public ConnectionEdge(Node source, Node target, ConnectionAdapter model) {
            super(source, target);
            this.model = model;
        }
    }

    private static class EntityNode
    extends Node {
        private NodeAdapter model;

        private EntityNode() {
        }
    }

    private static class LayoutCommand
    extends Command {
        private RootModel rootModel;
        private final int diagramIndex;
        private NodeAdapter target;
        private int x;
        private int y;
        private int oldX;
        private int oldY;
        private Map<ConnectionAdapter, List<JmPoint>> oldBendpoints = new HashMap<ConnectionAdapter, List<JmPoint>>();

        public LayoutCommand(RootModel rootModel, int diagramIndex, NodeAdapter target, int x, int y) {
            this.rootModel = rootModel;
            this.diagramIndex = diagramIndex;
            this.target = target;
            this.x = x;
            this.y = y;
            DiagramPresentations diagramPresentations = (DiagramPresentations)rootModel.getAdapter(DiagramPresentations.class);
            DiagramPresentationModel presentation = diagramPresentations.get(diagramIndex);
            NodeProfile nodeProfile = (NodeProfile)presentation.getNodeProfiles().get(target);
            JmRectangle boundary = nodeProfile.getBoundary();
            this.oldX = boundary.x;
            this.oldY = boundary.y;
        }

        public void execute() {
            DiagramPresentations diagramPresentations = (DiagramPresentations)this.rootModel.getAdapter(DiagramPresentations.class);
            DiagramPresentationModel presentation = diagramPresentations.get(this.diagramIndex);
            PresentationUtil.setBoundary((DiagramPresentationModel)presentation, (NodeAdapter)this.target, (JmRectangle)new JmRectangle(this.x, this.y, -1, -1));
            this.oldBendpoints.clear();
            for (ConnectionAdapter conn : this.target.getSourceConnections()) {
                ConnectionProfile connectionProfile = (ConnectionProfile)presentation.getConnectionProfiles().get(conn);
                List bendpoints = connectionProfile.getBendpoints();
                this.oldBendpoints.put(conn, new ArrayList(bendpoints));
                bendpoints.clear();
            }
        }

        public void undo() {
            DiagramPresentations diagramPresentations = (DiagramPresentations)this.rootModel.getAdapter(DiagramPresentations.class);
            DiagramPresentationModel presentation = diagramPresentations.get(this.diagramIndex);
            for (ConnectionAdapter conn : this.target.getSourceConnections()) {
                ConnectionProfile connectionProfile = (ConnectionProfile)presentation.getConnectionProfiles().get(conn);
                List bendpoints = connectionProfile.getBendpoints();
                bendpoints.clear();
                for (JmPoint bendpoint : this.oldBendpoints.get(conn)) {
                    bendpoints.add(bendpoint);
                }
            }
            PresentationUtil.setBoundary((DiagramPresentationModel)presentation, (NodeAdapter)this.target, (JmRectangle)new JmRectangle(this.oldX, this.oldY, -1, -1));
        }
    }
}

