/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.eclipse;

import java.net.URL;
import java.util.ResourceBundle;
import org.apache.commons.lang.Validate;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jiemamy.eclipse.preference.JiemamyPreference;
import org.jiemamy.eclipse.preference.JiemamyPreferenceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.seasar.eclipse.common.util.ImageManager;
import org.seasar.eclipse.common.util.StatusUtil;

public class JiemamyUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.jiemamy.eclipse.ui";
    private static final String ICONS_PATH = "icons/";
    private static JiemamyUIPlugin plugin;
    private static JiemamyPreference pref;

    public static JiemamyUIPlugin getDefault() {
        assert (plugin != null);
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        Validate.notNull((Object)path);
        return JiemamyUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static JiemamyPreference getPreference() {
        assert (pref != null);
        return pref;
    }

    public static void log(String msg, int intStatus) {
        IStatus status = StatusUtil.create((Plugin)plugin, (int)intStatus, (int)0, (String)msg, null);
        plugin.getLog().log(status);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        pref = new JiemamyPreferenceImpl();
    }

    public void stop(BundleContext context) throws Exception {
        pref = null;
        plugin = null;
        super.stop(context);
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        this.registerImage(registry, "BUTTON_TABLE", "table.gif");
        this.registerImage(registry, "BUTTON_VIEW", "view.gif");
        this.registerImage(registry, "BUTTON_FK", "reference.gif");
        this.registerImage(registry, "BUTTON_INH", "reference.gif");
        this.registerImage(registry, "LABEL_TABLE", "circledT.gif");
        this.registerImage(registry, "LABEL_VIEW", "circledV.gif");
        this.registerImage(registry, "ICON_JIEMAMY", "jiemamy.gif");
        this.registerImage(registry, "ICON_TABLE", "table.gif");
        this.registerImage(registry, "ICON_VIEW", "view.gif");
        this.registerImage(registry, "ICON_COLUMN", "column.gif");
        this.registerImage(registry, "ICON_DOMAIN", "circledD.gif");
        this.registerImage(registry, "ICON_PK", "primaryKey.gif");
        this.registerImage(registry, "ICON_FK", "fk.gif");
        this.registerImage(registry, "ICON_INH", "inheritance.gif");
        this.registerImage(registry, "ICON_NULL_DATA", "exclamation.gif");
        this.registerImage(registry, "ICON_COLOR_PALETTE", "palette.gif");
        this.registerImage(registry, "CHECK_ON", "check_on.gif");
        this.registerImage(registry, "CHECK_OFF", "check_off.gif");
        this.registerImage(registry, "CHECK_DISABLED_ON", "check_disabled_on.gif");
        this.registerImage(registry, "CHECK_DISABLED_OFF", "check_disabled_off.gif");
        this.registerImage(registry, "CHECK_HOVER_ON", "check_hover_on.gif");
        this.registerImage(registry, "CHECK_HOVER_OFF", "check_hover_off.gif");
    }

    private void registerImage(ImageRegistry registry, String key, String fileName) {
        Path path = new Path(ICONS_PATH + fileName);
        URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)path, null);
        if (url != null) {
            registry.put(key, ImageDescriptor.createFromURL((URL)url));
        }
    }

    private void setupImageManager(Display display) {
        ImageManager.init((Display)display);
        ResourceBundle imageBundle = ResourceBundle.getBundle("org.jiemamy.eclipse.images");
        ImageManager.loadImages((ResourceBundle)imageBundle);
    }
}

