/*
 * Decompiled with CFR 0.152.
 */
package org.torikiri.jexpression.expression;

import java.math.BigDecimal;
import org.torikiri.jexpression.JEContext;
import org.torikiri.jexpression.JExpression;
import org.torikiri.jexpression.Operation;
import org.torikiri.jexpression.expression.Optimizer;

public class CompositeExpression
implements JExpression {
    private JExpression expr1;
    private JExpression expr2;
    private Operation op;

    public CompositeExpression(JExpression expr1, JExpression expr2, Operation op) {
        this.expr1 = expr1;
        this.expr2 = expr2;
        this.op = op;
    }

    public BigDecimal calculate(JEContext ctx) {
        return this.op.calculate(this.expr1.calculate(ctx), this.expr2.calculate(ctx), ctx);
    }

    public void optimize() {
        Optimizer.Factory.createOptimizer().optimize(this);
    }

    public JExpression getExpr1() {
        return this.expr1;
    }

    public JExpression getExpr2() {
        return this.expr2;
    }

    public Operation getOp() {
        return this.op;
    }

    public void setExpr1(JExpression expr) {
        this.expr1 = expr;
    }

    public void setExpr2(JExpression expr) {
        this.expr2 = expr;
    }

    public void setOp(Operation op) {
        this.op = op;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        if (this.expr1 instanceof CompositeExpression) {
            buff.append("(").append(this.expr1).append(")");
        } else {
            buff.append(this.expr1);
        }
        buff.append(" ").append(this.op).append(" ");
        if (this.expr2 instanceof CompositeExpression) {
            buff.append("(").append(this.expr2).append(")");
        } else {
            buff.append(this.expr2);
        }
        return buff.toString();
    }
}

