<?php
require_once 'PHPUnit2/Framework/TestCase.php';
require_once "../jettable/JetTextBoxDataCell.class.php";

class JetTextBoxDataCellTest extends PHPUnit2_Framework_TestCase {

    public function __construct($name = false)
    {
        parent::__construct($name);
    }

    function setUp()
    {
    }

    function tearDown()
    {
    }

    function testEmptyInitialize()
    {
		$dataCell = new JetTextBoxDataCell(null);
		$result = $dataCell->getHtml();
		$this->assertEquals($result, "<input type=\"text\" value=\"\">");
    }

    function testValueInitialize()
    {
		$dataCell = new JetTextBoxDataCell("aiueo");
		$result = $dataCell->getHtml();
		$this->assertEquals($result, "<input type=\"text\" value=\"aiueo\">");
    }

    function testValueAttributeInitialize()
    {
		$dataCell = new JetTextBoxDataCell("10,000", array("a"=>"b", "c"=>"d"));
		$result = $dataCell->getHtml();
		$this->assertEquals($result, "<input type=\"text\" value=\"10,000\" a=\"b\" c=\"d\">");
    }
}
?>
