<?php
require_once 'PHPUnit2/Framework/TestCase.php';
require_once "../jettable/JetTextAreaDataCell.class.php";

class JetTextAreaDataCellTest extends PHPUnit2_Framework_TestCase {

    public function __construct($name = false)
    {
        parent::__construct($name);
    }

    function setUp()
    {
    }

    function tearDown()
    {
    }

    function testEmptyInitialize()
    {
		$dataCell = new JetTextAreaDataCell(null);
		$result = $dataCell->getHtml();
		$this->assertEquals($result, "<textarea></textarea>");
    }

    function testValueInitialize()
    {
		$dataCell = new JetTextAreaDataCell("aiueo");
		$result = $dataCell->getHtml();
		$this->assertEquals($result, "<textarea>aiueo</textarea>");
    }

    function testValueAttributeInitialize()
    {
		$dataCell = new JetTextAreaDataCell("10,000", array("a"=>"b", "c"=>"d"));
		$result = $dataCell->getHtml();
		$this->assertEquals($result, "<textarea a=\"b\" c=\"d\">10,000</textarea>");
    }

}
?>
