<?php
require_once 'PHPUnit2/Framework/TestCase.php';
require_once "../jettable/JetTable.class.php";

class JetTableTest extends PHPUnit2_Framework_TestCase {

    public function __construct($name = false)
    {
        parent::__construct($name);
    }

    function setUp(){
    }

    function tearDown(){
    }

    function testConstructor(){
		$table = new JetTable();
		$tableText = $table->getTableText();
		$this->assertNull($tebleText);

		$pagerHtml = $table->getPagerHtml();
		$this->assertNull($pagerHtml);

		$tableHtml = $table->getTableHtml();
		$this->assertNull($tableHtml);

		$fullstackTableHtml = $table->getFullStackTableHtml();
		$this->assertNull($fullstackTableHtml);
    }

    function testSort(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");

		$table = new JetTable();
		$table->setData($list);
		$table->useSort(true);
		$table->initializeSort("age", "asc");
		$tableText = $table->getTableHtml();

		$this->assertEquals($tableText, "todo");
    }

    function testAppendAttribute(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");

		$table = new JetTable();
		$table->setData($list);
		$table->appendAttribute("border", "1");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<table border=\"1\">", $tableHtml);
		$this->assertEquals(count($checkArray), 2);

		$table->appendAttribute("width", "100%");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<table border=\"1\" width=\"100%\">", $tableHtml);
		$this->assertEquals(count($checkArray), 2);
	}

	function testAppendAttributeHeaderRow(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");

		$table = new JetTable();
		$table->setData($list);
		$table->appendAttributeHeaderRow("bgcolor", "#ccffcc");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<tr bgcolor=\"#ccffcc\"><th>", $tableHtml);
		$this->assertEquals(count($checkArray), 2);

		$table->appendAttributeHeaderRow("width", "50");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<tr bgcolor=\"#ccffcc\" width=\"50\"><th>", $tableHtml);
		$this->assertEquals(count($checkArray), 2);
	}

	function testAppendAttributeHeaderColumn(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");

		$table = new JetTable();
		$table->setData($list);

		$table->appendAttributeHeaderColumn("id", "bgcolor", "#ccffcc");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<th bgcolor=\"#ccffcc\">", $tableHtml);
		$this->assertEquals(count($checkArray), 2);

		$checkArray = split("<th>", $tableHtml);
		$this->assertEquals(count($checkArray), 3);

		$table->appendAttributeHeaderColumn("id", "width", "50");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<th bgcolor=\"#ccffcc\" width=\"50\">", $tableHtml);
		$this->assertEquals(count($checkArray), 2);

		$checkArray = split("<th>", $tableHtml);
		$this->assertEquals(count($checkArray), 3);
	}

	function testAppendAttributeRow(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");

		$table = new JetTable();
		$table->setData($list);
		$table->appendAttributeRow("bgcolor", "#ccffcc");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<tr bgcolor=\"#ccffcc\"><td>", $tableHtml);
		$this->assertEquals(count($checkArray), 4);

		$checkArray = split("<tr><td>", $tableHtml);
		$this->assertEquals(count($checkArray), 1);

		$table->appendAttributeRow("width", "50");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<tr bgcolor=\"#ccffcc\" width=\"50\"><td>", $tableHtml);
		$this->assertEquals(count($checkArray), 4);

		$checkArray = split("<tr><td>", $tableHtml);
		$this->assertEquals(count($checkArray), 1);
	}

	function testAppendAttributeColumn(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");

		$table = new JetTable();
		$table->setData($list);

		$table->appendAttributeColumn("id", "bgcolor", "#ccffcc");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<td bgcolor=\"#ccffcc\">", $tableHtml);
		$this->assertEquals(count($checkArray), 4);

		$checkArray = split("<td>", $tableHtml);
		$this->assertEquals(count($checkArray), 7);

		$table->appendAttributeColumn("id", "width", "50");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<td bgcolor=\"#ccffcc\" width=\"50\">", $tableHtml);
		$this->assertEquals(count($checkArray), 4);

		$checkArray = split("<td>", $tableHtml);
		$this->assertEquals(count($checkArray), 7);
	}

	function testAppendAttributeRowEreg(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");

		$table = new JetTable();
		$table->setData($list);
		$table->appendAttributeRowEreg("id", "03", "bgcolor", "#ccffcc");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<tr bgcolor=\"#ccffcc\"><td>", $tableHtml);
		$this->assertEquals(count($checkArray), 2);

		$checkArray = split("<tr><td>", $tableHtml);
		$this->assertEquals(count($checkArray), 3);

		$table->appendAttributeRowEreg("id", "03", "width", "50");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<tr bgcolor=\"#ccffcc\" width=\"50\"><td>", $tableHtml);
		$this->assertEquals(count($checkArray), 2);

		$checkArray = split("<tr><td>", $tableHtml);
		$this->assertEquals(count($checkArray), 3);
	}

	function testAppendAttributeColumnEreg(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");

		$table = new JetTable();
		$table->setData($list);
		$table->appendAttributeColumnEreg("id", "03", "bgcolor", "#ccffcc");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<td bgcolor=\"#ccffcc\">", $tableHtml);
		$this->assertEquals(count($checkArray), 2);

		$checkArray = split("<td>", $tableHtml);
		$this->assertEquals(count($checkArray), 9);

		$table->appendAttributeColumnEreg("id", "03", "width", "50");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<td bgcolor=\"#ccffcc\" width=\"50\">", $tableHtml);
		$this->assertEquals(count($checkArray), 2);

		$checkArray = split("<td>", $tableHtml);
		$this->assertEquals(count($checkArray), 9);
	}

	function testAppendAttributeColumnAll(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");

		$table = new JetTable();
		$table->setData($list);
		$table->appendAttributeColumnAll("bgcolor", "#ccffcc");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<td bgcolor=\"#ccffcc\">", $tableHtml);
		$this->assertEquals(count($checkArray), 10);

		$checkArray = split("<td>", $tableHtml);
		$this->assertEquals(count($checkArray), 1);

		$table->appendAttributeColumnAll("width", "50");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<td bgcolor=\"#ccffcc\" width=\"50\">", $tableHtml);
		$this->assertEquals(count($checkArray), 10);

		$checkArray = split("<td>", $tableHtml);
		$this->assertEquals(count($checkArray), 1);
	}

	function testAppendAttributeHeaderColumnAll(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");

		$table = new JetTable();
		$table->setData($list);
		$table->appendAttributeHeaderColumnAll("bgcolor", "#ccffcc");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<th bgcolor=\"#ccffcc\">", $tableHtml);
		$this->assertEquals(count($checkArray), 4);

		$checkArray = split("<th>", $tableHtml);
		$this->assertEquals(count($checkArray), 1);

		$table->appendAttributeHeaderColumnAll("width", "50");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<th bgcolor=\"#ccffcc\" width=\"50\">", $tableHtml);
		$this->assertEquals(count($checkArray), 4);

		$checkArray = split("<th>", $tableHtml);
		$this->assertEquals(count($checkArray), 1);
	}

	function testUseSort(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");

		$table = new JetTable();
		$table->setData($list);
		$table->useSort(true);
		$tableHtml = $table->getTableHtml();

		$checkArray = split("<th><a href=\"", $tableHtml);
		$this->assertEquals(count($checkArray), 4);

		$table->useSort(false);
		$tableHtml = $table->getTableHtml();

		$checkArray = split("<th><a href=\"", $tableHtml);
		$this->assertEquals(count($checkArray), 1);

		$checkArray = split("<th>", $tableHtml);
		$this->assertEquals(count($checkArray), 4);
	}

	function testUsePlugin(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");

		$table = new JetTable();
		$table->setData($list);

		$table->usePlugin(true);
		$tableHtml = $table->getFullstackTableHtml();

		$checkArray = split("Plugin", $tableHtml);
		$this->assertEquals(count($checkArray), 2);

		$table->usePlugin(false);
		$tableHtml = $table->getFullstackTableHtml();

		$checkArray = split("Plugin", $tableHtml);
		$this->assertEquals(count($checkArray), 1);
	}

	function testUsePager(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");

		$table = new JetTable();
		$table->setData($list);

		$table->usePager(true);
		$tableHtml = $table->getFullstackTableHtml();

		$checkArray = split("Page", $tableHtml);
		$this->assertEquals(count($checkArray), 2);

		$checkArray = split("Items", $tableHtml);
		$this->assertEquals(count($checkArray), 2);

		$table->usePager(false);
		$tableHtml = $table->getFullstackTableHtml();

		$checkArray = split("Page", $tableHtml);
		$this->assertEquals(count($checkArray), 1);

		$checkArray = split("Items", $tableHtml);
		$this->assertEquals(count($checkArray), 1);
	}

	public function testSetSortableHeader(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");

		$table = new JetTable();
		$table->setData($list);
		$table->useSort(true);
		$table->setSortableHeader(array("age", "name"));
		$tableHtml = $table->getTableHtml();

		$checkArray = split("<th><a", $tableHtml);
		$this->assertEquals(count($checkArray), 3);

		$checkArray = split("<th>", $tableHtml);
		$this->assertEquals(count($checkArray), 4);
	}

	public function testSetData(){
		$table = new JetTable();
		$table->setData(null);
		$tableHtml = $table->getTableHtml();
		$this->assertNull($tableHtml);

		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");

		$table = new JetTable();
		$table->setData($list);
		$tableHtml = $table->getTableHtml();
		$this->assertNotNull($tableHtml);
	}

	public function testSetHeader(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");

		$table = new JetTable();
		$table->setData($list);
		$table->setHeader(array("name"=>"NAME"));
		$tableHtml = $table->getTableHtml();

		$checkArray = split("name", $tableHtml);
		$this->assertEquals(count($checkArray), 1);

		$checkArray = split("id", $tableHtml);
		$this->assertEquals(count($checkArray), 1);

		$checkArray = split("age", $tableHtml);
		$this->assertEquals(count($checkArray), 1);

		$checkArray = split("NAME", $tableHtml);
		$this->assertEquals(count($checkArray), 2);

		$checkArray = split("<tr><th>NAME</th></tr>", $tableHtml);
		$this->assertEquals(count($checkArray), 2);

		$table->setHeader(array("name"=>"NAME", "id"=>"ID"));
		$tableHtml = $table->getTableHtml();

		$checkArray = split("name", $tableHtml);
		$this->assertEquals(count($checkArray), 1);

		$checkArray = split("id", $tableHtml);
		$this->assertEquals(count($checkArray), 1);

		$checkArray = split("age", $tableHtml);
		$this->assertEquals(count($checkArray), 1);

		$checkArray = split("NAME", $tableHtml);
		$this->assertEquals(count($checkArray), 2);

		$checkArray = split("ID", $tableHtml);
		$this->assertEquals(count($checkArray), 2);

		$checkArray = split("<tr><th>NAME</th><th>ID</th></tr>", $tableHtml);
		$this->assertEquals(count($checkArray), 2);
	}

	public function testSetOutputForm(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");

		$table = new JetTable();
		$table->setData($list);

		$table->setOutputForm("age", "text");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<input type=\"text\"", $tableHtml);
		$this->assertEquals(count($checkArray), 4);

		$table->setOutputForm("age", "textarea");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<textarea", $tableHtml);
		$this->assertEquals(count($checkArray), 4);

		$table->setOutputForm("age", "select");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<select", $tableHtml);
		$this->assertEquals(count($checkArray), 4);

		$table->setOutputForm("age", "checkbox");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<input type=\"checkbox\"", $tableHtml);
		$this->assertEquals(count($checkArray), 4);

		$table->setOutputForm("age", "radio");
		$tableHtml = $table->getTableHtml();
		$checkArray = split("<input type=\"radio\"", $tableHtml);
		$this->assertEquals(count($checkArray), 4);
	}

	public function testInitializePager(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");

		$table = new JetTable();
		$table->setData($list);
		$table->initializePager(1, 1);
		$tableHtml = $table->getTableHtml();

		$checkArray = split(">2<", $tableHtml);
		$this->assertEquals(count($checkArray), 2);
		$checkArray = split(">3<", $tableHtml);
		$this->assertEquals(count($checkArray), 2);

		$table->initializePager(1, 2);
		$tableHtml = $table->getTableHtml();

		$checkArray = split(">1<", $tableHtml);
		$this->assertEquals(count($checkArray), 2);
		$checkArray = split(">3<", $tableHtml);
		$this->assertEquals(count($checkArray), 2);

		$table->initializePager(2, 1);
		$tableHtml = $table->getTableHtml();

		$checkArray = split(">2<", $tableHtml);
		$this->assertEquals(count($checkArray), 2);
	}

	public function testGetTableText(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");

		$table = new JetTable();
		$table->setData($list);
		$tableText = $table->getTableText();

		$checkArray = split(">", $tableText);
		$this->assertEquals(count($checkArray), 1);

		$checkArray = split("<", $tableHtml);
		$this->assertEquals(count($tableText), 1);
	}

	public function testInitialize(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");

		$table = new JetTable();
		$table->setData($list);
		$table->usePager(true);
		$table->usePlugin(true);
		$table->useSort(true);
		$request = array("page"=>"1","pagePar"=>"1","sortKey"=>"id", "sortType"=>"asc");
		$table->initialize($request);
		$tableHtml = $table->getTableHtml();

		$checkArray = split("page=1", $tableHtml);
		$this->assertEquals(count($checkArray), 4);
		$checkArray = split("pagePar=1", $tableHtml);
		$this->assertEquals(count($checkArray), 4);
		$checkArray = split("sortKey", $tableHtml);
		$this->assertEquals(count($checkArray), 4);
		$checkArray = split("sortType", $tableHtml);
		$this->assertEquals(count($checkArray), 4);
	}

	public function testFullStackInitialize(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");

		$table = new JetTable();
		$table->setData($list);
		$table->usePager(true);
		$table->usePlugin(true);
		$table->useSort(true);
		$request = array("page"=>"1","pagePar"=>"1","sortKey"=>"id", "sortType"=>"desc");
		$table->fullStackInitialize($request);
		$tableHtml = $table->getFullStackTableHtml();

		$checkArray = split("page=1", $tableHtml);
		$this->assertEquals(count($checkArray), 9);
		$checkArray = split("pagePar=1", $tableHtml);
		$this->assertEquals(count($checkArray), 9);
		$checkArray = split("sortKey", $tableHtml);
		$this->assertEquals(count($checkArray), 10);
		$checkArray = split("sortType", $tableHtml);
		$this->assertEquals(count($checkArray), 10);
		$checkArray = split("Plugin", $tableHtml);
		$this->assertEquals(count($checkArray), 2);
		$checkArray = split("Page", $tableHtml);
		$this->assertEquals(count($checkArray), 2);
		$checkArray = split("Item", $tableHtml);
		$this->assertEquals(count($checkArray), 2);
	}

	public function testMargeHeaderColumn(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");

		$table = new JetTable();
		$table->setData($list);
		$table->margeHeaderColumn("id", "2");
		$tableHtml = $table->getTableHtml();

		$checkArray = split("<th colspan=\"2\">id</th>", $tableHtml);
		$this->assertEquals(count($checkArray), 2);

		$checkArray = split("age", $tableHtml);
		$this->assertEquals(count($checkArray), 1);

		$checkArray = split("id", $tableHtml);
		$this->assertEquals(count($checkArray), 2);

		$checkArray = split("name", $tableHtml);
		$this->assertEquals(count($checkArray), 2);


		$table = new JetTable();
		$table->setData($list);

		$table->margeHeaderColumn(null, "2");
		$tableHtml = $table->getTableHtml();

		$checkArray = split("colspan=\"2\"", $tableHtml);
		$this->assertEquals(count($checkArray), 1);

		$table->margeHeaderColumn("id", null);
		$tableHtml = $table->getTableHtml();

		$checkArray = split("colspan=\"2\"", $tableHtml);
		$this->assertEquals(count($checkArray), 1);

		$table->margeHeaderColumn("id", 1);
		$tableHtml = $table->getTableHtml();

		$checkArray = split("colspan=\"2\"", $tableHtml);
		$this->assertEquals(count($checkArray), 1);

		$table->margeHeaderColumn("id", "test");
		$tableHtml = $table->getTableHtml();

		$checkArray = split("colspan=\"2\"", $tableHtml);
		$this->assertEquals(count($checkArray), 1);

		$table = new JetTable();
		$table->setData($list);

		$table->margeHeaderColumn("id", 3);
		$tableHtml = $table->getTableHtml();

		$checkArray = split("<th colspan=\"3\">id</th>", $tableHtml);
		$this->assertEquals(count($checkArray), 2);
	}

	public function testMargeColumnRow(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");
		$list[] = array("id"=>"04","age"=>"4","name"=>"d");

		$table = new JetTable();
		$table->setData($list);
		$table->margeColumnRow("id", "2");
		$tableHtml = $table->getTableHtml();

		$checkArray = split("<td rowspan=\"2\">", $tableHtml);
		$this->assertEquals(count($checkArray), 3);

		$table = new JetTable();
		$table->setData($list);

		$table->margeColumnRow(null, "2");
		$tableHtml = $table->getTableHtml();

		$checkArray = split("rowspan=\"2\"", $tableHtml);
		$this->assertEquals(count($checkArray), 1);

		$table->margeColumnRow("id", null);
		$tableHtml = $table->getTableHtml();

		$checkArray = split("rowspan=\"2\"", $tableHtml);
		$this->assertEquals(count($checkArray), 1);

		$table->margeColumnRow("id", 1);
		$tableHtml = $table->getTableHtml();

		$checkArray = split("rowspan=\"2\"", $tableHtml);
		$this->assertEquals(count($checkArray), 1);

		$table->margeColumnRow("id", "test");
		$tableHtml = $table->getTableHtml();

		$checkArray = split("rowspan=\"2\"", $tableHtml);
		$this->assertEquals(count($checkArray), 1);

		$table = new JetTable();
		$table->setData($list);

		$table->margeColumnRow("id", 4);
		$tableHtml = $table->getTableHtml();

		$checkArray = split("<td rowspan=\"4\">", $tableHtml);
		$this->assertEquals(count($checkArray), 2);
	}

	public function testSetRoundBackgroundColor(){
		$list = array();
		$list[] = array("id"=>"01","age"=>"3","name"=>"c");
		$list[] = array("id"=>"02","age"=>"2","name"=>"b");
		$list[] = array("id"=>"03","age"=>"1","name"=>"a");
		$list[] = array("id"=>"04","age"=>"4","name"=>"d");

		$table = new JetTable();
		$table->setData($list);
		$table->setRoundBackgroundColor("#ccffcc");
		$tableHtml = $table->getTableHtml();

		$checkArray = split("#ccffcc", $tableHtml);
		$this->assertEquals(count($checkArray), 1);

		$table->setRoundBackgroundColor(array("#ccffcc"));
		$tableHtml = $table->getTableHtml();

		$checkArray = split("#ccffcc", $tableHtml);
		$this->assertEquals(count($checkArray), 5);

		$table->setRoundBackgroundColor(array("#ccffcc", "#ffffff"));
		$tableHtml = $table->getTableHtml();

		$checkArray = split("#ccffcc", $tableHtml);
		$this->assertEquals(count($checkArray), 3);

		$checkArray = split("#ffffff", $tableHtml);
		$this->assertEquals(count($checkArray), 3);

		$table->setRoundBackgroundColor(array("#cfc", "#fff"));
		$tableHtml = $table->getTableHtml();

		$checkArray = split("#cfc", $tableHtml);
		$this->assertEquals(count($checkArray), 3);

		$checkArray = split("#fff", $tableHtml);
		$this->assertEquals(count($checkArray), 3);
	}

	public function testSetDateFormatColumn(){
		$list = array();
		$list[] = array("id"=>"01","date"=>"2006-01-01", "update"=>"2004/11/02");
		$list[] = array("id"=>"02","date"=>"2006/01/01");
		$list[] = array("id"=>"03","date"=>"20060101");

		$table = new JetTable();
		$table->setData($list);
		$table->setDateFormatColumn("date", "Yǯmd");
		$tableHtml = $table->getTableHtml();

		$checkArray = split("2006ǯ0101", $tableHtml);
		$this->assertEquals(count($checkArray), 4);

		$table->setDateFormatColumn("update", "Ymd");
		$tableHtml = $table->getTableHtml();

		$checkArray = split("2006ǯ0101", $tableHtml);
		$this->assertEquals(count($checkArray), 4);

		$checkArray = split("20041102", $tableHtml);
		$this->assertEquals(count($checkArray), 2);
	}
}
?>
