<?php
require_once 'PHPUnit2/Framework/TestCase.php';
require_once "../jettable/JetSelectBoxDataCell.class.php";

class JetSelectBoxDataCellTest extends PHPUnit2_Framework_TestCase {

    public function __construct($name = false)
    {
        parent::__construct($name);
    }

    function setUp()
    {
    }

    function tearDown()
    {
    }

    function testEmptyInitialize()
    {
		$dataCell = new JetSelectBoxDataCell(null);
		$result = $dataCell->getHtml();
		$this->assertEquals($result, null);
    }

    function testValueInitialize()
    {
		$dataCell = new JetSelectBoxDataCell("aiueo");
		$result = $dataCell->getHtml();
		$this->assertEquals($result, null);
    }

    function testValueAttributeInitialize()
    {
		$dataCell = new JetSelectBoxDataCell("10,000", array("a"=>"b", "c"=>"d"));
		$result = $dataCell->getHtml();
		$this->assertEquals($result, null);
    }

    function testValueAttributeArrayInitialize()
    {
		$dataCell = new JetSelectBoxDataCell("10,000", array("a"=>"b", "c"=>"d"), array("e"=>"e", "f"=>"f", "g"=>"g"));
		$result = $dataCell->getHtml();
$select=<<<EOF
<select a="b" c="d"><option value="0"></option><option value="1">e</option><option value="2">f</option><option value="3">g</option></select>
EOF;
		$this->assertEquals($result, $select);
    }

    function testValueAttributeArraySelectedInitialize()
    {
		$dataCell = new JetSelectBoxDataCell("f", array("a"=>"b", "c"=>"d"), array("e"=>"e", "f"=>"f", "g"=>"g"));
		$result = $dataCell->getHtml();
$select=<<<EOF
<select a="b" c="d"><option value="0"></option><option value="1">e</option><option value="2" selected >f</option><option value="3">g</option></select>
EOF;
		$this->assertEquals($result, $select);
    }
}
?>
