<?php
require_once 'PHPUnit2/Framework/TestCase.php';
require_once "../jettable/JetRadioButtonDataCell.class.php";

class JetRadioButtonDataCellTest extends PHPUnit2_Framework_TestCase {

    public function __construct($name = false)
    {
        parent::__construct($name);
    }

    function setUp()
    {
    }

    function tearDown()
    {
    }

    function testEmptyInitialize()
    {
		$dataCell = new JetRadioButtonDataCell(null);
		$result = $dataCell->getHtml();
		$this->assertEquals($result, "<input type=\"radio\" name=\"hatena\">");
    }

    function testValueInitialize()
    {
		$dataCell = new JetRadioButtonDataCell("aiueo");
		$result = $dataCell->getHtml();
		$this->assertEquals($result, "<input type=\"radio\" name=\"hatena\">");
    }

    function testValueAttributeInitialize()
    {
		$dataCell = new JetRadioButtonDataCell("10,000", array("a"=>"b", "c"=>"d"));
		$result = $dataCell->getHtml();
		$this->assertEquals($result, "<input type=\"radio\" name=\"hatena\">");
    }

    function testValueAttributeArrayInitialize()
    {
		$dataCell = new JetRadioButtonDataCell("10,000", array("a"=>"b", "c"=>"d"), array("e"=>"e", "f"=>"f", "g"=>"g"));
		$result = $dataCell->getHtml();
		$this->assertEquals($result, "<input type=\"radio\" name=\"hatena\">");
    }

    function testValueAttributeArraySelectedInitialize()
    {
		$dataCell = new JetRadioButtonDataCell("f", array("a"=>"b", "c"=>"d"), array("e"=>"e", "f"=>"f", "g"=>"g"));
		$result = $dataCell->getHtml();
		$this->assertEquals($result, "<input type=\"radio\" name=\"hatena\">");
    }
}
?>
