<?php
require_once 'PHPUnit2/Framework/TestCase.php';
require_once "../jettable/JetPager.class.php";

class JetPagerTest extends PHPUnit2_Framework_TestCase {

    public function __construct($name = false)
    {
        parent::__construct($name);
    }

    function setUp()
    {
    }

    function tearDown()
    {
    }

    function testInitialize()
    {
		$pager = new JetPager();

		$this->assertEquals($pager->getCurrentPageNumber(), 1);
		$this->assertEquals($pager->getMaxPage(), 0);
		$this->assertEquals($pager->getViewMaxPage(), 0);
		$this->assertEquals($pager->getViewMinPage(), 0);
		$this->assertNull($pager->getBasicPagerHtml());

		$pager = new JetPager();
		$pager->setTotalItemCount(10);
		$this->assertEquals($pager->getCurrentPageNumber(), 1);
		$this->assertEquals($pager->getMaxPage(), 1);
		$this->assertEquals($pager->getViewMaxPage(), 1);
		$this->assertEquals($pager->getViewMinPage(), 1);
		$this->assertNotNull($pager->getBasicPagerHtml());

		$pager->setTotalItemCount(100);
		$this->assertEquals($pager->getCurrentPageNumber(), 1);
		$this->assertEquals($pager->getMaxPage(), 10);
		$this->assertEquals($pager->getViewMaxPage(), 10);
		$this->assertEquals($pager->getViewMinPage(), 1);
		$this->assertNotNull($pager->getBasicPagerHtml());

		$pager->setTotalItemCount("abc");
		$this->assertEquals($pager->getCurrentPageNumber(), 1);
		$this->assertEquals($pager->getMaxPage(), 0);
		$this->assertEquals($pager->getViewMaxPage(), 0);
		$this->assertEquals($pager->getViewMinPage(), 0);
		$this->assertNull($pager->getBasicPagerHtml());
    }

	function testSetGetTotalItemCount(){
		$pager = new JetPager();
		$this->assertEquals($pager->getTotalItemCount(), 0);

		$pager->setTotalItemCount(10);
		$this->assertEquals($pager->getTotalItemCount(), 10);

		$pager->setTotalItemCount(100);
		$this->assertEquals($pager->getTotalItemCount(), 100);
	}

	function testSetGetPageParItems(){
		$pager = new JetPager();
		$this->assertEquals($pager->getPageParItems(), 10);

		$pager->setPageParItems(10);
		$this->assertEquals($pager->getPageParItems(), 10);

		$pager->setPageParItems(100);
		$this->assertEquals($pager->getPageParItems(), 100);
	}

	function testSetGetCurrentPageNumber(){
		$pager = new JetPager();
		$this->assertEquals($pager->getCurrentPageNumber(), 1);

		$pager->setCurrentPageNumber(10);
		$this->assertEquals($pager->getCurrentPageNumber(), 10);

		$pager->setCurrentPageNumber(100);
		$this->assertEquals($pager->getCurrentPageNumber(), 100);
	}

	function testGetMaxPage(){
		$pager = new JetPager();
		$pager->setTotalItemCount(0);
		$this->assertEquals($pager->getMaxPage(), 0);
		$pager->setTotalItemCount(1);
		$this->assertEquals($pager->getMaxPage(), 1);
		$pager->setTotalItemCount(100);
		$this->assertEquals($pager->getMaxPage(), 10);
		$pager->setTotalItemCount(256);
		$this->assertEquals($pager->getMaxPage(), 26);
		$pager->setTotalItemCount(1000);
		$this->assertEquals($pager->getMaxPage(), 100);
	}

	function testGetViewMaxPage(){
		$pager = new JetPager();
		$pager->setTotalItemCount(0);
		$this->assertEquals($pager->getViewMaxPage(), 0);

		$pager->setTotalItemCount(100);
		$pager->setCurrentPageNumber(20);
		$this->assertEquals($pager->getViewMaxPage(), 10);

		$pager->setTotalItemCount(1000);
		$pager->setCurrentPageNumber(20);
		$this->assertEquals($pager->getViewMaxPage(), 24);

		$pager->setTotalItemCount(1000);
		$pager->setCurrentPageNumber(95);
		$this->assertEquals($pager->getViewMaxPage(), 99);

		$pager->setTotalItemCount(1000);
		$pager->setCurrentPageNumber(96);
		$this->assertEquals($pager->getViewMaxPage(), 100);

		$pager->setTotalItemCount(1000);
		$pager->setCurrentPageNumber(97);
		$this->assertEquals($pager->getViewMaxPage(), 100);
	}

	function testGetViewMinPage(){
		$pager = new JetPager();
		$pager->setTotalItemCount(0);
		$this->assertEquals($pager->getViewMinPage(), 0);

		$pager->setTotalItemCount(100);
		$pager->setCurrentPageNumber(20);
		$this->assertEquals($pager->getViewMinPage(), 1);

		$pager->setTotalItemCount(1000);
		$pager->setCurrentPageNumber(20);
		$this->assertEquals($pager->getViewMinPage(), 15);

		$pager->setTotalItemCount(1000);
		$pager->setCurrentPageNumber(95);
		$this->assertEquals($pager->getViewMinPage(), 90);

		$pager->setTotalItemCount(1000);
		$pager->setCurrentPageNumber(96);
		$this->assertEquals($pager->getViewMinPage(), 91);

		$pager->setTotalItemCount(1000);
		$pager->setCurrentPageNumber(97);
		$this->assertEquals($pager->getViewMinPage(), 91);

		$pager->setTotalItemCount(1000);
		$pager->setCurrentPageNumber(100);
		$this->assertEquals($pager->getViewMinPage(), 91);
	}

	function testGetBasicPagerHtml(){
		$pager = new JetPager();
		$pager->setCurrentPageNumber("a");
		$this->assertNull($pager->getBasicPagerHtml());
		$pager->setCurrentPageNumber(0);
		$this->assertNull($pager->getBasicPagerHtml());
	}
}
?>
