<?php
require_once 'PHPUnit2/Framework/TestCase.php';
require_once "../jettable/JetHtmlUtil.class.php";

class JetHtmlUtilTest extends PHPUnit2_Framework_TestCase {

    public function __construct($name = false)
    {
        parent::__construct($name);
    }

    function setUp()
    {
    }

    function tearDown()
    {
    }

    function testJoinTagAttribute(){
		$result = JetHtmlUtil::joinTagAttribute("<span>", "class", "testclass");
		$this->assertEquals($result, "<span class=\"testclass\">");

		$result2 = JetHtmlUtil::joinTagAttribute("<span>",null,null);
		$this->assertEquals($result2, "<span>");

		$result3 = JetHtmlUtil::joinTagAttribute("", "class", "testclass");
		$this->assertEquals($result3, "");
    }

    function testCreateSelectBox()
    {
		$selectArray = array("a"=>"a", "b"=>"b", "c"=>"c", "d"=>"d");
		$result = JetHtmlUtil::createSelectBox($selectArray, "b", array());
$select=<<<EOF
<select><option value="0"></option><option value="1">a</option><option value="2" selected >b</option><option value="3">c</option><option value="4">d</option></select>
EOF;
		$this->assertEquals($result, $select);

		$result = JetHtmlUtil::createSelectBox($selectArray, "b", array("a"=>"b", "c"=>"d"));
$select=<<<EOF
<select a="b" c="d"><option value="0"></option><option value="1">a</option><option value="2" selected >b</option><option value="3">c</option><option value="4">d</option></select>
EOF;
		$this->assertEquals($result, $select);
    }

}
?>
