<?php
require_once 'PHPUnit2/Framework/TestCase.php';
require_once "../jettable/JetDateFormatter.class.php";

class JetDateFormatterTest extends PHPUnit2_Framework_TestCase {

    public function __construct($name = false)
    {
        parent::__construct($name);
    }

    function setUp()
    {
    }

    function tearDown()
    {
    }

    function testFormat()
    {
		$formatter = new JetDateFormatter();
		$formatString = $formatter->format("2006-01-01");
		$this->assertEquals($formatString, "2006-01-01");

		$formatter = new JetDateFormatter("Y/m/d");
		$formatString = $formatter->format(null);
		$this->assertNull($formatString);

		$formatter = new JetDateFormatter("Y/m/d");
		$formatString = $formatter->format("2006-01-01");
		$this->assertEquals($formatString, "2006/01/01");

		$formatter = new JetDateFormatter("Yǯmd");
		$formatString = $formatter->format("2006-01-31");
		$this->assertEquals($formatString, "2006ǯ0131");

		$formatter = new JetDateFormatter("Yǯmd");
		$formatString = $formatter->format("20060131");
		$this->assertEquals($formatString, "2006ǯ0131");
    }

}
?>
