<?php
require_once 'PHPUnit2/Framework/TestCase.php';
require_once "../jettable/JetCheckBoxDataCell.class.php";

class JetCheckBoxDataCellTest extends PHPUnit2_Framework_TestCase {

    public function __construct($name = false)
    {
        parent::__construct($name);
    }

    function setUp()
    {
    }

    function tearDown()
    {
    }

    function testEmptyInitialize()
    {
		$dataCell = new JetCheckBoxDataCell(null);
		$result = $dataCell->getHtml();
		$this->assertEquals($result, "<input type=\"checkbox\">");
    }

    function testValueInitialize()
    {
		$dataCell = new JetCheckBoxDataCell("aiueo");
		$result = $dataCell->getHtml();
		$this->assertEquals($result, "<input type=\"checkbox\">");
    }

    function testValueAttributeInitialize()
    {
		$dataCell = new JetCheckBoxDataCell("10,000", array("a"=>"b", "c"=>"d"));
		$result = $dataCell->getHtml();
		$this->assertEquals($result, "<input type=\"checkbox\">");
    }

    function testValueAttributeArrayInitialize()
    {
		$dataCell = new JetCheckBoxDataCell("10,000", array("a"=>"b", "c"=>"d"), array("e"=>"e", "f"=>"f", "g"=>"g"));
		$result = $dataCell->getHtml();
		$this->assertEquals($result, "<input type=\"checkbox\">");
    }

    function testValueAttributeArraySelectedInitialize()
    {
		$dataCell = new JetCheckBoxDataCell("f", array("a"=>"b", "c"=>"d"), array("e"=>"e", "f"=>"f", "g"=>"g"));
		$result = $dataCell->getHtml();
		$this->assertEquals($result, "<input type=\"checkbox\">");
    }
}
?>
