<?php
require_once "JetPager.class.php";
require_once "JetAttribute.class.php";
require_once "JetAttributeColumn.class.php";
require_once "JetAttributeColumnEreg.class.php";
require_once "JetRadioButtonDataCell.class.php";
require_once "JetCheckBoxDataCell.class.php";
require_once "JetSelectBoxDataCell.class.php";
require_once "JetTextBoxDataCell.class.php";
require_once "JetTextAreaDataCell.class.php";
require_once "JetLabelDataCell.class.php";
require_once "JetHtmlUtil.class.php";
require_once "JetCsvDownload.class.php";
require_once "JetExcelDownload.class.php";
require_once "JetDateFormatter.class.php";


/**
 * ơ֥ϥ饹<br>
 * ơ֥ϤΤΥᥤ󥯥饹
 *
 * @package    jettable.framework
 * @author     rds <tk@rasign.jp>
 * @license     http://www.opensource.org/licenses/mit-license.php The MIT License
 * @version    $Revision: 1.6 $ $Date: 2006/12/01 13:40:42 $
 * @link       http://jettable.rasign.jp/
 */
class JetTable{
	private $header;
	private $records;
	private $attribute;
	private $attributeRow;
	private $attributeColumn;
	private $attributeHeaderRow;
	private $attributeHeaderColumn;
	private $attributeColumnEreg;
	private $attributeRowEreg;

	private $formatter;

	private $margeHeaderColumn;
	private $margeColumnRow;

	private $attributeColumnAll;
	private $attributeHeaderColumnAll;

	private $useSort;
	private $sortKey;
	private $sortType;
	private $sortableHeaderKeys;

	private $usePager;
	private $pager;

	private $usePlugin;

	private $scriptName;

	private $plugin;

	private $outputForm;

	private $parameterPageString = "page";
	private $parameterPageParString = "pagePar";
	private $parameterSortKeyString = "sortKey";
	private $parameterSortTypeString = "sortType";
	private $parameterSortTypeAsc = "asc";
	private $parameterSortTypeDesc = "desc";
	private $sortTypeAscMarkString = "";
	private $sortTypeDescMarkString = "";
	private $rowidName = "rowidentifier";

	private $roundBackgroundColors;

    /**
     * ǥեȥ󥹥ȥ饯<br>
     * ѿνԤޤ<br>
     *
     * @access public
     */
	public function __construct(){
		$this->header = array();
		$this->records = array();
		$this->attribute = array();
		$this->attributeRow = array();
		$this->attributeColumn = array();
		$this->attributeColumnAll = array();
		$this->attributeHeaderRow = array();
		$this->attributeHeaderColumn = array();
		$this->attributeHeaderColumnAll = array();
		$this->attributeColumnEreg = array();
		$this->attributeRowEreg = array();
		$this->sortableHeaderKeys = array();
		$this->plugin = array();
		$this->margeHeaderColumn = array();
		$this->margeColumnRow = array();
		$this->roundBackgroundColors = array();
		$this->outputForm = array();
		$this->formatter = array();

		$this->useSort = false;
		$this->usePager = false;
		$this->usePlugin = false;

 		$this->scriptName = "";

		$this->pager = new JetPager();
	}

    /**
     * ơ֥Ф°ɲ<br>
     * TableФ°ɲäޤ<br>
     *
     * @param $key °ΥȤʤʸ
     * @param $value °
     * @access public
     */
	public function appendAttribute($key, $value){
		$attribute = new JetAttribute();
		$attribute->key = $key;
		$attribute->value = $value;
		$this->attribute[] = $attribute;
	}

    /**
     * إåԤФ°ɲ<br>
     * إåTRФ°ɲäޤ<br>
     *
     * @param $key °ΥȤʤʸ
     * @param $value °
     * @access public
     */
	public function appendAttributeHeaderRow($key, $value){
		$attributeHeaderRow = new JetAttribute();
		$attributeHeaderRow->key = $key;
		$attributeHeaderRow->value = $value;
		$this->attributeHeaderRow[] = $attributeHeaderRow;
	}

    /**
     * إåΥǡФ°ɲ<br>
     * إåTDФ°ɲäޤ<br>
     *
     * @param $columnName °Ϳ̾
     * @param $key °ΥȤʤʸ
     * @param $value °
     * @access public
     */
	public function appendAttributeHeaderColumn($columnName, $key, $value){
		$attributeHeaderColumn = new JetAttributeColumn();
		$attributeHeaderColumn->columnName = $columnName;
		$attributeHeaderColumn->key = $key;
		$attributeHeaderColumn->value = $value;
		$this->attributeHeaderColumn[] = $attributeHeaderColumn;
	}

    /**
     * ǡԤФ°ɲ<br>
     * ǡԤTRФ°ɲäޤ<br>
     *
     * @param $key °ΥȤʤʸ
     * @param $value °
     * @access public
     */
	public function appendAttributeRow($key, $value){
		$attributeRow = new JetAttribute();
		$attributeRow->key = $key;
		$attributeRow->value = $value;
		$this->attributeRow[] = $attributeRow;
	}

    /**
     * ǡФ°ɲ<br>
     * ǡԤTDФ°ɲäޤ<br>
     *
     * @param $columnName °Ϳ̾
     * @param $key °ΥȤʤʸ
     * @param $value °
     * @access public
     */
	public function appendAttributeColumn($columnName, $key, $value){
		$attributeColumn = new JetAttributeColumn();
		$attributeColumn->columnName = $columnName;
		$attributeColumn->key = $key;
		$attributeColumn->value = $value;
		$this->attributeColumn[] = $attributeColumn;
	}

    /**
     * ǡԤФ°ɲ<br>
     * ꤷɽоͤפ硢
     * ǡԤTRФ°ɲäޤ<br>
     *
     * @param $columnName °Ϳ̾
     * @param $ereg ɽ
     * @param $key °ΥȤʤʸ
     * @param $value °
     * @access public
     */
	public function appendAttributeRowEreg($columnName, $ereg, $key, $value){
		$attributeRowEreg = new JetAttributeColumnEreg();
		$attributeRowEreg->columnName = $columnName;
		$attributeRowEreg->key = $key;
		$attributeRowEreg->value = $value;
		$attributeRowEreg->ereg = $ereg;
		$this->attributeRowEreg[] = $attributeRowEreg;
	}

    /**
     * ǡФ°ɲ<br>
     * ꤷɽоͤפ硢
     * ǡԤTDФ°ɲäޤ<br>
     *
     * @param $columnName °Ϳ̾
     * @param $ereg ɽ
     * @param $key °ΥȤʤʸ
     * @param $value °
     * @access public
     */
	public function appendAttributeColumnEreg($columnName, $ereg, $key, $value){
		$attributeColumnEreg = new JetAttributeColumnEreg();
		$attributeColumnEreg->columnName = $columnName;
		$attributeColumnEreg->key = $key;
		$attributeColumnEreg->value = $value;
		$attributeColumnEreg->ereg = $ereg;
		$this->attributeColumnEreg[] = $attributeColumnEreg;
	}

    /**
     * ǡФ°ɲ<br>
     * ꤷ°򤹤٤ƤΥǡФͿޤ
     *
     * @param $key °ΥȤʤʸ
     * @param $value °
     * @access public
     */
	public function appendAttributeColumnAll($key, $value){
		$attribute = new JetAttribute();
		$attribute->key = $key;
		$attribute->value = $value;
		$this->attributeColumnAll[] = $attribute;
	}

    /**
     * إåԤΥǡФ°ɲ<br>
     * ꤷ°إåԤΤ٤ƤΥǡФͿޤ
     *
     * @param $key °ΥȤʤʸ
     * @param $value °
     * @access public
     */
	public function appendAttributeHeaderColumnAll($key, $value){
		$attribute = new JetAttribute();
		$attribute->key = $key;
		$attribute->value = $value;
		$this->attributeHeaderColumnAll[] = $attribute;
	}

    /**
     * ȵǽϤ̵ͭ<br>
     * ȵǽ̵ͭꤷޤ
     *
     * @param $useSort trueꤹȥȵǽѲǽˤʤޤ
     * @access public
     */
	public function useSort($useSort){
		$this->useSort = $useSort;
	}

    /**
     * ץ饰̵ͭ<br>
     * ץ饰̵ͭꤷޤ
     *
     * @param $useSort trueꤹȥץ饰Ѳǽˤʤޤ
     * @access public
     */
	public function usePlugin($usePlugin){
		$this->usePlugin = $usePlugin;
	}

    /**
     * ڡ󥰵ǽ̵ͭ<br>
     * ڡ󥰵ǽ̵ͭꤷޤ
     *
     * @param $usePager trueꤹȥڡ󥰵ǽѲǽˤʤޤ
     * @access public
     */
	public function usePager($usePager){
		$this->usePager = $usePager;
	}

    /**
     * λ<br>
     * ơ֥ΰʬΤߥȵǽͭˤѤޤ
     *
     * @param $headerKeys ȵǽѤ̾
     * @access public
     */
	public function setSortableHeader($headerKeys){
		if(is_array($headerKeys)){
			foreach($headerKeys as $headerKey){
				$this->sortableHeaderKeys[] = $headerKey;
			}
		}else{
			$this->sortableHeaderKeys[] = $headerKeys;
		}
	}

	private function sort(){
		$sortKey = $this->sortKey;
		if(!empty($sortKey)){
			$recordCount = count($this->records);
			for($i = 0; $i < $recordCount; $i++){
				$this->records[$i][$this->rowidName] = $i;
			}
			$sortArray = array();
			foreach($this->records as $record){
				$sortArray[$record[$this->rowidName]] = $record[$sortKey];
			}
			if($this->sortType == $this->parameterSortTypeAsc){
				asort($sortArray);
			}else{
				arsort($sortArray);
			}
			$sortRecords = array();
			foreach($sortArray as $sortKey=>$sortValue){
				foreach($this->records as $record){
					if($record[$this->rowidName] == $sortKey){
						unset($record[$this->rowidName]);
						$sortRecords[] = $record;
						break;
					}
				}
			}
			$this->records = $sortRecords;
		}
	}

    /**
     * ơ֥Υǡ<br>
     * ơ֥˽Ϥ뤿Υǡꤹ롣
     *
     * @param $records ǡ
     * @access public
     */
	public function setData($records){
		$this->records = $records;
		$this->pager->setTotalItemCount(count($records));
	}

    /**
     * ơ֥Υإå<br>
     * ơ֥Υإåͳꤹ롣
     *
     * @param $header Ϥإå
     * @access public
     */
	public function setHeader($header){
		$this->header = $header;
	}

    /**
     * Ⱦ֤<br>
     * ϻΥȾ֤ꤹ롣
     *
     * @param $sortKey ȥȤѤƤ̾
     * @param $sortType Ƚ(asc,desc,null)
     * @access public
     */
	public function initializeSort($sortKey, $sortType){
		$this->sortKey = $sortKey;
		$this->sortType = $sortType;
	}

    /**
     * ڡ󥰾֤<br>
     * ϻΥڡ󥰾֤ꤹ롣
     *
     * @param $currentPageNumber ɽڡֹ档
     * @param $pageParItems ڡɽ
     * @access public
     */
	public function initializePager($currentPageNumber, $pageParItems){
		if(!empty($currentPageNumber)){
			$this->pager->setCurrentPageNumber($currentPageNumber);
		}
		if(!empty($pageParItems)){
			$this->pager->setPageParItems($pageParItems);
		}
	}

    /**
     * եʽ<br>
     * ФƥեʤȤƽϤԤ
     *
     * @param $column оݤ̾
     * @param $type ʤμ(text|textarea|select)
     * @param $attribute ʤղä°
     * @access public
     */
	public function setOutputForm($column, $type, $attribute = array()){
		$this->outputForm[$column] = $type;
		$this->outputForm[$column . "Attribute"] = $attribute;
	}

    /**
     * եեޥåȽ<br>
     * ͤФեեޥåȤꤹ롣
     *
     * @param $column оݤ̾
     * @param $formatString եޥå
	 * @see PHPޥ˥奢 http://au3.php.net/date
     * @access public
     */
	public function setDateFormatColumn($column, $format){
		if(empty($column)){
			return;
		}

		$formatter = new JetDateFormatter($format);
		$this->formatter[$column] = $formatter;
	}

    /**
     * ƥȥơ֥<br>
     * ơ֥򥿥ֶڤƥȤȤɽޤ
     *
     * @access public
     */
	public function getTableText(){
		$records = $this->getRecords();
		if(empty($records)){
			return null;
		}
		$headerArray = $this->getHeaderArray($records);

		$text .= implode("\t", $headerArray);
		$text .= "\r\n";

		if($this->usePager){
			$records = $this->getViewRecords();
		}

		foreach($records as $record){
			foreach($headerArray as $headerKey=>$headerValue){
				$text .= $record[$headerKey];
				$text .= "\t";
			}
			$text .= "\r\n";
		}

		return $text;
	}

	private function getHeaderArray($records){
		if(empty($this->header)){
			$headerArray = array();
			foreach($records as $record){
				if(count($headerArray) < count($record)){
					$workHeaderArray = array();
					foreach($record as $itemKey=>$itemValue){
						$workHeaderArray[$itemKey] = $itemKey;
					}
					$headerArray = $workHeaderArray;
				}
			}
		}else{
			$headerArray = $this->header;
		}

		return $headerArray;
	}

	private function getUrlAttributeString(){
		$attributeArray = $this->getUrlAttribute();
		if(!empty($attributeArray)){
			foreach($attributeArray as $attribute){
				$attributeString .= "&" . $attribute->key . "=" . urlencode($attribute->value);
			}
		}
		return $attributeString;
	}

	private function getUrlAttribute(){
		$attributeArray = array();
		if($this->useSort){
			if(!empty($this->sortKey)){
				$attribute = new JetAttribute();
				$attribute->key = $this->parameterSortKeyString;
				$attribute->value = $this->sortKey;
				$attributeArray[] = $attribute;
			}
			if(!empty($this->sortType)){
				$attribute = new JetAttribute();
				$attribute->key = $this->parameterSortTypeString;
				$attribute->value = $this->sortType;
				$attributeArray[] = $attribute;
			}
		}
		if($this->usePager){
			$attribute = new JetAttribute();
			$attribute->key = $this->parameterPageString;
			$attribute->value = $this->pager->getCurrentPageNumber();
			$attributeArray[] = $attribute;

			$attribute = new JetAttribute();
			$attribute->key = $this->parameterPageParString;
			$attribute->value = $this->pager->getPageParItems();
			$attributeArray[] = $attribute;
		}
		return $attributeArray;
	}

    /**
     * ڡ󥰥󥯤μ<br>
     * ڡ󥰥󥯤֤ޤ
     *
     * @access public
     */
	public function getPagerHtml(){
		return $this->pager->getBasicPagerHtml($this->getUrlAttribute());
	}

	private function getRecords(){
		if(empty($this->records)){
			return array();
		}

		if($this->useSort){
			$this->sort();
		}

		return $this->records;
	}

	private function getViewRecords(){
		$records = $this->getRecords();

		if(empty($records)){
			return null;
		}

		if($this->usePager){
			$page = $this->pager->getCurrentPageNumber();
			$pageitem = $this->pager->getPageParItems();
			$startIndex = ($page - 1) * $pageitem;
			$endIndex = ($page - 1) * $pageitem + $pageitem - 1;
		}else{
			$endIndex = 999999;
		}

		$viewRecordArray = array();
		$i = 0;
		foreach($records as $record){
			if($i >= $startIndex && $i <= $endIndex){
				$viewRecordArray[] = $record;
			}
			$i = $i + 1;
		}
		return $viewRecordArray;
	}

    /**
     * ơ֥HTMLɤμ<br>
     * ߤξ֤ǥơ֥ѤHTMLɤ֤ޤ
     *
     * @access public
     */
	public function getTableHtml(){
		$records = $this->getRecords();
		if(empty($records)){
			return null;
		}

		$tableTag .= "<table>";
		foreach($this->attribute as $attributeClass){
			$tableTag = JetHtmlUtil::joinTagAttribute($tableTag, $attributeClass->key, $attributeClass->value);
		}
		$text .= $tableTag;

		$trTag .= "<tr>";
		foreach($this->attributeHeaderRow as $attributeHeaderRowClass){
			$trTag = JetHtmlUtil::joinTagAttribute($trTag, $attributeHeaderRowClass->key, $attributeHeaderRowClass->value);
		}
		$text .= $trTag;

		$headerArray = $this->getHeaderArray($records);

		$margeCount = 0;
		foreach($headerArray as $headerKey=>$headerValue){
			if($margeCount > 0){
				$margeCount = $margeCount - 1;
				continue;
			}

			$tdTag = "<th>";
			if(!empty($this->margeHeaderColumn)){
				foreach($this->margeHeaderColumn as $margeHeaderColumnName=>$margeHeaderColumnCount){
					if($margeHeaderColumnName == $headerKey){
						$tdTag = JetHtmlUtil::joinTagAttribute($tdTag, "colspan", $margeHeaderColumnCount);
						$margeCount = $margeHeaderColumnCount - 1;
					}
				}
			}

			foreach($this->attributeHeaderColumnAll as $attributeHeaderColumnAllClass){
				$tdTag = JetHtmlUtil::joinTagAttribute($tdTag, $attributeHeaderColumnAllClass->key, $attributeHeaderColumnAllClass->value);
			}

			foreach($this->attributeHeaderColumn as $attributeHeaderColumnClass){
				if($headerKey == $attributeHeaderColumnClass->columnName){
					$tdTag = JetHtmlUtil::joinTagAttribute($tdTag, $attributeHeaderColumnClass->key, $attributeHeaderColumnClass->value);
				}
			}

			if($this->useSort){
				if(!empty($this->sortableHeaderKeys) && !in_array($headerKey, $this->sortableHeaderKeys)){
					$text .= $tdTag;
					$text .= $headerValue;
					continue;
				}

				$outputFormKey = array_keys($this->outputForm);
				if(in_array($headerKey, $outputFormKey)){
					$text .= $tdTag;
					$text .= $headerValue;
					continue;
				}

				$urlSortKey = urlencode($headerValue);
				if($headerValue == $this->sortKey){
					if($this->sortType == $this->parameterSortTypeAsc){
						$urlSortType = $this->parameterSortTypeDesc;
					}else if($this->sortType == $this->parameterSortTypeDesc){
						$urlSortType = "";
						$urlSortKey = "";
					}else{
						$urlSortType = $this->parameterSortTypeAsc;
					}
				}else{
						$urlSortType = $this->parameterSortTypeAsc;
				}
				$text .= $tdTag . "<a href=\"" . $this->scriptName . "?";
				if($this->usePager){
					$text .= "&" . $this->parameterPageString . "=" . $this->pager->getCurrentPageNumber();
					$text .= "&" . $this->parameterPageParString . "=" . $this->pager->getPageParItems();
				}
				if(!empty($urlSortKey)){
					$text .= "&" . $this->parameterSortKeyString . "=" . $urlSortKey;
				}
				if(!empty($urlSortType)){
					$text .= "&" . $this->parameterSortTypeString . "=" . $urlSortType;
				}
				$text .= "\">";
				$text .= $headerValue;
				$text .= "</a>";

				if($headerValue == $this->sortKey){
					if(empty($this->sortType) || $this->sortType == $this->parameterSortTypeAsc){
						$text .= "&nbsp;" . $this->sortTypeAscMarkString;
					}else if($this->sortType == $this->parameterSortTypeDesc){
						$text .= "&nbsp;" . $this->sortTypeDescMarkString;
					}
				}

			}else{
				$text .= $tdTag;
				$text .= $headerValue;
			}
			$text .= "</th>";
		}
		$text .= "</tr>";
		if($this->usePager){
			$records = $this->getViewRecords();
		}

		$rowColorIndex = 0;
		$rowspanWorkArray = array();
		$rowId = 0;
		foreach($records as $record){
			$rowId++;
			$trTag = "<tr>";

			if(!empty($this->roundBackgroundColors)){
				$trTag = JetHtmlUtil::joinTagAttribute($trTag, "style", "background-color:" . $this->roundBackgroundColors[$rowColorIndex]);
				$rowColorIndex++;
				if($rowColorIndex >= count($this->roundBackgroundColors)){
					$rowColorIndex = 0;
				}
			}
			
			foreach($this->attributeRowEreg as $attributeRowEregClass){
				foreach($headerArray as $headerKey=>$headerValue){
					if($headerKey == $attributeRowEregClass->columnName){
						if(mbereg($attributeRowEregClass->ereg, $record[$headerKey])){
							$trTag = JetHtmlUtil::joinTagAttribute($trTag, $attributeRowEregClass->key, $attributeRowEregClass->value);
						}
					}
				}
			}

			foreach($this->attributeRow as $attributeRowClass){
				$trTag = JetHtmlUtil::joinTagAttribute($trTag, $attributeRowClass->key, $attributeRowClass->value);
			}
			$text .= $trTag;

			foreach($headerArray as $headerKey=>$headerValue){
				$tdTag = "<td>";
				foreach($this->attributeColumnAll as $attributeColumnAllClass){
					$tdTag = JetHtmlUtil::joinTagAttribute($tdTag, $attributeColumnAllClass->key, $attributeColumnAllClass->value);
				}
				
				foreach($this->attributeColumnEreg as $attributeColumnEregClass){
					if($headerKey == $attributeColumnEregClass->columnName){
						if(mbereg($attributeColumnEregClass->ereg, 	$record[$headerKey])){
							$tdTag = JetHtmlUtil::joinTagAttribute($tdTag, $attributeColumnEregClass->key, $attributeColumnEregClass->value);
						}
					}
				}
				foreach($this->attributeColumn as $attributeColumnClass){
					if($headerKey == $attributeColumnClass->columnName){
						$tdTag = JetHtmlUtil::joinTagAttribute($tdTag, $attributeColumnClass->key, $attributeColumnClass->value);
					}
				}

				if($rowspanWorkArray[$headerKey] < 2){
					$margeColumnKey = array_keys($this->margeColumnRow);
					if(in_array($headerKey, $margeColumnKey)){
						$rowspanWorkArray[$headerKey] = $this->margeColumnRow[$headerKey];
						$tdTag = JetHtmlUtil::joinTagAttribute($tdTag, "rowspan", $rowspanWorkArray[$headerKey]);
					}

					$text .= $tdTag;

					$outputForm = $this->outputForm[$headerKey];
					$outputFormAttribute = $this->outputForm[$headerKey . "Attribute"];
					if(empty($outputFormAttribute)){
						$outputFormAttribute = array();
					}
					$dataCellValue = $this->formatValue($headerKey, $record[$headerKey]);
					$text .= $this->outputDataCell($outputForm, $dataCellValue, $outputFormAttribute, $headerKey);

				}else{
					$rowspanWorkArray[$headerKey] = $rowspanWorkArray[$headerKey] - 1;
				}
			}
			$text .= "</tr>";
		}
		$text .= "</table>";

		return $text;
	}

	private function formatValue($key, $value){
		if(empty($value)){
			return null;
		}
		if(empty($key)){
			return $value;
		}

		$formatter = $this->formatter[$key];
		if(empty($formatter)){
			return $value;
		}

		return $formatter->format($value);
	}

    /**
     * ꥹȤμ<br>
     * 쥳ɤꤷȴФơ֤ޤ<br>
     *
     * @param $columnName оݤ̾
     * @return ꤷ
     * @access public
     */
	private function getColulmnList($columnName){
		if(empty($columnName)){
			return null;
		}
		$records = $this->getRecords();
		if(empty($records)){
			return null;
		}

		$list = array();
		foreach($records as $record){
			if(empty($record[$columnName])){
				continue;
			}
			$list[$record[$columnName]] = $record[$columnName];
		}
		return $list;
	}

    /**
     * եHTMLɤμ<br>
     * Ϥ줿бեѤHTMLɤ֤ޤ<br>
     *
     * @param $key ϥ(text,textarea,select)
     * @param $value Ϥ
     * @param $attribute ղä°Ϣ
     * @param $columnName оݤ̾
     * @access public
     */
	private function outputDataCell($key, $value, $attribute = array(), $columnName = null){
		if($key == "text"){
			$dataCell = new JetTextBoxDataCell($value, $attribute);

		}else if($key == "textarea"){
			$dataCell = new JetTextAreaDataCell($value, $attribute);

		}else if($key == "select"){
			$dataCell = new JetSelectBoxDataCell($value, $attribute, $this->getColulmnList($columnName));

		}else if($key == "checkbox"){
			$dataCell = new JetCheckBoxDataCell($value, $attribute);

		}else if($key == "radio"){
			$dataCell = new JetRadioButtonDataCell($value, $attribute);

		}else{
			$dataCell = new JetLabelDataCell($value);
		}

		return $dataCell->getHtml();
	}

    /**
     * ơ֥HTMLɤμ<br>
     * ٤ƤεǽѤơ֥ѤHTMLɤ֤ޤ<br>
     * Ϥ뵡ǽ<br>
     * ڡ<br>
     * <br>
     * ץ饰<br>
     * Ƶǽѥե饰ξ֤˰¸ޤ
     *
     * @access public
     */
	public function getFullStackTableHtml(){
		$records = $this->getRecords();
		if(empty($records)){
			return null;
		}

		if($this->usePager){
			$text .= $this->getPagerHtml();
		}

		if($this->usePlugin){
			$text .= "&nbsp;";
			$text .= "&nbsp;";
			$text .= "&nbsp;";
			$text .= "Plugin:";
		}
		foreach($this->plugin as $plugin){
			$text .= "&nbsp;";
			$text .= $plugin->getLinkTag($this->getUrlAttributeString(), $this->scriptName);
		}

		$text .= $this->getTableHtml();

		return $text;
	}

    /**
     * ᥽å<br>
	 * ꥯȥѥ᡼Ѥƥ֥Ȥޤ
     *
     * @param request ɬפʥѥ᡼ޤ󡣤ޤphp$_REQUEST.
     * @access public
     */
     public function initialize($request){
		$this->scriptName = basename($_SERVER["SCRIPT_NAME"]);

		if($this->usePager){
			$currentPage = $request{$this->parameterPageString};
			$pagePar = $request{$this->parameterPageParString};
			$this->initializePager($currentPage, $pagePar);
		}

		if($this->useSort){
			$urlencodeSortKey = $request{$this->parameterSortKeyString};
			$sortKey = urldecode($urlencodeSortKey);
			$sortType = $request{$this->parameterSortTypeString};
			if(!empty($sortKey)){
				$this->initializeSort($sortKey, $sortType);
			}
		}

		if($this->usePlugin){
			$this->plugin = $this->initializePlugin();
			$this->doPlugin($request{"logic"});
		}
	}

    /**
     * ᥽å<br>
	 * ꥯȥѥ᡼Ѥƥ֥Ȥޤ<br>
	 * 礷Ƥ٤Ƥεǽޤ
     *
     * @param request ɬפʥѥ᡼ޤ󡣤ޤphp$_REQUEST.
     * @access public
     */
	public function fullStackInitialize($request){
		$this->scriptName = basename($_SERVER["SCRIPT_NAME"]);

		$currentPage = $request{$this->parameterPageString};
		$pagePar = $request{$this->parameterPageParString};

		$urlencodeSortKey = $request{$this->parameterSortKeyString};
		$sortKey = urldecode($urlencodeSortKey);
		$sortType = $request{$this->parameterSortTypeString};

		$this->useSort(true);
		$this->usePager(true);
		$this->usePlugin(true);

		$this->initializePager($currentPage, $pagePar);

		if(!empty($sortKey)){
			$this->initializeSort($sortKey, $sortType);
		}

		if($this->usePlugin){
			$this->plugin = $this->initializePlugin();
			$this->doPlugin($request{"logic"});
		}
	}

	// @todo
	private function initializePlugin(){
		$plugin = array();

		$plugin[] = new JetCsvDownload();
		$plugin[] = new JetExcelDownload();

		return $plugin;
	}
	
    /**
     * إåηԤ<br>
	 * ꤷإå顢ꤷηԤޤ<br>
     *
     * @param $columnName ̾
     * @param $margeCount 礹
     * @access public
     */
	public function margeHeaderColumn($columnName, $margeCount){
		if(empty($columnName)){
			return;
		}

		if(empty($margeCount)){
			return;
		}

		if($margeCount < 2){
			return;
		}

		if(!is_numeric($margeCount)){
			return;
		}

		$this->margeHeaderColumn[$columnName] = $margeCount;
	}

    /**
     * إåηԤ<br>
	 * ꤷإå顢ꤷηԤޤ<br>
     *
     * @param $columnName ̾
     * @param $margeCount 礹
     * @access public
     */
	public function margeColumnRow($columnName, $margeCount){
		if(empty($columnName)){
			return;
		}

		if(empty($margeCount)){
			return;
		}

		if($margeCount < 2){
			return;
		}

		if(!is_numeric($margeCount)){
			return;
		}

		$this->margeColumnRow[$columnName] = $margeCount;
	}

	private function doPlugin($logic){
		if(empty($logic)){
			return;
		}

		foreach($this->plugin as $plugin){
			if($plugin->key == $logic){
				$records = $this->getRecords();
				$header = $this->getHeaderArray($records);
				$plugin->action($header, $records);
				return;
			}
		}
	}

    /**
     * ǡԤطʿ<br>
     * ơ֥ΥǡԤФطʿꤷޤ<br>
     * ꤵ줿ԤϤ뤿˷֤ꤷޤ<br>
     *
     * @param $roundBackgroundColors ʸɤ
     * @access public
     */
	public function setRoundBackgroundColor($roundBackgroundColors){
		$this->roundBackgroundColors = $roundBackgroundColors;
	}
}
?>