<?php
/**
 * ڡ󥰵ǽϥ饹<br>
 * ڡ󥰵ǽϤ륯饹
 *
 * @package    jettable.framework
 * @author     rds <tk@rasign.jp>
 * @license     http://www.opensource.org/licenses/mit-license.php The MIT License
 * @version    $Revision: 1.2 $ $Date: 2006/11/30 13:54:29 $
 * @link       http://jettable.rasign.jp/
 */
class JetPager{
	private $currentPageNumber;
	private $pageParItems;
	private $totalItemCount;
	private $viewPageLinks;
	private $pageParItemType;
	private $scriptName;

	private $parameterPageString = "page";
	private $parameterPageParString = "pagePar";

    /**
     * ǥեȥ󥹥ȥ饯<br>
     * ѿνԤޤ<br>
     *
     * @param $currentPageNumber ߤΥڡֹ
     * @param $pageParItems ڡΥƥʹԡ˿
     * @param $viewPageLinks ڡɽ
     * @param $scriptName 襹ץ̾
     * @access public
     */
	public function __construct(
			$currentPageNumber = 1, 
			$pageParItems = 10, 
			$viewPageLinks = 10,
			$scriptName = null){
		$this->currentPageNumber = $currentPageNumber;
		$this->pageParItems = $pageParItems;
		$this->viewPageLinks = $viewPageLinks;
		$this->scriptName = $scriptName;
		
		$this->pageParItemType = array("10"=>"10", "30"=>"30", "50"=>"50");
		$this->setTotalItemCount(0);
	}

    /**
     * <br>
     * ƥꤷޤ<br>
     *
     * @param $totalItemCount 
     * @access public
     */
	public function setTotalItemCount($totalItemCount){
		$this->totalItemCount = $totalItemCount;
	}

    /**
     * <br>
     * ƥޤ<br>
     *
     * @return 
     * @access public
     */
	public function getTotalItemCount(){
		return $this->totalItemCount;
	}

    /**
     * ڡ⥢ƥ<br>
     * ڡɽ륢ƥʹԡˤηꤷޤ<br>
     *
     * @param $pageParItems 
     * @access public
     */
	public function setPageParItems($pageParItems){
		$this->pageParItems = $pageParItems;
	}

    /**
     * ڡ⥢ƥ<br>
     * ڡɽ륢ƥʹԡˤηޤ<br>
     *
     * @return 
     * @access public
     */
	public function getPageParItems(){
		return $this->pageParItems;
	}

    /**
     * ߥڡ<br>
     * ɽΥڡֹꤷޤ<br>
     *
     * @param $currentPageNumber ڡֹ
     * @access public
     */
	public function setCurrentPageNumber($currentPageNumber){
		$this->currentPageNumber = $currentPageNumber;
	}

    /**
     * ߥڡ<br>
     * ɽΥڡֹޤ<br>
     *
     * @return ڡֹ
     * @access public
     */
	public function getCurrentPageNumber(){
		return $this->currentPageNumber;
	}

    /**
     * ڡֹ<br>
     * ڡֹޤ<br>
     *
     * @return ڡֹ
     * @access public
     */
    public function getMaxPage(){
		return ceil($this->totalItemCount / $this->pageParItems);
	}

    /**
     * ɽκڡֹ<br>
     * ɽκڡֹޤ<br>
     *
     * @return ɽκڡֹ
     * @access public
     */
	public function getViewMaxPage(){
		$page = $this->currentPageNumber;
		$totalPageCount = $this->getMaxPage();
		$startViewPageLink = $page - ceil($this->viewPageLinks / 2) - 1;
		$endViewPageLink = $page + ceil($this->viewPageLinks / 2) - 1;

		if($startViewPageLink < 1){
			$sa = 0 - $startViewPageLink;
			$startViewPageLink = 0;
			$endViewPageLink += $sa;
		}
		if($endViewPageLink > $totalPageCount){
			$sa = $endViewPageLink - $totalPageCount;
			$endViewPageLink = $totalPageCount;
			$startViewPageLink -= $sa;
		}
		return $endViewPageLink;
	}

    /**
     * ɽκǾڡֹ<br>
     * ɽκǾڡֹޤ<br>
     *
     * @return ɽκǾڡֹ
     * @access public
     */
	public function getViewMinPage(){
		$page = $this->currentPageNumber;
		$totalPageCount = $this->getMaxPage();
		if($totalPageCount < 1){
			return 0;
		}
		$startViewPageLink = $page - ceil($this->viewPageLinks / 2) - 1;
		$endViewPageLink = $page + ceil($this->viewPageLinks / 2) - 1;

		if($endViewPageLink > $totalPageCount){
			$sa = $endViewPageLink - $totalPageCount;
			$endViewPageLink = $totalPageCount;
			$startViewPageLink -= $sa;
		}
		if($startViewPageLink < 1){
			$sa = 0 - $startViewPageLink;
			$startViewPageLink = 0;
			$endViewPageLink += $sa;
		}
		return $startViewPageLink + 1;
	}

	public function getViewPageLinkCount(){
		return $this->viewPageLinks();
	}

    /**
     * ץʥڡ󥰥󥯼<br>
     * ץʥڡ󥰥󥯤Ϥ뤿ΥƥȤޤ<br>
     * <br>
     * 
     * <pre>
     * 1 2 3 4 5 6 7 8 9 10
     * </pre>
     *
     * @return ڡɽʸ(HTML)
     * @access public
     */
	public function getBasicPagerHtml($attributeArray = array()){
		$page = $this->currentPageNumber;
		if(!is_numeric($page)){
			return null;
		}
		if($page < 1){
			return null;
		}

		$totalPageCount = $this->getMaxPage();
		if(!is_numeric($totalPageCount)){
			return null;
		}
		if($totalPageCount < 1){
			return null;
		}

		$startViewPageLink = $this->getViewMinPage();
		if(!is_numeric($startViewPageLink)){
			return null;
		}
		if($startViewPageLink < 1){
			return null;
		}

		$endViewPageLink = $this->getViewMaxPage();
		if(!is_numeric($endViewPageLink)){
			return null;
		}
		if($endViewPageLink < 1){
			return null;
		}

		foreach($attributeArray as $attribute){
			if($attribute->key == $this->parameterPageString){
				continue;
			}
			if($attribute->key == $this->parameterPageParString){
				$pageAttributeString .= "&" . $attribute->key . "=" . urlencode($attribute->value);
				continue;
			}
			$pageAttributeString .= "&" . $attribute->key . "=" . urlencode($attribute->value);
			$pageParAttributeString .= "&" . $attribute->key . "=" . urlencode($attribute->value);
		}

		$text = "Page:";
		for($i = $startViewPageLink; $i <= $endViewPageLink; $i++){
			if($i == $page){
				$text .= $i;
			}else{
				$text .= "<a href=\"" . $this->scriptname . "?";
				$text .= $this->parameterPageString . "=" . $i . $pageAttributeString ."\">";
				$text .= $i;
				$text .= "</a>";
			}
			if($i != $totalPageCount){
				$text .= "&nbsp;";
			}
		}

		$text .= "&nbsp;";
		$text .= "&nbsp;";
		$text .= "&nbsp;";
		$text .= "Items:";
		foreach($this->pageParItemType as $pageParItemKey=>$pageParItemValue){
			if($pageParItemValue == $this->pageParItems){
				$text .= $pageParItemValue . "&nbsp;";
			}else{
				$text .= "<a href=\"" . $this->scriptname . "?";
				$text .= $this->parameterPageString . "=1" . $pageParAttributeString;
				$text .= "&" . $this->parameterPageParString . "=" . $pageParItemValue . "\">";
				$text .= $pageParItemKey;
				$text .= "</a>&nbsp;";
			}
		}
		return $text;
	}
}
?>